/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.metadata.FileSystemBackedTableMetadata;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.TableMetadataFactory;
import org.apache.hudi.storage.HoodieStorage;

public class NativeTableMetadataFactory
extends TableMetadataFactory {
    private static final NativeTableMetadataFactory INSTANCE = new NativeTableMetadataFactory();

    public static NativeTableMetadataFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public HoodieTableMetadata create(HoodieEngineContext engineContext, HoodieStorage storage, HoodieMetadataConfig metadataConfig, String datasetBasePath, boolean reuse) {
        if (metadataConfig.isEnabled()) {
            HoodieBackedTableMetadata metadata = this.createHoodieBackedTableMetadata(engineContext, storage, metadataConfig, datasetBasePath, reuse);
            if (metadata.isMetadataTableInitialized()) {
                return metadata;
            }
            LOG.warn("Falling back to FileSystemBackedTableMetadata as metadata table is not initialized");
        }
        return this.createFSBackedTableMetadata(engineContext, storage, datasetBasePath);
    }

    private FileSystemBackedTableMetadata createFSBackedTableMetadata(HoodieEngineContext engineContext, HoodieStorage storage, String datasetBasePath) {
        return new FileSystemBackedTableMetadata(engineContext, storage, datasetBasePath);
    }

    private HoodieBackedTableMetadata createHoodieBackedTableMetadata(HoodieEngineContext engineContext, HoodieStorage storage, HoodieMetadataConfig metadataConfig, String datasetBasePath, boolean reuse) {
        return new HoodieBackedTableMetadata(engineContext, storage, metadataConfig, datasetBasePath, reuse);
    }
}

