/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.metadata.HoodieMetadataPayload;

public class SecondaryIndexKeyUtils {
    public static final char NULL_CHAR = '\u0000';
    public static final char ESCAPE_CHAR = '\\';

    public static Pair<String, String> getSecondaryKeyRecordKeyPair(String secIdxRecKey) {
        int delimiterIndex = SecondaryIndexKeyUtils.getSecondaryIndexKeySeparatorPosition(secIdxRecKey);
        return Pair.of(SecondaryIndexKeyUtils.unescapeSpecialChars(secIdxRecKey.substring(0, delimiterIndex)), SecondaryIndexKeyUtils.unescapeSpecialChars(secIdxRecKey.substring(delimiterIndex + 1)));
    }

    public static Pair<String, String> getRecordKeySecondaryKeyPair(String secIdxRecKey) {
        int delimiterIndex = SecondaryIndexKeyUtils.getSecondaryIndexKeySeparatorPosition(secIdxRecKey);
        return Pair.of(SecondaryIndexKeyUtils.unescapeSpecialChars(secIdxRecKey.substring(delimiterIndex + 1)), SecondaryIndexKeyUtils.unescapeSpecialChars(secIdxRecKey.substring(0, delimiterIndex)));
    }

    public static String getRecordKeyFromSecondaryIndexKey(String secIdxRecKey) {
        int delimiterIndex = SecondaryIndexKeyUtils.getSecondaryIndexKeySeparatorPosition(secIdxRecKey);
        return SecondaryIndexKeyUtils.unescapeSpecialChars(secIdxRecKey.substring(delimiterIndex + 1));
    }

    public static String getSecondaryKeyFromSecondaryIndexKey(String secIdxRecKey) {
        return SecondaryIndexKeyUtils.unescapeSpecialChars(SecondaryIndexKeyUtils.getUnescapedSecondaryKeyFromSecondaryIndexKey(secIdxRecKey));
    }

    public static String getUnescapedSecondaryKeyPrefixFromSecondaryIndexKey(String secIdxRecKey) {
        int delimiterIndex = SecondaryIndexKeyUtils.getSecondaryIndexKeySeparatorPosition(secIdxRecKey);
        return secIdxRecKey.substring(0, delimiterIndex + 1);
    }

    public static String getEscapedSecondaryKeyPrefixFromSecondaryKey(String secKey) {
        return String.format("%s%s", SecondaryIndexKeyUtils.escapeSpecialChars(secKey), Character.valueOf('$'));
    }

    public static String getUnescapedSecondaryKeyFromSecondaryIndexKey(String secIdxRecKey) {
        int delimiterIndex = SecondaryIndexKeyUtils.getSecondaryIndexKeySeparatorPosition(secIdxRecKey);
        return secIdxRecKey.substring(0, delimiterIndex);
    }

    public static String constructSecondaryIndexKey(String unescapedSecKey, String unescapedRecordKey) {
        return SecondaryIndexKeyUtils.escapeSpecialChars(unescapedSecKey) + HoodieMetadataPayload.SECONDARY_INDEX_RECORD_KEY_SEPARATOR + SecondaryIndexKeyUtils.escapeSpecialChars(unescapedRecordKey);
    }

    public static String escapeSpecialChars(String str) {
        if (str == null) {
            return String.valueOf('\u0000');
        }
        StringBuilder escaped = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (c == '\\' || c == '$' || c == '\u0000') {
                escaped.append('\\');
            }
            escaped.append(c);
        }
        return escaped.toString();
    }

    private static int getSecondaryIndexKeySeparatorPosition(String key) {
        int delimiterIndex = -1;
        boolean isEscape = false;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c == '\\' && !isEscape) {
                isEscape = true;
                continue;
            }
            if (c == '$' && !isEscape) {
                delimiterIndex = i;
                break;
            }
            isEscape = false;
        }
        ValidationUtils.checkState((delimiterIndex != -1 ? 1 : 0) != 0, (String)"Invalid encoded key format");
        return delimiterIndex;
    }

    public static String unescapeSpecialChars(String str) {
        if (str.equals(String.valueOf('\u0000'))) {
            return null;
        }
        StringBuilder unescaped = new StringBuilder();
        boolean isEscape = false;
        for (char c : str.toCharArray()) {
            if (isEscape) {
                unescaped.append(c);
                isEscape = false;
                continue;
            }
            if (c == '\\') {
                isEscape = true;
                continue;
            }
            unescaped.append(c);
        }
        return unescaped.toString();
    }
}

