/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Objects;
import org.apache.hudi.metadata.RawKey;
import org.apache.hudi.metadata.SecondaryIndexKeyUtils;

public class SecondaryIndexPrefixRawKey
implements RawKey {
    private final String secondaryKey;

    public SecondaryIndexPrefixRawKey(String secondaryKey) {
        this.secondaryKey = secondaryKey;
    }

    @Override
    public String encode() {
        return SecondaryIndexKeyUtils.getEscapedSecondaryKeyPrefixFromSecondaryKey(this.secondaryKey);
    }

    public String getSecondaryKey() {
        return this.secondaryKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecondaryIndexPrefixRawKey that = (SecondaryIndexPrefixRawKey)o;
        return Objects.equals(this.secondaryKey, that.secondaryKey);
    }

    public int hashCode() {
        return Objects.hash(this.secondaryKey);
    }

    public String toString() {
        return "SecondaryIndexKey{secondaryKey='" + this.secondaryKey + '\'' + '}';
    }
}

