/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.datadog;

import java.io.Closeable;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatadogHttpClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DatadogHttpClient.class);
    private static final String DEFAULT_HOST = "app.us.datadoghq";
    private static final String SERIES_URL_FORMAT = "https://%s.%s/api/v1/series";
    private static final String VALIDATE_URL_FORMAT = "https://%s.%s/api/v1/validate";
    private static final String HEADER_KEY_API_KEY = "DD-API-KEY";
    private final String apiKey;
    private final String seriesUrl;
    private final String validateUrl;
    private final CloseableHttpClient client;

    public DatadogHttpClient(ApiSite apiSite, String apiKey, boolean skipValidation, CloseableHttpClient client, Option<String> host) {
        this.apiKey = apiKey;
        this.seriesUrl = String.format(SERIES_URL_FORMAT, host.orElse((Object)DEFAULT_HOST), apiSite.getDomain());
        this.validateUrl = String.format(VALIDATE_URL_FORMAT, host.orElse((Object)DEFAULT_HOST), apiSite.getDomain());
        this.client = client;
        if (!skipValidation) {
            this.validateApiKey();
        }
    }

    public DatadogHttpClient(ApiSite apiSite, String apiKey, boolean skipValidation, CloseableHttpClient client) {
        this(apiSite, apiKey, skipValidation, client, (Option<String>)Option.of((Object)DEFAULT_HOST));
    }

    public DatadogHttpClient(ApiSite apiSite, String apiKey, boolean skipValidation, int timeoutSeconds, Option<String> host) {
        this(apiSite, apiKey, skipValidation, HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(timeoutSeconds * 1000).setConnectionRequestTimeout(timeoutSeconds * 1000).setSocketTimeout(timeoutSeconds * 1000).build()).build(), host);
    }

    private void validateApiKey() {
        ValidationUtils.checkArgument((!StringUtils.isNullOrEmpty((String)this.apiKey) ? 1 : 0) != 0, (String)"API key is null or empty.");
        HttpGet request = new HttpGet(this.validateUrl);
        request.setHeader(HEADER_KEY_API_KEY, this.apiKey);
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
            int statusCode = response.getStatusLine().getStatusCode();
            ValidationUtils.checkState((statusCode == 200 ? 1 : 0) != 0, (String)"API key is invalid.");
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to connect to Datadog to validate API key.", e);
        }
    }

    public void send(String payload) {
        HttpPost request = new HttpPost(this.seriesUrl);
        request.setHeader(HEADER_KEY_API_KEY, this.apiKey);
        request.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        request.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode >= 300) {
                LOG.error("Failed to send to Datadog. Response was {}", (Object)response);
            } else {
                LOG.debug("Sent metrics data (size: {}) to {}", (Object)payload.length(), (Object)this.seriesUrl);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to send to Datadog.", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public static enum ApiSite {
        US("com"),
        EU("eu");

        private final String domain;

        private ApiSite(String domain) {
            this.domain = domain;
        }

        public String getDomain() {
            return this.domain;
        }
    }
}

