/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.prometheus;

import com.codahale.metrics.MetricRegistry;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.dropwizard.samplebuilder.DefaultSampleBuilder;
import io.prometheus.client.dropwizard.samplebuilder.SampleBuilder;
import io.prometheus.client.exporter.HTTPServer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusReporter
extends MetricsReporter {
    private static final Pattern LABEL_PATTERN = Pattern.compile("\\s*,\\s*");
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusReporter.class);
    private static final Map<Integer, PrometheusServerState> PORT_TO_SERVER_STATE = new ConcurrentHashMap<Integer, PrometheusServerState>();
    private final DropwizardExports metricExports;
    private final CollectorRegistry collectorRegistry;
    private final int serverPort;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private volatile boolean unregistered = false;

    public PrometheusReporter(HoodieMetricsConfig metricsConfig, MetricRegistry registry) {
        this.serverPort = metricsConfig.getPrometheusPort();
        ArrayList<String> labelNames = new ArrayList<String>();
        ArrayList<String> labelValues = new ArrayList<String>();
        if (StringUtils.nonEmpty((String)metricsConfig.getPushGatewayLabels())) {
            LABEL_PATTERN.splitAsStream(metricsConfig.getPushGatewayLabels().trim()).map(s -> s.split(":", 2)).forEach(parts -> {
                labelNames.add(parts[0]);
                labelValues.add(parts[1]);
            });
        }
        this.metricExports = new DropwizardExports(registry, (SampleBuilder)new LabeledSampleBuilder(labelNames, labelValues));
        PrometheusServerState serverState = PrometheusReporter.getAndRegisterServerState(this.serverPort, this.metricExports);
        this.collectorRegistry = serverState.getCollectorRegistry();
        LOG.debug("Registered PrometheusReporter for port {}, reference count: {}", (Object)this.serverPort, (Object)serverState.getReferenceCount().get());
    }

    private static synchronized PrometheusServerState getAndRegisterServerState(int serverPort, DropwizardExports metricExports) {
        PrometheusServerState serverState = PORT_TO_SERVER_STATE.get(serverPort);
        if (serverState == null) {
            try {
                CollectorRegistry collectorRegistry = new CollectorRegistry();
                HTTPServer server = new HTTPServer(new InetSocketAddress(serverPort), collectorRegistry, true);
                serverState = new PrometheusServerState(server, collectorRegistry);
                PORT_TO_SERVER_STATE.put(serverPort, serverState);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        server.close();
                    }
                    catch (Exception e) {
                        LOG.debug("Error closing Prometheus HTTP server during shutdown: {}", (Object)e.getMessage());
                    }
                }));
            }
            catch (Exception e) {
                String msg = "Could not start PrometheusReporter HTTP server on port " + serverPort;
                LOG.error(msg, (Throwable)e);
                throw new HoodieException(msg, (Throwable)e);
            }
        }
        metricExports.register(serverState.getCollectorRegistry());
        serverState.getExports().add(metricExports);
        serverState.getReferenceCount().incrementAndGet();
        return serverState;
    }

    @Override
    public void start() {
    }

    @Override
    public void report() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.stopped.getAndSet(true)) {
            try {
                Class<PrometheusReporter> clazz = PrometheusReporter.class;
                synchronized (PrometheusReporter.class) {
                    LOG.debug("PrometheusReporter.stop() called for port {}", (Object)this.serverPort);
                    PrometheusServerState serverState = PORT_TO_SERVER_STATE.get(this.serverPort);
                    if (serverState == null) {
                        LOG.warn("No server state found for port {} during stop()", (Object)this.serverPort);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    this.unregisterMetricExports();
                    this.removeFromExportsTracking(serverState);
                    int newReferenceCount = this.decrementReferenceCount(serverState);
                    if (newReferenceCount <= 0) {
                        PrometheusReporter.cleanupServer(this.serverPort);
                    } else {
                        LOG.debug("Prometheus server on port {} still has {} references, keeping server alive", (Object)this.serverPort, (Object)newReferenceCount);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                LOG.error("Error in PrometheusReporter.stop() for port {}", (Object)this.serverPort, (Object)e);
            }
        }
        {
            return;
        }
    }

    private void unregisterMetricExports() {
        if (!this.unregistered) {
            try {
                this.collectorRegistry.unregister((Collector)this.metricExports);
                this.unregistered = true;
            }
            catch (Exception e) {
                LOG.debug("Error unregistering metric exports for port {}: {}", (Object)this.serverPort, (Object)e.getMessage());
            }
        }
    }

    private void removeFromExportsTracking(PrometheusServerState serverState) {
        serverState.getExports().remove(this.metricExports);
    }

    private int decrementReferenceCount(PrometheusServerState serverState) {
        int newCount = serverState.getReferenceCount().decrementAndGet();
        LOG.debug("Unregistered PrometheusReporter for port {}, reference count: {}", (Object)this.serverPort, (Object)newCount);
        return newCount;
    }

    private static synchronized void cleanupServer(int serverPort) {
        LOG.info("No more references to Prometheus server on port {}, stopping server", (Object)serverPort);
        PrometheusServerState serverState = PORT_TO_SERVER_STATE.remove(serverPort);
        if (serverState != null) {
            try {
                serverState.getHttpServer().close();
            }
            catch (Exception e) {
                LOG.debug("Error closing Prometheus HTTP server on port {}: {}", (Object)serverPort, (Object)e.getMessage());
            }
        }
    }

    public static boolean isServerRunning(int port) {
        return PORT_TO_SERVER_STATE.containsKey(port);
    }

    public static int getReferenceCount(int port) {
        PrometheusServerState serverState = PORT_TO_SERVER_STATE.get(port);
        return serverState != null ? serverState.getReferenceCount().get() : 0;
    }

    public static int getActiveExportsCount(int port) {
        PrometheusServerState serverState = PORT_TO_SERVER_STATE.get(port);
        return serverState != null ? serverState.getExports().size() : 0;
    }

    private static class LabeledSampleBuilder
    implements SampleBuilder {
        private final DefaultSampleBuilder defaultMetricSampleBuilder = new DefaultSampleBuilder();
        private final List<String> labelNames;
        private final List<String> labelValues;

        public LabeledSampleBuilder(List<String> labelNames, List<String> labelValues) {
            this.labelNames = labelNames;
            this.labelValues = labelValues;
        }

        public Collector.MetricFamilySamples.Sample createSample(String dropwizardName, String nameSuffix, List<String> additionalLabelNames, List<String> additionalLabelValues, double value) {
            return this.defaultMetricSampleBuilder.createSample(dropwizardName, nameSuffix, this.labelNames, this.labelValues, value);
        }
    }

    private static class PrometheusServerState {
        private final HTTPServer httpServer;
        private final CollectorRegistry collectorRegistry;
        private final AtomicInteger referenceCount;
        private final Set<DropwizardExports> exports;

        public PrometheusServerState(HTTPServer httpServer, CollectorRegistry collectorRegistry) {
            this.httpServer = httpServer;
            this.collectorRegistry = collectorRegistry;
            this.referenceCount = new AtomicInteger(0);
            this.exports = ConcurrentHashMap.newKeySet();
        }

        public HTTPServer getHttpServer() {
            return this.httpServer;
        }

        public CollectorRegistry getCollectorRegistry() {
            return this.collectorRegistry;
        }

        public AtomicInteger getReferenceCount() {
            return this.referenceCount;
        }

        public Set<DropwizardExports> getExports() {
            return this.exports;
        }
    }
}

