/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.stats;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.stats.ValueMetadata;
import org.apache.hudi.stats.ValueType;

public class HoodieColumnRangeMetadata<T extends Comparable>
implements Serializable {
    private final String filePath;
    private final String columnName;
    @Nullable
    private final T minValue;
    @Nullable
    private final T maxValue;
    private final long nullCount;
    private final long valueCount;
    private final long totalSize;
    private final long totalUncompressedSize;
    private final ValueMetadata valueMetadata;

    private HoodieColumnRangeMetadata(String filePath, String columnName, @Nullable T minValue, @Nullable T maxValue, long nullCount, long valueCount, long totalSize, long totalUncompressedSize, ValueMetadata valueMetadata) {
        this.filePath = filePath;
        this.columnName = columnName;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.nullCount = nullCount;
        this.valueCount = valueCount;
        this.totalSize = totalSize;
        this.totalUncompressedSize = totalUncompressedSize;
        this.valueMetadata = valueMetadata;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getColumnName() {
        return this.columnName;
    }

    @Nullable
    public T getMinValue() {
        return this.minValue;
    }

    public Object getMinValueWrapped() {
        return this.getValueMetadata().wrapValue((Comparable<?>)this.getMinValue());
    }

    @Nullable
    public T getMaxValue() {
        return this.maxValue;
    }

    public Object getMaxValueWrapped() {
        return this.getValueMetadata().wrapValue((Comparable<?>)this.getMaxValue());
    }

    public long getNullCount() {
        return this.nullCount;
    }

    public long getValueCount() {
        return this.valueCount;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getTotalUncompressedSize() {
        return this.totalUncompressedSize;
    }

    public ValueMetadata getValueMetadata() {
        return this.valueMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieColumnRangeMetadata that = (HoodieColumnRangeMetadata)o;
        return Objects.equals(this.getFilePath(), that.getFilePath()) && Objects.equals(this.getColumnName(), that.getColumnName()) && Objects.equals(this.getMinValue(), that.getMinValue()) && Objects.equals(this.getMaxValue(), that.getMaxValue()) && Objects.equals(this.getNullCount(), that.getNullCount()) && Objects.equals(this.getValueCount(), that.getValueCount()) && Objects.equals(this.getTotalSize(), that.getTotalSize()) && Objects.equals(this.getTotalUncompressedSize(), that.getTotalUncompressedSize());
    }

    public int hashCode() {
        return Objects.hash(this.getColumnName(), this.getMinValue(), this.getMaxValue(), this.getNullCount());
    }

    public String toString() {
        return "HoodieColumnRangeMetadata{filePath ='" + this.filePath + '\'' + ", columnName='" + this.columnName + '\'' + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + ", nullCount=" + this.nullCount + ", valueCount=" + this.valueCount + ", totalSize=" + this.totalSize + ", totalUncompressedSize=" + this.totalUncompressedSize + '}';
    }

    public static <T extends Comparable<T>> HoodieColumnRangeMetadata<T> create(String filePath, String columnName, @Nullable T minValue, @Nullable T maxValue, long nullCount, long valueCount, long totalSize, long totalUncompressedSize, ValueMetadata valueMetadata) throws IllegalArgumentException {
        valueMetadata.validate(minValue, maxValue);
        return new HoodieColumnRangeMetadata<T>(filePath, columnName, minValue, maxValue, nullCount, valueCount, totalSize, totalUncompressedSize, valueMetadata);
    }

    public static HoodieColumnRangeMetadata<Comparable> fromColumnStats(HoodieMetadataColumnStats columnStats) {
        ValueMetadata valueMetadata = ValueMetadata.getValueMetadata(columnStats.getValueType());
        return HoodieColumnRangeMetadata.create(columnStats.getFileName(), columnStats.getColumnName(), valueMetadata.unwrapValue(columnStats.getMinValue()), valueMetadata.unwrapValue(columnStats.getMaxValue()), columnStats.getNullCount(), columnStats.getValueCount(), columnStats.getTotalSize(), columnStats.getTotalUncompressedSize(), valueMetadata);
    }

    public static HoodieColumnRangeMetadata<Comparable> stub(String filePath, String columnName, HoodieIndexVersion indexVersion) {
        return new HoodieColumnRangeMetadata<Object>(filePath, columnName, null, null, -1L, -1L, -1L, -1L, ValueMetadata.getEmptyValueMetadata(indexVersion));
    }

    public static HoodieColumnRangeMetadata<Comparable> createEmpty(String filePath, String columnName, HoodieIndexVersion indexVersion) {
        return new HoodieColumnRangeMetadata<Object>(filePath, columnName, null, null, 0L, 0L, 0L, 0L, ValueMetadata.getEmptyValueMetadata(indexVersion));
    }

    public static <T extends Comparable<T>> HoodieColumnRangeMetadata<T> merge(HoodieColumnRangeMetadata<T> left, HoodieColumnRangeMetadata<T> right) {
        if (left == null || right == null) {
            return left == null ? right : left;
        }
        if (left.getValueMetadata().getValueType() != right.getValueMetadata().getValueType()) {
            throw new IllegalArgumentException("Value types should be the same for merging column ranges");
        }
        if (left.getValueMetadata().getValueType() != ValueType.V1) {
            if (left.minValue != null && right.minValue != null && left.minValue.getClass() != right.minValue.getClass()) {
                throw new IllegalArgumentException("Value types should be the same for merging column ranges");
            }
            if (left.maxValue != null && right.maxValue != null && left.maxValue.getClass() != right.maxValue.getClass()) {
                throw new IllegalArgumentException("Value types should be the same for merging column ranges");
            }
        }
        ValidationUtils.checkArgument((boolean)left.getColumnName().equals(right.getColumnName()), (String)"Column names should be the same for merging column ranges");
        String filePath = left.getFilePath();
        String columnName = left.getColumnName();
        T min = HoodieColumnRangeMetadata.minVal(left.getMinValue(), right.getMinValue());
        T max = HoodieColumnRangeMetadata.maxVal(left.getMaxValue(), right.getMaxValue());
        long nullCount = left.getNullCount() + right.getNullCount();
        long valueCount = left.getValueCount() + right.getValueCount();
        long totalSize = left.getTotalSize() + right.getTotalSize();
        long totalUncompressedSize = left.getTotalUncompressedSize() + right.getTotalUncompressedSize();
        return new HoodieColumnRangeMetadata<T>(filePath, columnName, min, max, nullCount, valueCount, totalSize, totalUncompressedSize, left.getValueMetadata());
    }

    private static <T extends Comparable<T>> T minVal(T val1, T val2) {
        if (val1 == null) {
            return val2;
        }
        if (val2 == null) {
            return val1;
        }
        return val1.compareTo(val2) < 0 ? val1 : val2;
    }

    private static <T extends Comparable<T>> T maxVal(T val1, T val2) {
        if (val1 == null) {
            return val2;
        }
        if (val2 == null) {
            return val1;
        }
        return val1.compareTo(val2) > 0 ? val1 : val2;
    }
}

