/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.stats;

import java.io.Serializable;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.ParquetAdapter;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.model.HoodieValueTypeInfo;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.stats.ValueType;
import org.apache.parquet.schema.PrimitiveType;

public class ValueMetadata
implements Serializable {
    private static final ParquetAdapter PARQUET_ADAPTER = ParquetAdapter.getAdapter();
    private final ValueType valueType;
    public static final ValueMetadata NULL_METADATA = new ValueMetadata(ValueType.NULL);

    protected ValueMetadata(ValueType valueType) {
        this.valueType = valueType;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public HoodieValueTypeInfo getValueTypeInfo() {
        return HoodieValueTypeInfo.newBuilder().setTypeOrdinal(this.valueType.ordinal()).setAdditionalInfo(this.getAdditionalInfo()).build();
    }

    String getAdditionalInfo() {
        return null;
    }

    public Comparable<?> standardizeJavaTypeAndPromote(Object val) {
        return this.getValueType().standardizeJavaTypeAndPromote(val, this);
    }

    public Object wrapValue(Comparable<?> value) {
        return this.getValueType().wrapValue(value, this);
    }

    public Comparable<?> unwrapValue(Object value) {
        return this.getValueType().unwrapValue(value, this);
    }

    public void validate(Object minVal, Object maxVal) {
        if (this.getValueType() == ValueType.V1) {
            return;
        }
        this.getValueType().validate(minVal);
        this.getValueType().validate(maxVal);
    }

    public boolean isV1() {
        return this.getValueType() == ValueType.V1;
    }

    public static ValueMetadata getEmptyValueMetadata(HoodieIndexVersion indexVersion) {
        if (indexVersion.lowerThan(HoodieIndexVersion.V2)) {
            return V1EmptyMetadata.get();
        }
        return NULL_METADATA;
    }

    public static ValueMetadata getValueMetadata(HoodieValueTypeInfo valueTypeInfo) {
        if (valueTypeInfo == null) {
            return V1EmptyMetadata.get();
        }
        ValueType valueType = ValueType.fromOrdinal(valueTypeInfo.getTypeOrdinal());
        if (valueType == ValueType.V1) {
            return V1EmptyMetadata.get();
        }
        if (valueType == ValueType.DECIMAL) {
            return DecimalMetadata.create(valueTypeInfo.getAdditionalInfo());
        }
        return new ValueMetadata(valueType);
    }

    public static ValueMetadata getValueMetadata(GenericRecord columnStatsRecord) {
        if (columnStatsRecord == null) {
            throw new IllegalStateException("ColumnStatsMetadata is null. Handling should happen in the caller.");
        }
        if (!columnStatsRecord.hasField("valueType")) {
            return V1EmptyMetadata.get();
        }
        GenericRecord valueTypeInfo = (GenericRecord)columnStatsRecord.get("valueType");
        if (valueTypeInfo == null) {
            return V1EmptyMetadata.get();
        }
        ValueType valueType = ValueType.fromOrdinal((Integer)valueTypeInfo.get("typeOrdinal"));
        if (valueType == ValueType.V1) {
            throw new IllegalArgumentException("Unsupported value type: " + valueTypeInfo.get("typeOrdinal"));
        }
        if (valueType == ValueType.DECIMAL) {
            return DecimalMetadata.create((String)valueTypeInfo.get("additionalInfo"));
        }
        return new ValueMetadata(valueType);
    }

    public static ValueMetadata getValueMetadata(Schema fieldSchema, HoodieIndexVersion indexVersion) {
        if (indexVersion.lowerThan(HoodieIndexVersion.V2)) {
            return V1EmptyMetadata.get();
        }
        if (fieldSchema == null) {
            throw new IllegalArgumentException("Field schema cannot be null");
        }
        Schema valueSchema = AvroSchemaUtils.getNonNullTypeFromUnion(fieldSchema);
        ValueType valueType = ValueType.fromSchema(valueSchema);
        if (valueType == ValueType.V1) {
            throw new IllegalArgumentException("Unsupported logical type for: " + valueSchema.getLogicalType());
        }
        if (valueType == ValueType.DECIMAL) {
            return DecimalMetadata.create((LogicalTypes.Decimal)valueSchema.getLogicalType());
        }
        return new ValueMetadata(valueType);
    }

    public static ValueMetadata getValueMetadata(PrimitiveType primitiveType, HoodieIndexVersion indexVersion) {
        if (indexVersion.lowerThan(HoodieIndexVersion.V2)) {
            return V1EmptyMetadata.get();
        }
        if (primitiveType == null) {
            throw new IllegalArgumentException("Primitive type cannot be null");
        }
        ValueType valueType = ValueType.fromParquetPrimitiveType(primitiveType);
        if (valueType == ValueType.V1) {
            throw new IllegalStateException("Returned ValueType should never be V1 here. Primitive type: " + primitiveType);
        }
        if (valueType == ValueType.DECIMAL) {
            return DecimalMetadata.create(primitiveType);
        }
        return new ValueMetadata(valueType);
    }

    static class DecimalMetadata
    extends ValueMetadata
    implements DecimalValueMetadata {
        private final int precision;
        private final int scale;

        static DecimalMetadata create(String additionalInfo) {
            if (additionalInfo == null) {
                throw new IllegalArgumentException("additionalInfo cannot be null");
            }
            Pair<Integer, Integer> data = DecimalValueMetadata.decodeData(additionalInfo);
            return new DecimalMetadata(data.getLeft(), data.getRight());
        }

        static DecimalMetadata create(LogicalTypes.Decimal decimal) {
            return new DecimalMetadata(decimal.getPrecision(), decimal.getScale());
        }

        static DecimalMetadata create(PrimitiveType primitiveType) {
            return new DecimalMetadata(PARQUET_ADAPTER.getPrecision(primitiveType), PARQUET_ADAPTER.getScale(primitiveType));
        }

        static DecimalMetadata create(int precision, int scale) {
            return new DecimalMetadata(precision, scale);
        }

        private DecimalMetadata(int precision, int scale) {
            super(ValueType.DECIMAL);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public int getPrecision() {
            return this.precision;
        }

        @Override
        public int getScale() {
            return this.scale;
        }

        @Override
        String getAdditionalInfo() {
            return DecimalValueMetadata.encodeData(this);
        }
    }

    static interface DecimalValueMetadata {
        public int getPrecision();

        public int getScale();

        public static String encodeData(DecimalValueMetadata decimalValueMetadata) {
            return String.format("%d,%d", decimalValueMetadata.getPrecision(), decimalValueMetadata.getScale());
        }

        public static Pair<Integer, Integer> decodeData(String data) {
            String[] splits = data.split(",");
            return Pair.of(Integer.parseInt(splits[0]), Integer.parseInt(splits[1]));
        }
    }

    public static class V1EmptyMetadata
    extends ValueMetadata {
        private static final V1EmptyMetadata V1_EMPTY_METADATA = new V1EmptyMetadata();

        public static V1EmptyMetadata get() {
            return V1_EMPTY_METADATA;
        }

        private V1EmptyMetadata() {
            super(ValueType.V1);
        }

        @Override
        public HoodieValueTypeInfo getValueTypeInfo() {
            return null;
        }
    }
}

