/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.stats;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.hudi.ParquetAdapter;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.HoodieAvroWrapperUtils;
import org.apache.hudi.common.util.DateTimeUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.stats.ValueMetadata;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;

public enum ValueType {
    V1(HoodieAvroWrapperUtils.PrimitiveWrapperType.V1.getClazz(), HoodieAvroWrapperUtils.PrimitiveWrapperType.V1, ValueType::passThrough, ValueType::passThrough, ValueType::passThrough),
    NULL(HoodieAvroWrapperUtils.PrimitiveWrapperType.NULL.getClazz(), HoodieAvroWrapperUtils.PrimitiveWrapperType.NULL, ValueType::passThrough, ValueType::passThrough, ValueType::passThrough),
    BOOLEAN(HoodieAvroWrapperUtils.PrimitiveWrapperType.BOOLEAN, ValueType::castToBoolean),
    INT(HoodieAvroWrapperUtils.PrimitiveWrapperType.INT, ValueType::castToInteger),
    LONG(HoodieAvroWrapperUtils.PrimitiveWrapperType.LONG, ValueType::castToLong),
    FLOAT(HoodieAvroWrapperUtils.PrimitiveWrapperType.FLOAT, ValueType::castToFloat),
    DOUBLE(HoodieAvroWrapperUtils.PrimitiveWrapperType.DOUBLE, ValueType::castToDouble),
    STRING(HoodieAvroWrapperUtils.PrimitiveWrapperType.STRING, ValueType::castToString),
    BYTES(HoodieAvroWrapperUtils.PrimitiveWrapperType.BYTES, ValueType::castToBytes),
    FIXED(HoodieAvroWrapperUtils.PrimitiveWrapperType.BYTES, ValueType::castToFixed),
    DECIMAL(BigDecimal.class, HoodieAvroWrapperUtils.PrimitiveWrapperType.BYTES, ValueType::castToDecimal, ValueType::toDecimal, ValueType::fromDecimal),
    UUID(UUID.class, HoodieAvroWrapperUtils.PrimitiveWrapperType.STRING, ValueType::castToUUID, ValueType::toUUID, ValueType::fromUUID),
    DATE(LocalDate.class, HoodieAvroWrapperUtils.PrimitiveWrapperType.INT, ValueType::castToDate, ValueType::toDate, ValueType::fromDate),
    TIME_MILLIS(LocalTime.class, HoodieAvroWrapperUtils.PrimitiveWrapperType.INT, ValueType::castToTimeMillis, ValueType::toTimeMillis, ValueType::fromTimeMillis),
    TIME_MICROS(LocalTime.class, HoodieAvroWrapperUtils.PrimitiveWrapperType.LONG, ValueType::castToTimeMicros, ValueType::toTimeMicros, ValueType::fromTimeMicros),
    TIMESTAMP_MILLIS(Instant.class, HoodieAvroWrapperUtils.PrimitiveWrapperType.LONG, ValueType::castToTimestampMillis, ValueType::toTimestampMillis, ValueType::fromTimestampMillis),
    TIMESTAMP_MICROS(Instant.class, HoodieAvroWrapperUtils.PrimitiveWrapperType.LONG, ValueType::castToTimestampMicros, ValueType::toTimestampMicros, ValueType::fromTimestampMicros),
    TIMESTAMP_NANOS(Instant.class, HoodieAvroWrapperUtils.PrimitiveWrapperType.LONG, ValueType::castToTimestampNanos, ValueType::toTimestampNanos, ValueType::fromTimestampNanos),
    LOCAL_TIMESTAMP_MILLIS(LocalDateTime.class, HoodieAvroWrapperUtils.PrimitiveWrapperType.LONG, ValueType::castToLocalTimestampMillis, ValueType::toLocalTimestampMillis, ValueType::fromLocalTimestampMillis),
    LOCAL_TIMESTAMP_MICROS(LocalDateTime.class, HoodieAvroWrapperUtils.PrimitiveWrapperType.LONG, ValueType::castToLocalTimestampMicros, ValueType::toLocalTimestampMicros, ValueType::fromLocalTimestampMicros),
    LOCAL_TIMESTAMP_NANOS(LocalDateTime.class, HoodieAvroWrapperUtils.PrimitiveWrapperType.LONG, ValueType::castToLocalTimestampNanos, ValueType::toLocalTimestampNanos, ValueType::fromLocalTimestampNanos);

    private final Class<?> internalType;
    private final HoodieAvroWrapperUtils.PrimitiveWrapperType primitiveWrapperType;
    private final BiFunction<Object, ValueMetadata, Comparable<?>> standardize;
    private final BiFunction<Comparable<?>, ValueMetadata, Comparable<?>> toComposite;
    private final BiFunction<Comparable<?>, ValueMetadata, Comparable<?>> toPrimitive;
    private static ValueType[] myEnumValues;
    private static final ParquetAdapter PARQUET_ADAPTER;

    private ValueType(HoodieAvroWrapperUtils.PrimitiveWrapperType primitiveWrapperType, Function<Object, Object> single) {
        this(primitiveWrapperType.getClazz(), primitiveWrapperType, (val, meta) -> (Comparable)single.apply(val), ValueType::passThrough, ValueType::passThrough);
    }

    private ValueType(Class<?> internalType, HoodieAvroWrapperUtils.PrimitiveWrapperType primitiveWrapperType, BiFunction<Object, ValueMetadata, Comparable<?>> standardize, BiFunction<Comparable<?>, ValueMetadata, Comparable<?>> toComposite, BiFunction<Comparable<?>, ValueMetadata, Comparable<?>> toPrimitive) {
        this.internalType = internalType;
        this.primitiveWrapperType = primitiveWrapperType;
        this.standardize = standardize;
        this.toComposite = toComposite;
        this.toPrimitive = toPrimitive;
    }

    Comparable<?> standardizeJavaTypeAndPromote(Object val, ValueMetadata meta) {
        if (val == null) {
            return null;
        }
        return this.standardize.apply(val, meta);
    }

    private Comparable<?> convertIntoPrimitive(Comparable<?> val, ValueMetadata meta) {
        if (val == null) {
            return null;
        }
        return this.toPrimitive.apply(val, meta);
    }

    private Comparable<?> convertIntoComplex(Comparable<?> val, ValueMetadata meta) {
        if (val == null) {
            return null;
        }
        return this.toComposite.apply(val, meta);
    }

    void validate(Object val) {
        if (val == null) {
            return;
        }
        if (!this.internalType.isInstance(val)) {
            throw new IllegalArgumentException(String.format("should be %s, but got %s", this.internalType.getSimpleName(), val.getClass().getSimpleName()));
        }
    }

    public Object wrapValue(Comparable<?> val, ValueMetadata meta) {
        if (meta.getValueType() == V1) {
            return this.primitiveWrapperType.wrap(val);
        }
        if (val == null) {
            return null;
        }
        if (!this.internalType.isInstance(val)) {
            throw new IllegalArgumentException(String.format("should be %s, but got %s", this.internalType.getSimpleName(), val.getClass().getSimpleName()));
        }
        return this.primitiveWrapperType.wrap(this.convertIntoPrimitive(val, meta));
    }

    public Comparable<?> unwrapValue(Object val, ValueMetadata meta) {
        if (meta.getValueType() == V1) {
            return this.primitiveWrapperType.unwrap(val);
        }
        if (val == null) {
            return null;
        }
        if (!this.primitiveWrapperType.getWrapperClass().isInstance(val)) {
            if (!(val instanceof GenericRecord)) {
                throw new IllegalArgumentException(String.format("should be %s, but got %s", this.primitiveWrapperType.getWrapperClass().getSimpleName(), val.getClass().getSimpleName()));
            }
            if (((GenericRecord)val).getSchema().getField("value") != null) {
                return this.standardizeJavaTypeAndPromote(HoodieAvroWrapperUtils.unwrapGenericRecord(val), meta);
            }
            throw new IllegalArgumentException(String.format("should be %s, but got %s", this.primitiveWrapperType.getWrapperClass().getSimpleName(), val.getClass().getSimpleName()));
        }
        return this.convertIntoComplex(this.primitiveWrapperType.unwrap(val), meta);
    }

    public static ValueType fromOrdinal(int i) {
        if (myEnumValues == null) {
            myEnumValues = ValueType.values();
        }
        return myEnumValues[i];
    }

    public static ValueType fromParquetPrimitiveType(PrimitiveType primitiveType) {
        if (PARQUET_ADAPTER.hasAnnotation(primitiveType)) {
            return PARQUET_ADAPTER.getValueTypeFromAnnotation(primitiveType);
        }
        switch (primitiveType.getPrimitiveTypeName()) {
            case INT64: {
                return LONG;
            }
            case INT32: {
                return INT;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case BINARY: {
                return BYTES;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return FIXED;
            }
        }
        throw new IllegalArgumentException("Unsupported primitive type: " + primitiveType.getPrimitiveTypeName());
    }

    public static ValueType fromSchema(Schema schema) {
        switch (schema.getType()) {
            case NULL: {
                if (schema.getLogicalType() == null) {
                    return NULL;
                }
                throw new IllegalArgumentException("Unsupported logical type for Null: " + schema.getLogicalType());
            }
            case BOOLEAN: {
                if (schema.getLogicalType() == null) {
                    return BOOLEAN;
                }
                throw new IllegalArgumentException("Unsupported logical type for Boolean: " + schema.getLogicalType());
            }
            case INT: {
                if (schema.getLogicalType() == null) {
                    return INT;
                }
                if (schema.getLogicalType() instanceof LogicalTypes.Date) {
                    return DATE;
                }
                if (schema.getLogicalType() instanceof LogicalTypes.TimeMillis) {
                    return TIME_MILLIS;
                }
                throw new IllegalArgumentException("Unsupported logical type for Int: " + schema.getLogicalType());
            }
            case LONG: {
                if (schema.getLogicalType() == null) {
                    return LONG;
                }
                if (schema.getLogicalType() instanceof LogicalTypes.TimeMicros) {
                    return TIME_MICROS;
                }
                if (schema.getLogicalType() instanceof LogicalTypes.TimestampMillis) {
                    return TIMESTAMP_MILLIS;
                }
                if (schema.getLogicalType() instanceof LogicalTypes.TimestampMicros) {
                    return TIMESTAMP_MICROS;
                }
                if (schema.getLogicalType() instanceof LogicalTypes.LocalTimestampMillis) {
                    return LOCAL_TIMESTAMP_MILLIS;
                }
                if (schema.getLogicalType() instanceof LogicalTypes.LocalTimestampMicros) {
                    return LOCAL_TIMESTAMP_MICROS;
                }
                throw new IllegalArgumentException("Unsupported logical type for Long: " + schema.getLogicalType());
            }
            case FLOAT: {
                if (schema.getLogicalType() == null) {
                    return FLOAT;
                }
                throw new IllegalArgumentException("Unsupported logical type for Float: " + schema.getLogicalType());
            }
            case DOUBLE: {
                if (schema.getLogicalType() == null) {
                    return DOUBLE;
                }
                throw new IllegalArgumentException("Unsupported logical type for Double: " + schema.getLogicalType());
            }
            case BYTES: {
                if (schema.getLogicalType() == null) {
                    return BYTES;
                }
                if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    return DECIMAL;
                }
                throw new IllegalArgumentException("Unsupported logical type for Bytes: " + schema.getLogicalType());
            }
            case STRING: {
                if (schema.getLogicalType() == null) {
                    return STRING;
                }
                if (Objects.equals(schema.getLogicalType().getName(), LogicalTypes.uuid().getName())) {
                    return UUID;
                }
                throw new IllegalArgumentException("Unsupported logical type for String: " + schema.getLogicalType());
            }
            case FIXED: {
                if (schema.getLogicalType() == null) {
                    return FIXED;
                }
                if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    return DECIMAL;
                }
                throw new IllegalArgumentException("Unsupported logical type for Fixed: " + schema.getLogicalType());
            }
            case UNION: {
                return ValueType.fromSchema(AvroSchemaUtils.getNonNullTypeFromUnion(schema));
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + schema.getType());
    }

    private static Comparable<?> passThrough(Object val, ValueMetadata meta) {
        return (Comparable)val;
    }

    private static Boolean castToBoolean(Object val) {
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        throw new UnsupportedOperationException("Unable to convert boolean: " + val.getClass());
    }

    private static Integer castToInteger(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1 : 0;
        }
        return Integer.parseInt(val.toString());
    }

    private static Long castToLong(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return ((Integer)val).longValue();
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1L : 0L;
        }
        return Long.parseLong(val.toString());
    }

    private static Float castToFloat(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return Float.valueOf(((Integer)val).floatValue());
        }
        if (val instanceof Long) {
            return Float.valueOf(((Long)val).floatValue());
        }
        if (val instanceof Float) {
            return (Float)val;
        }
        if (val instanceof Boolean) {
            return Float.valueOf((Boolean)val != false ? 1.0f : 0.0f);
        }
        return Float.valueOf(Float.parseFloat(val.toString()));
    }

    private static Double castToDouble(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return ((Integer)val).doubleValue();
        }
        if (val instanceof Long) {
            return ((Long)val).doubleValue();
        }
        if (val instanceof Float) {
            return Double.valueOf(val + "");
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1.0 : 0.0;
        }
        return Double.parseDouble(val.toString());
    }

    public static String castToString(Object val) {
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof Utf8 || val instanceof Boolean || val instanceof Integer || val instanceof Long || val instanceof Float || val instanceof Double) {
            return val.toString();
        }
        if (val instanceof Binary) {
            return ((Binary)val).toStringUsingUTF8();
        }
        throw new UnsupportedOperationException("Unable to convert string: " + val.getClass());
    }

    public static ByteBuffer castToBytes(Object val) {
        if (val instanceof ByteBuffer) {
            return (ByteBuffer)val;
        }
        if (val instanceof GenericData.Fixed) {
            return ByteBuffer.wrap(((GenericData.Fixed)val).bytes());
        }
        if (val instanceof byte[]) {
            return ByteBuffer.wrap((byte[])val);
        }
        if (val instanceof Binary) {
            return ((Binary)val).toByteBuffer();
        }
        if (val instanceof String) {
            return ByteBuffer.wrap(StringUtils.getUTF8Bytes((String)val.toString()));
        }
        throw new UnsupportedOperationException("Unable to convert bytes: " + val.getClass());
    }

    public static ByteBuffer castToFixed(Object val) {
        if (val instanceof ByteBuffer) {
            return (ByteBuffer)val;
        }
        if (val instanceof GenericData.Fixed) {
            return ByteBuffer.wrap(((GenericData.Fixed)val).bytes());
        }
        if (val instanceof byte[]) {
            return ByteBuffer.wrap((byte[])val);
        }
        if (val instanceof Binary) {
            return ((Binary)val).toByteBuffer();
        }
        throw new UnsupportedOperationException("Unable to convert fixed: " + val.getClass());
    }

    public static BigDecimal castToDecimal(Object val, ValueMetadata meta) {
        ValueMetadata.DecimalValueMetadata decimalMetadata = (ValueMetadata.DecimalValueMetadata)((Object)meta);
        int precision = decimalMetadata.getPrecision();
        int scale = decimalMetadata.getScale();
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof GenericData.Fixed) {
            return HoodieAvroUtils.convertBytesToBigDecimal(((GenericData.Fixed)val).bytes(), precision, scale);
        }
        if (val instanceof ByteBuffer) {
            return HoodieAvroUtils.convertBytesToBigDecimal(((ByteBuffer)val).array(), precision, scale);
        }
        if (val instanceof byte[]) {
            return HoodieAvroUtils.convertBytesToBigDecimal((byte[])val, precision, scale);
        }
        if (val instanceof Integer) {
            return BigDecimal.valueOf(((Integer)val).intValue(), scale).round(new MathContext(precision, RoundingMode.HALF_UP));
        }
        if (val instanceof Long) {
            return BigDecimal.valueOf((Long)val, scale).round(new MathContext(precision, RoundingMode.HALF_UP));
        }
        if (val instanceof Binary) {
            return new BigDecimal(new BigInteger(((Binary)val).getBytesUnsafe()), scale, new MathContext(precision, RoundingMode.HALF_UP));
        }
        throw new UnsupportedOperationException("Unable to convert decimal: " + val.getClass());
    }

    public static UUID castToUUID(Object val, ValueMetadata meta) {
        if (val instanceof UUID) {
            return (UUID)val;
        }
        if (val instanceof String) {
            return java.util.UUID.fromString((String)val);
        }
        throw new UnsupportedOperationException("Unable to convert UUID: " + val.getClass());
    }

    public static LocalDate castToDate(Object val, ValueMetadata meta) {
        if (val instanceof LocalDate) {
            return (LocalDate)val;
        }
        if (val instanceof Date) {
            return ((Date)val).toLocalDate();
        }
        if (val instanceof Integer) {
            return LocalDate.ofEpochDay(((Integer)val).intValue());
        }
        throw new UnsupportedOperationException("Unable to convert date: " + val.getClass());
    }

    public static LocalTime castToTimeMillis(Object val, ValueMetadata meta) {
        if (val instanceof LocalTime) {
            return (LocalTime)val;
        }
        if (val instanceof Integer) {
            return LocalTime.ofNanoOfDay((long)((Integer)val).intValue() * 1000000L);
        }
        throw new UnsupportedOperationException("Unable to convert time millis: " + val.getClass());
    }

    public static LocalTime castToTimeMicros(Object val, ValueMetadata meta) {
        if (val instanceof LocalTime) {
            return (LocalTime)val;
        }
        if (val instanceof Long) {
            return LocalTime.ofNanoOfDay((Long)val * 1000L);
        }
        throw new UnsupportedOperationException("Unable to convert time micros: " + val.getClass());
    }

    public static Instant castToTimestampMillis(Object val, ValueMetadata meta) {
        if (val instanceof Instant) {
            return (Instant)val;
        }
        if (val instanceof Timestamp) {
            return ((Timestamp)val).toInstant();
        }
        if (val instanceof Long) {
            return Instant.ofEpochMilli((Long)val);
        }
        throw new UnsupportedOperationException("Unable to convert timestamp millis: " + val.getClass());
    }

    public static Instant castToTimestampMicros(Object val, ValueMetadata meta) {
        if (val instanceof Instant) {
            return (Instant)val;
        }
        if (val instanceof Timestamp) {
            return ((Timestamp)val).toInstant();
        }
        if (val instanceof Long) {
            return DateTimeUtils.microsToInstant((Long)val);
        }
        throw new UnsupportedOperationException("Unable to convert timestamp micros: " + val.getClass());
    }

    public static Instant castToTimestampNanos(Object val, ValueMetadata meta) {
        if (val instanceof Instant) {
            return (Instant)val;
        }
        if (val instanceof Long) {
            return DateTimeUtils.nanosToInstant((Long)val);
        }
        throw new UnsupportedOperationException("Unable to convert timestamp nanos: " + val.getClass());
    }

    public static LocalDateTime castToLocalTimestampMillis(Object val, ValueMetadata meta) {
        if (val instanceof LocalDateTime) {
            return (LocalDateTime)val;
        }
        if (val instanceof Long) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)val), ZoneOffset.UTC);
        }
        throw new UnsupportedOperationException("Unable to convert local timestamp millis: " + val.getClass());
    }

    public static LocalDateTime castToLocalTimestampMicros(Object val, ValueMetadata meta) {
        if (val instanceof LocalDateTime) {
            return (LocalDateTime)val;
        }
        if (val instanceof Long) {
            return LocalDateTime.ofInstant(DateTimeUtils.microsToInstant((Long)val), ZoneOffset.UTC);
        }
        throw new UnsupportedOperationException("Unable to convert local timestamp micros: " + val.getClass());
    }

    public static LocalDateTime castToLocalTimestampNanos(Object val, ValueMetadata meta) {
        if (val instanceof LocalDateTime) {
            return (LocalDateTime)val;
        }
        if (val instanceof Long) {
            return LocalDateTime.ofInstant(DateTimeUtils.nanosToInstant((Long)val), ZoneOffset.UTC);
        }
        throw new UnsupportedOperationException("Unable to convert local timestamp nanos: " + val.getClass());
    }

    public static BigDecimal toDecimal(Comparable<?> val, ValueMetadata meta) {
        ValueMetadata.DecimalMetadata decimalMeta = (ValueMetadata.DecimalMetadata)meta;
        return HoodieAvroUtils.convertBytesToBigDecimal(((ByteBuffer)val).array(), decimalMeta.getPrecision(), decimalMeta.getScale());
    }

    public static ByteBuffer fromDecimal(Comparable<?> val, ValueMetadata meta) {
        return ByteBuffer.wrap(((BigDecimal)val).unscaledValue().toByteArray());
    }

    public static UUID toUUID(Comparable<?> val, ValueMetadata meta) {
        return java.util.UUID.fromString((String)((Object)val));
    }

    public static String fromUUID(Comparable<?> val, ValueMetadata meta) {
        return ((UUID)val).toString();
    }

    public static LocalDate toDate(Comparable<?> val, ValueMetadata meta) {
        return LocalDate.ofEpochDay(((Integer)val).intValue());
    }

    public static Integer fromDate(Comparable<?> val, ValueMetadata meta) {
        return Long.valueOf(((LocalDate)val).toEpochDay()).intValue();
    }

    public static LocalTime toTimeMillis(Comparable<?> val, ValueMetadata meta) {
        return LocalTime.ofNanoOfDay((long)((Integer)val).intValue() * 1000000L);
    }

    public static Integer fromTimeMillis(Comparable<?> val, ValueMetadata meta) {
        return ((LocalTime)val).toSecondOfDay() * 1000 + ((LocalTime)val).getNano() / 1000000;
    }

    public static LocalTime toTimeMicros(Comparable<?> val, ValueMetadata meta) {
        return LocalTime.ofNanoOfDay((Long)val * 1000L);
    }

    public static Long fromTimeMicros(Comparable<?> val, ValueMetadata meta) {
        return (long)((LocalTime)val).toSecondOfDay() * 1000000L + (long)(((LocalTime)val).getNano() / 1000);
    }

    public static Instant toTimestampMillis(Comparable<?> val, ValueMetadata meta) {
        return Instant.ofEpochMilli((Long)val);
    }

    public static Long fromTimestampMillis(Comparable<?> val, ValueMetadata meta) {
        return ((Instant)val).toEpochMilli();
    }

    public static Instant toTimestampMicros(Comparable<?> val, ValueMetadata meta) {
        return DateTimeUtils.microsToInstant((Long)val);
    }

    public static Long fromTimestampMicros(Comparable<?> val, ValueMetadata meta) {
        return DateTimeUtils.instantToMicros((Instant)val);
    }

    public static Instant toTimestampNanos(Comparable<?> val, ValueMetadata meta) {
        return DateTimeUtils.nanosToInstant((Long)val);
    }

    public static Long fromTimestampNanos(Comparable<?> val, ValueMetadata meta) {
        return DateTimeUtils.instantToNanos((Instant)val);
    }

    public static LocalDateTime toLocalTimestampMillis(Comparable<?> val, ValueMetadata meta) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)val), ZoneOffset.UTC);
    }

    public static Long fromLocalTimestampMillis(Comparable<?> val, ValueMetadata meta) {
        return ((LocalDateTime)val).toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public static LocalDateTime toLocalTimestampMicros(Comparable<?> val, ValueMetadata meta) {
        return LocalDateTime.ofInstant(DateTimeUtils.microsToInstant((Long)val), ZoneOffset.UTC);
    }

    public static Long fromLocalTimestampMicros(Comparable<?> val, ValueMetadata meta) {
        return DateTimeUtils.instantToMicros(((LocalDateTime)val).toInstant(ZoneOffset.UTC));
    }

    public static LocalDateTime toLocalTimestampNanos(Comparable<?> val, ValueMetadata meta) {
        return LocalDateTime.ofInstant(DateTimeUtils.nanosToInstant((Long)val), ZoneOffset.UTC);
    }

    public static Long fromLocalTimestampNanos(Comparable<?> val, ValueMetadata meta) {
        return DateTimeUtils.instantToNanos(((LocalDateTime)val).toInstant(ZoneOffset.UTC));
    }

    static {
        PARQUET_ADAPTER = ParquetAdapter.getAdapter();
    }
}

