/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.utils.URIBuilder;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.timeline.TimelineServiceClientBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimelineServiceClient
extends TimelineServiceClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineServiceClient.class);
    private static final String DEFAULT_SCHEME = "http";
    protected final String timelineServerHost;
    protected final int timelineServerPort;
    protected final int timeoutMs;

    public TimelineServiceClient(FileSystemViewStorageConfig config) {
        super(config);
        this.timelineServerHost = config.getRemoteViewServerHost();
        this.timelineServerPort = config.getRemoteViewServerPort();
        this.timeoutMs = (int)TimeUnit.SECONDS.toMillis(config.getRemoteTimelineClientTimeoutSecs().intValue());
    }

    @Override
    protected TimelineServiceClientBase.Response executeRequest(TimelineServiceClientBase.Request request) throws IOException {
        URIBuilder builder = new URIBuilder().setHost(this.timelineServerHost).setPort(this.timelineServerPort).setPath(request.getPath()).setScheme(DEFAULT_SCHEME);
        if (request.getQueryParameters().isPresent()) {
            ((Map)request.getQueryParameters().get()).forEach((arg_0, arg_1) -> ((URIBuilder)builder).addParameter(arg_0, arg_1));
        }
        String url = builder.toString();
        LOG.debug("Sending request : ({})", (Object)url);
        Response response = this.get(request.getMethod(), url, this.timeoutMs);
        return new TimelineServiceClientBase.Response(response.returnContent().asStream());
    }

    private Response get(TimelineServiceClientBase.RequestMethod method, String url, int timeoutMs) throws IOException {
        switch (method) {
            case GET: {
                return Request.Get((String)url).connectTimeout(timeoutMs).socketTimeout(timeoutMs).execute();
            }
        }
        return Request.Post((String)url).connectTimeout(timeoutMs).socketTimeout(timeoutMs).execute();
    }
}

