/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.RetryHelper;

public abstract class TimelineServiceClientBase
implements Serializable {
    private RetryHelper<Response, IOException> retryHelper;

    protected TimelineServiceClientBase(FileSystemViewStorageConfig config) {
        if (config.getBooleanOrDefault(FileSystemViewStorageConfig.REMOTE_RETRY_ENABLE)) {
            this.retryHelper = new RetryHelper(config.getRemoteTimelineClientMaxRetryIntervalMs().longValue(), config.getRemoteTimelineClientMaxRetryNumbers().intValue(), config.getRemoteTimelineInitialRetryIntervalMs().longValue(), config.getRemoteTimelineClientRetryExceptions(), "Sending request to timeline server");
        }
    }

    protected abstract Response executeRequest(Request var1) throws IOException;

    public Response makeRequest(Request request) throws IOException {
        return this.retryHelper != null ? (Response)this.retryHelper.start((RetryHelper.CheckedFunction & Serializable)() -> this.executeRequest(request)) : this.executeRequest(request);
    }

    public static enum RequestMethod {
        GET,
        POST;

    }

    public static class Response {
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new AfterburnerModule());
        private final InputStream content;

        public Response(InputStream content) {
            this.content = content;
        }

        public <T> T getDecodedContent(TypeReference reference) throws IOException {
            try {
                Object object = OBJECT_MAPPER.readValue(this.content, reference);
                return (T)object;
            }
            finally {
                this.content.close();
            }
        }
    }

    public static class Request {
        private final RequestMethod method;
        private final String path;
        private final Option<Map<String, String>> queryParameters;

        private Request(RequestMethod method, String path, Option<Map<String, String>> queryParameters) {
            this.method = method;
            this.path = path;
            this.queryParameters = queryParameters;
        }

        public RequestMethod getMethod() {
            return this.method;
        }

        public String getPath() {
            return this.path;
        }

        public Option<Map<String, String>> getQueryParameters() {
            return this.queryParameters;
        }

        public static Builder newBuilder(RequestMethod method, String path) {
            return new Builder(method, path);
        }

        public static class Builder {
            private final RequestMethod method;
            private final String path;
            private Option<Map<String, String>> queryParameters;

            public Builder(RequestMethod method, String path) {
                this.method = method;
                this.path = path;
                this.queryParameters = Option.empty();
            }

            public Builder addQueryParam(String key, String value) {
                this.queryParameters = this.queryParameters.isPresent() ? this.queryParameters : Option.of(new HashMap());
                ((Map)this.queryParameters.get()).put(key, value);
                return this;
            }

            public Builder addQueryParams(Map<String, String> parameters) {
                this.queryParameters = this.queryParameters.isPresent() ? this.queryParameters : Option.of(new HashMap());
                ((Map)this.queryParameters.get()).putAll(parameters);
                return this;
            }

            public Request build() {
                return new Request(this.method, this.path, this.queryParameters);
            }
        }
    }
}

