/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.util.StringUtils;

public class HoodieFileMetadataMerger {
    private final HashMap<String, String> mergedMetadata = new HashMap();
    private BloomFilter bloomFilter;
    private String minRecordKey;
    private String maxRecordKey;

    public Map<String, String> mergeMetaData(Map<String, String> metaMap) {
        this.mergedMetadata.putAll(metaMap);
        String minRecordKey = metaMap.get("hoodie_min_record_key");
        String maxRecordKey = metaMap.get("hoodie_max_record_key");
        if (this.minRecordKey == null || minRecordKey != null && this.minRecordKey.compareTo(minRecordKey) > 0) {
            this.minRecordKey = minRecordKey;
        }
        if (this.maxRecordKey == null || maxRecordKey != null && this.maxRecordKey.compareTo(maxRecordKey) < 0) {
            this.maxRecordKey = maxRecordKey;
        }
        String bloomFilterType = metaMap.get("hoodie_bloom_filter_type_code");
        String avroBloom = metaMap.get("org.apache.hudi.bloomfilter");
        if (!StringUtils.isNullOrEmpty((String)avroBloom)) {
            BloomFilter targetBloomFilter = BloomFilterFactory.fromString(avroBloom, bloomFilterType);
            if (this.bloomFilter == null) {
                this.bloomFilter = targetBloomFilter;
            } else {
                this.bloomFilter.or(targetBloomFilter);
            }
        }
        if (this.minRecordKey != null) {
            this.mergedMetadata.put("hoodie_min_record_key", this.minRecordKey);
        }
        if (this.maxRecordKey != null) {
            this.mergedMetadata.put("hoodie_max_record_key", this.maxRecordKey);
        }
        if (this.bloomFilter != null) {
            this.mergedMetadata.put("org.apache.hudi.bloomfilter", this.bloomFilter.serializeToString());
        }
        return this.mergedMetadata;
    }

    public Map<String, String> getMergedMetaData() {
        return this.mergedMetadata;
    }
}

