/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaCache;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;

public class AvroSchemaRepair {
    public static Schema repairLogicalTypes(Schema fileSchema, Schema tableSchema) {
        Schema repairedSchema = AvroSchemaRepair.repairAvroSchema(fileSchema, tableSchema);
        if (repairedSchema != fileSchema) {
            return AvroSchemaCache.intern(repairedSchema);
        }
        return fileSchema;
    }

    private static Schema repairAvroSchema(Schema fileSchema, Schema tableSchema) {
        Schema nonNullTableSchema;
        Schema nonNullFileSchema = AvroSchemaUtils.getNonNullTypeFromUnion(fileSchema);
        Schema nonNullRepairedSchema = AvroSchemaRepair.repairAvroSchemaNonNull(nonNullFileSchema, nonNullTableSchema = AvroSchemaUtils.getNonNullTypeFromUnion(tableSchema));
        if (nonNullRepairedSchema == nonNullFileSchema) {
            return fileSchema;
        }
        if (fileSchema.getType() == Schema.Type.UNION) {
            return AvroSchemaUtils.createNullableSchema(nonNullRepairedSchema);
        }
        return nonNullRepairedSchema;
    }

    private static Schema repairAvroSchemaNonNull(Schema fileSchema, Schema tableSchema) {
        if (fileSchema.equals((Object)tableSchema)) {
            return fileSchema;
        }
        if (fileSchema.getType() != tableSchema.getType()) {
            return fileSchema;
        }
        if (fileSchema.getType() == Schema.Type.RECORD) {
            return AvroSchemaRepair.repairRecord(fileSchema, tableSchema);
        }
        if (fileSchema.getType() == Schema.Type.ARRAY) {
            Schema repairedElementSchema = AvroSchemaRepair.repairAvroSchema(fileSchema.getElementType(), tableSchema.getElementType());
            if (repairedElementSchema == fileSchema.getElementType()) {
                return fileSchema;
            }
            return Schema.createArray((Schema)repairedElementSchema);
        }
        if (fileSchema.getType() == Schema.Type.MAP) {
            Schema repairedValueSchema = AvroSchemaRepair.repairAvroSchema(fileSchema.getValueType(), tableSchema.getValueType());
            if (repairedValueSchema == fileSchema.getValueType()) {
                return fileSchema;
            }
            return Schema.createMap((Schema)repairedValueSchema);
        }
        if (AvroSchemaRepair.needsLogicalTypeRepair(fileSchema, tableSchema)) {
            return tableSchema;
        }
        return fileSchema;
    }

    private static boolean needsLogicalTypeRepair(Schema fileSchema, Schema tableSchema) {
        if (fileSchema.getType() != Schema.Type.LONG || tableSchema.getType() != Schema.Type.LONG) {
            return false;
        }
        LogicalType fileSchemaLogicalType = fileSchema.getLogicalType();
        LogicalType tableSchemaLogicalType = tableSchema.getLogicalType();
        if (fileSchemaLogicalType == null) {
            return tableSchemaLogicalType instanceof LogicalTypes.LocalTimestampMillis || tableSchemaLogicalType instanceof LogicalTypes.LocalTimestampMicros;
        }
        return fileSchemaLogicalType instanceof LogicalTypes.TimestampMicros && tableSchemaLogicalType instanceof LogicalTypes.TimestampMillis;
    }

    private static Schema repairRecord(Schema fileSchema, Schema tableSchema) {
        List fields = fileSchema.getFields();
        int firstChangedIndex = -1;
        Schema firstRepairedSchema = null;
        for (int i = 0; i < fields.size(); ++i) {
            Schema repairedSchema;
            Schema.Field requestedField = (Schema.Field)fields.get(i);
            Schema.Field tableField = tableSchema.getField(requestedField.name());
            if (tableField == null || (repairedSchema = AvroSchemaRepair.repairAvroSchema(requestedField.schema(), tableField.schema())) == requestedField.schema()) continue;
            firstChangedIndex = i;
            firstRepairedSchema = repairedSchema;
            break;
        }
        if (firstChangedIndex == -1) {
            return fileSchema;
        }
        ArrayList<Schema.Field> repairedFields = new ArrayList<Schema.Field>(fields.size());
        for (int i = 0; i < firstChangedIndex; ++i) {
            Schema.Field field = (Schema.Field)fields.get(i);
            repairedFields.add(HoodieAvroUtils.createNewSchemaField(field));
        }
        Schema.Field firstChangedField = (Schema.Field)fields.get(firstChangedIndex);
        repairedFields.add(HoodieAvroUtils.createNewSchemaField(firstChangedField.name(), firstRepairedSchema, firstChangedField.doc(), firstChangedField.defaultVal()));
        for (int i = firstChangedIndex + 1; i < fields.size(); ++i) {
            Schema.Field requestedField = (Schema.Field)fields.get(i);
            Schema.Field tableField = tableSchema.getField(requestedField.name());
            Schema repairedSchema = tableField != null ? AvroSchemaRepair.repairAvroSchema(requestedField.schema(), tableField.schema()) : requestedField.schema();
            repairedFields.add(HoodieAvroUtils.createNewSchemaField(requestedField.name(), repairedSchema, requestedField.doc(), requestedField.defaultVal()));
        }
        return Schema.createRecord((String)fileSchema.getName(), (String)fileSchema.getDoc(), (String)fileSchema.getNamespace(), (boolean)fileSchema.isError(), repairedFields);
    }

    public static boolean hasTimestampMillisField(Schema tableSchema) {
        switch (tableSchema.getType()) {
            case RECORD: {
                for (Schema.Field field : tableSchema.getFields()) {
                    if (!AvroSchemaRepair.hasTimestampMillisField(field.schema())) continue;
                    return true;
                }
                return false;
            }
            case ARRAY: {
                return AvroSchemaRepair.hasTimestampMillisField(tableSchema.getElementType());
            }
            case MAP: {
                return AvroSchemaRepair.hasTimestampMillisField(tableSchema.getValueType());
            }
            case UNION: {
                return AvroSchemaRepair.hasTimestampMillisField(AvroSchemaUtils.getNonNullTypeFromUnion(tableSchema));
            }
        }
        return tableSchema.getType() == Schema.Type.LONG && (tableSchema.getLogicalType() instanceof LogicalTypes.TimestampMillis || tableSchema.getLogicalType() instanceof LogicalTypes.LocalTimestampMillis);
    }
}

