/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import org.apache.hudi.ParquetAdapter;
import org.apache.hudi.stats.ValueType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;

public class LogicalTypeParquetAdapter
implements ParquetAdapter {
    @Override
    public boolean hasAnnotation(PrimitiveType primitiveType) {
        return primitiveType.getLogicalTypeAnnotation() != null;
    }

    @Override
    public ValueType getValueTypeFromAnnotation(PrimitiveType primitiveType) {
        LogicalTypeAnnotation annotation = primitiveType.getLogicalTypeAnnotation();
        if (annotation instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation) {
            return ValueType.STRING;
        }
        if (annotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            return ValueType.DECIMAL;
        }
        if (annotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
            return ValueType.DATE;
        }
        if (annotation instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
            LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeAnnotation = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)annotation;
            if (timeAnnotation.getUnit() == LogicalTypeAnnotation.TimeUnit.MILLIS) {
                return ValueType.TIME_MILLIS;
            }
            if (timeAnnotation.getUnit() == LogicalTypeAnnotation.TimeUnit.MICROS) {
                return ValueType.TIME_MICROS;
            }
            throw new IllegalArgumentException("Unsupported time unit: " + timeAnnotation.getUnit());
        }
        if (annotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
            LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)annotation;
            if (timestampAnnotation.getUnit() == LogicalTypeAnnotation.TimeUnit.MILLIS) {
                return timestampAnnotation.isAdjustedToUTC() ? ValueType.TIMESTAMP_MILLIS : ValueType.LOCAL_TIMESTAMP_MILLIS;
            }
            if (timestampAnnotation.getUnit() == LogicalTypeAnnotation.TimeUnit.MICROS) {
                return timestampAnnotation.isAdjustedToUTC() ? ValueType.TIMESTAMP_MICROS : ValueType.LOCAL_TIMESTAMP_MICROS;
            }
            if (timestampAnnotation.getUnit() == LogicalTypeAnnotation.TimeUnit.NANOS) {
                return timestampAnnotation.isAdjustedToUTC() ? ValueType.TIMESTAMP_NANOS : ValueType.LOCAL_TIMESTAMP_NANOS;
            }
            throw new IllegalArgumentException("Unsupported timestamp unit: " + timestampAnnotation.getUnit());
        }
        if (annotation instanceof LogicalTypeAnnotation.UUIDLogicalTypeAnnotation) {
            return ValueType.UUID;
        }
        throw new IllegalArgumentException("Unsupported logical type annotation: " + annotation);
    }

    private static void validatePrimitiveType(PrimitiveType primitiveType) {
        if (primitiveType.getLogicalTypeAnnotation() == null) {
            throw new IllegalArgumentException("Unsupported primitive type: " + primitiveType.getPrimitiveTypeName());
        }
        if (!(primitiveType.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)) {
            throw new IllegalArgumentException("Unsupported logical type annotation: " + primitiveType.getLogicalTypeAnnotation());
        }
    }

    @Override
    public int getPrecision(PrimitiveType primitiveType) {
        LogicalTypeParquetAdapter.validatePrimitiveType(primitiveType);
        return ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)primitiveType.getLogicalTypeAnnotation()).getPrecision();
    }

    @Override
    public int getScale(PrimitiveType primitiveType) {
        LogicalTypeParquetAdapter.validatePrimitiveType(primitiveType);
        return ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)primitiveType.getLogicalTypeAnnotation()).getScale();
    }
}

