/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import org.apache.hudi.ParquetAdapter;
import org.apache.hudi.stats.ValueType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;

public class OriginalTypeParquetAdapter
implements ParquetAdapter {
    @Override
    public boolean hasAnnotation(PrimitiveType primitiveType) {
        return primitiveType.getOriginalType() != null;
    }

    @Override
    public ValueType getValueTypeFromAnnotation(PrimitiveType primitiveType) {
        switch (primitiveType.getOriginalType()) {
            case UTF8: {
                return ValueType.STRING;
            }
            case DECIMAL: {
                return ValueType.DECIMAL;
            }
            case DATE: {
                return ValueType.DATE;
            }
            case TIME_MILLIS: {
                return ValueType.TIME_MILLIS;
            }
            case TIME_MICROS: {
                return ValueType.TIME_MICROS;
            }
            case TIMESTAMP_MILLIS: {
                if (primitiveType.toString().contains("(TIMESTAMP(MILLIS,false))")) {
                    return ValueType.LOCAL_TIMESTAMP_MILLIS;
                }
                return ValueType.TIMESTAMP_MILLIS;
            }
            case TIMESTAMP_MICROS: {
                if (primitiveType.toString().contains("(TIMESTAMP(MICROS,false))")) {
                    return ValueType.LOCAL_TIMESTAMP_MICROS;
                }
                return ValueType.TIMESTAMP_MICROS;
            }
        }
        throw new IllegalArgumentException("Unsupported original type: " + primitiveType.getOriginalType());
    }

    private static void validatePrimitiveType(PrimitiveType primitiveType) {
        if (primitiveType.getOriginalType() == null) {
            throw new IllegalArgumentException("Unsupported primitive type: " + primitiveType.getPrimitiveTypeName());
        }
        if (primitiveType.getOriginalType() != OriginalType.DECIMAL) {
            throw new IllegalArgumentException("Unsupported original type: " + primitiveType.getOriginalType());
        }
    }

    @Override
    public int getPrecision(PrimitiveType primitiveType) {
        OriginalTypeParquetAdapter.validatePrimitiveType(primitiveType);
        return primitiveType.getDecimalMetadata().getPrecision();
    }

    @Override
    public int getScale(PrimitiveType primitiveType) {
        OriginalTypeParquetAdapter.validatePrimitiveType(primitiveType);
        return primitiveType.getDecimalMetadata().getScale();
    }
}

