/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub.config;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import datahub.client.rest.RestEmitter;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.datahub.config.DataHubEmitterSupplier;
import org.apache.hudi.sync.datahub.config.HoodieDataHubDatasetIdentifier;

public class DataHubSyncConfig
extends HoodieSyncConfig {
    public static final ConfigProperty<String> META_SYNC_DATAHUB_DATASET_IDENTIFIER_CLASS = ConfigProperty.key((String)"hoodie.meta.sync.datahub.dataset.identifier.class").defaultValue((Object)HoodieDataHubDatasetIdentifier.class.getName()).withDocumentation("Pluggable class to help provide info to identify a DataHub Dataset.");
    public static final ConfigProperty<String> META_SYNC_DATAHUB_EMITTER_SERVER = ConfigProperty.key((String)"hoodie.meta.sync.datahub.emitter.server").noDefaultValue().withDocumentation("Server URL of the DataHub instance.");
    public static final ConfigProperty<String> META_SYNC_DATAHUB_EMITTER_TOKEN = ConfigProperty.key((String)"hoodie.meta.sync.datahub.emitter.token").noDefaultValue().withDocumentation("Auth token to connect to the DataHub instance.");
    public static final ConfigProperty<String> META_SYNC_DATAHUB_EMITTER_SUPPLIER_CLASS = ConfigProperty.key((String)"hoodie.meta.sync.datahub.emitter.supplier.class").noDefaultValue().withDocumentation("Pluggable class to supply a DataHub REST emitter to connect to the DataHub instance. This overwrites other emitter configs.");
    public final HoodieDataHubDatasetIdentifier datasetIdentifier;

    public DataHubSyncConfig(Properties props) {
        super(props);
        String identifierClass = this.getStringOrDefault(META_SYNC_DATAHUB_DATASET_IDENTIFIER_CLASS);
        this.datasetIdentifier = (HoodieDataHubDatasetIdentifier)ReflectionUtils.loadClass((String)identifierClass, (Class[])new Class[]{Properties.class}, (Object[])new Object[]{props});
    }

    public RestEmitter getRestEmitter() {
        if (this.contains(META_SYNC_DATAHUB_EMITTER_SUPPLIER_CLASS)) {
            return (RestEmitter)((DataHubEmitterSupplier)ReflectionUtils.loadClass((String)this.getString(META_SYNC_DATAHUB_EMITTER_SUPPLIER_CLASS))).get();
        }
        if (this.contains(META_SYNC_DATAHUB_EMITTER_SERVER)) {
            return RestEmitter.create(b -> b.server(this.getString(META_SYNC_DATAHUB_EMITTER_SERVER)).token(this.getStringOrDefault(META_SYNC_DATAHUB_EMITTER_TOKEN, null)));
        }
        return RestEmitter.createWithDefaults();
    }

    public static class DataHubSyncConfigParams {
        @ParametersDelegate
        public final HoodieSyncConfig.HoodieSyncConfigParams hoodieSyncConfigParams = new HoodieSyncConfig.HoodieSyncConfigParams();
        @Parameter(names={"--identifier-class"}, description="Pluggable class to help provide info to identify a DataHub Dataset.")
        public String identifierClass;
        @Parameter(names={"--emitter-server"}, description="Server URL of the DataHub instance.")
        public String emitterServer;
        @Parameter(names={"--emitter-token"}, description="Auth token to connect to the DataHub instance.")
        public String emitterToken;
        @Parameter(names={"--emitter-supplier-class"}, description="Pluggable class to supply a DataHub REST emitter to connect to the DataHub instance. This overwrites other emitter configs.")
        public String emitterSupplierClass;

        public boolean isHelp() {
            return this.hoodieSyncConfigParams.isHelp();
        }

        public Properties toProps() {
            TypedProperties props = this.hoodieSyncConfigParams.toProps();
            props.setPropertyIfNonNull(META_SYNC_DATAHUB_DATASET_IDENTIFIER_CLASS.key(), (Object)this.identifierClass);
            props.setPropertyIfNonNull(META_SYNC_DATAHUB_EMITTER_SERVER.key(), (Object)this.emitterServer);
            props.setPropertyIfNonNull(META_SYNC_DATAHUB_EMITTER_TOKEN.key(), (Object)this.emitterToken);
            props.setPropertyIfNonNull(META_SYNC_DATAHUB_EMITTER_SUPPLIER_CLASS.key(), (Object)this.emitterSupplierClass);
            return props;
        }
    }
}

