/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub.config;

import com.linkedin.common.FabricType;
import com.linkedin.common.urn.DataPlatformUrn;
import com.linkedin.common.urn.DatasetUrn;
import java.util.Properties;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.datahub.config.DataHubSyncConfig;

public class HoodieDataHubDatasetIdentifier {
    public static final String DEFAULT_HOODIE_DATAHUB_PLATFORM_NAME = "hudi";
    public static final FabricType DEFAULT_DATAHUB_ENV = FabricType.DEV;
    protected final Properties props;

    public HoodieDataHubDatasetIdentifier(Properties props) {
        this.props = props;
    }

    public DatasetUrn getDatasetUrn() {
        DataHubSyncConfig config = new DataHubSyncConfig(this.props);
        return new DatasetUrn(HoodieDataHubDatasetIdentifier.createDataPlatformUrn(config.getStringOrDefault(DataHubSyncConfig.META_SYNC_DATAHUB_DATAPLATFORM_NAME)), HoodieDataHubDatasetIdentifier.createDatasetName(config.getString(HoodieSyncConfig.META_SYNC_DATABASE_NAME), config.getString(HoodieSyncConfig.META_SYNC_TABLE_NAME)), FabricType.valueOf((String)config.getStringOrDefault(DataHubSyncConfig.META_SYNC_DATAHUB_DATASET_ENV)));
    }

    private static DataPlatformUrn createDataPlatformUrn(String platformUrn) {
        return new DataPlatformUrn(platformUrn);
    }

    private static String createDatasetName(String databaseName, String tableName) {
        return String.format("%s.%s", databaseName, tableName);
    }
}

