/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub;

import datahub.client.Callback;
import datahub.client.MetadataWriteResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataHubResponseLogger
implements Callback {
    private static final Logger LOG = LoggerFactory.getLogger(DataHubResponseLogger.class);

    public void onCompletion(MetadataWriteResponse response) {
        LOG.info("Completed DataHub RestEmitter request. Status: " + (response.isSuccess() ? " succeeded" : " failed"));
        if (!response.isSuccess()) {
            LOG.error("Request failed. " + response);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response details: " + response);
        }
    }

    public void onFailure(Throwable e) {
        LOG.error("Error during Datahub RestEmitter request", e);
    }
}

