/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub;

import com.linkedin.common.BrowsePathEntry;
import com.linkedin.common.BrowsePathEntryArray;
import com.linkedin.common.BrowsePathsV2;
import com.linkedin.common.Status;
import com.linkedin.common.SubTypes;
import com.linkedin.common.UrnArray;
import com.linkedin.common.urn.DatasetUrn;
import com.linkedin.common.urn.Urn;
import com.linkedin.container.Container;
import com.linkedin.container.ContainerProperties;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.StringArray;
import com.linkedin.domain.Domains;
import com.linkedin.metadata.aspect.patch.builder.DatasetPropertiesPatchBuilder;
import com.linkedin.mxe.MetadataChangeProposal;
import com.linkedin.schema.SchemaMetadata;
import datahub.client.Callback;
import datahub.client.rest.RestEmitter;
import datahub.event.MetadataChangeProposalWrapper;
import io.datahubproject.schematron.converters.avro.AvroSchemaConverter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hive.SchemaDifference;
import org.apache.hudi.sync.common.HoodieSyncClient;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.HoodieSyncException;
import org.apache.hudi.sync.datahub.DataHubResponseLogger;
import org.apache.hudi.sync.datahub.HoodieDataHubSyncException;
import org.apache.hudi.sync.datahub.config.DataHubSyncConfig;
import org.apache.hudi.sync.datahub.config.HoodieDataHubDatasetIdentifier;
import org.apache.hudi.sync.datahub.util.SchemaFieldsUtil;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataHubSyncClient
extends HoodieSyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(DataHubSyncClient.class);
    protected final DataHubSyncConfig config;
    private final DatasetUrn datasetUrn;
    private final Urn databaseUrn;
    private final String tableName;
    private final String databaseName;
    private static final Status SOFT_DELETE_FALSE = new Status().setRemoved(false);

    public DataHubSyncClient(DataHubSyncConfig config, HoodieTableMetaClient metaClient) {
        super((HoodieSyncConfig)config, metaClient);
        this.config = config;
        HoodieDataHubDatasetIdentifier datasetIdentifier = config.getDatasetIdentifier();
        this.datasetUrn = datasetIdentifier.getDatasetUrn();
        this.databaseUrn = datasetIdentifier.getDatabaseUrn();
        this.tableName = datasetIdentifier.getTableName();
        this.databaseName = datasetIdentifier.getDatabaseName();
    }

    public Option<String> getLastCommitTimeSynced(String tableName) {
        throw new UnsupportedOperationException("Not supported: `getLastCommitTimeSynced`");
    }

    protected Option<String> getLastCommitTime() {
        return this.getActiveTimeline().lastInstant().map(HoodieInstant::requestedTime);
    }

    protected Option<String> getLastCommitCompletionTime() {
        return this.getActiveTimeline().getLatestCompletionTime();
    }

    public void updateLastCommitTimeSynced(String tableName) {
        Option<String> lastCommitTime = this.getLastCommitTime();
        if (lastCommitTime.isPresent()) {
            this.updateTableProperties(tableName, Collections.singletonMap("last_commit_time_sync", lastCommitTime.get()));
        } else {
            LOG.error("Failed to get last commit time");
        }
        Option<String> lastCommitCompletionTime = this.getLastCommitCompletionTime();
        if (lastCommitCompletionTime.isPresent()) {
            this.updateTableProperties(tableName, Collections.singletonMap("last_commit_completion_time_sync", lastCommitCompletionTime.get()));
        } else {
            LOG.error("Failed to get last commit completion time");
        }
    }

    private MetadataChangeProposal createDatasetPropertiesAspect(String tableName, Map<String, String> tableProperties) {
        DatasetPropertiesPatchBuilder datasetPropertiesPatchBuilder = (DatasetPropertiesPatchBuilder)new DatasetPropertiesPatchBuilder().urn((Urn)this.datasetUrn);
        if (tableProperties != null) {
            tableProperties.forEach((arg_0, arg_1) -> ((DatasetPropertiesPatchBuilder)datasetPropertiesPatchBuilder).addCustomProperty(arg_0, arg_1));
        }
        if (tableName != null) {
            datasetPropertiesPatchBuilder.setName(tableName);
        }
        return datasetPropertiesPatchBuilder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateTableProperties(String tableName, Map<String, String> tableProperties) {
        MetadataChangeProposal proposal = this.createDatasetPropertiesAspect(tableName, tableProperties);
        DataHubResponseLogger responseLogger = new DataHubResponseLogger();
        try (RestEmitter emitter = this.config.getRestEmitter();){
            Future future = emitter.emit(proposal, (Callback)responseLogger);
            future.get();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (!this.config.suppressExceptions().booleanValue()) {
                throw new HoodieDataHubSyncException("Failed to sync properties for Dataset " + this.datasetUrn + ": " + tableProperties, e);
            }
            LOG.error("Failed to sync properties for Dataset {}: {}", new Object[]{this.datasetUrn, tableProperties, e});
            return false;
        }
    }

    public void updateTableSchema(String tableName, MessageType schema, SchemaDifference schemaDifference) {
        try (RestEmitter emitter = this.config.getRestEmitter();){
            DataHubResponseLogger responseLogger = new DataHubResponseLogger();
            Stream<Future> proposals = Stream.of(this.createContainerEntity(), this.createDatasetEntity()).flatMap(stream -> stream);
            List futures = proposals.map(p -> {
                try {
                    return emitter.emit(p, (Callback)responseLogger);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            ArrayList successfulResults = new ArrayList();
            ArrayList<Object> failures = new ArrayList<Object>();
            for (Future future : futures) {
                try {
                    successfulResults.add(future.get(30L, TimeUnit.SECONDS));
                }
                catch (TimeoutException e) {
                    failures.add((Object)new HoodieDataHubSyncException("Operation timed out", e));
                }
                catch (InterruptedException | ExecutionException e) {
                    failures.add(e);
                }
            }
            if (!failures.isEmpty()) {
                if (!this.config.suppressExceptions().booleanValue()) {
                    throw new HoodieDataHubSyncException("Failed to sync " + failures.size() + " operations", (Throwable)failures.get(0));
                }
                for (Throwable throwable : failures) {
                    LOG.error("Failed to sync operation", throwable);
                }
            }
        }
        catch (Exception e) {
            if (!this.config.suppressExceptions().booleanValue()) {
                throw new HoodieDataHubSyncException(String.format("Failed to sync metadata for dataset %s", tableName), e);
            }
            LOG.error("Failed to sync metadata for dataset {}", (Object)tableName, (Object)e);
        }
    }

    private MetadataChangeProposalWrapper createContainerAspect(Urn entityUrn, Urn containerUrn) {
        MetadataChangeProposalWrapper containerProposal = MetadataChangeProposalWrapper.builder().entityType(entityUrn.getEntityType()).entityUrn(entityUrn).upsert().aspect((DataTemplate)new Container().setContainer(containerUrn)).build();
        return containerProposal;
    }

    private MetadataChangeProposalWrapper createBrowsePathsAspect(Urn entityUrn, List<BrowsePathEntry> path) {
        BrowsePathEntryArray browsePathEntryArray = new BrowsePathEntryArray(path);
        MetadataChangeProposalWrapper browsePathsProposal = MetadataChangeProposalWrapper.builder().entityType(entityUrn.getEntityType()).entityUrn(entityUrn).upsert().aspect((DataTemplate)new BrowsePathsV2().setPath(browsePathEntryArray)).build();
        return browsePathsProposal;
    }

    private MetadataChangeProposalWrapper createDomainAspect(Urn entityUrn) {
        try {
            Urn domainUrn = Urn.createFromString((String)this.config.getDomainIdentifier());
            MetadataChangeProposalWrapper attachDomainProposal = MetadataChangeProposalWrapper.builder().entityType(entityUrn.getEntityType()).entityUrn(entityUrn).upsert().aspect((DataTemplate)new Domains().setDomains(new UrnArray(domainUrn, new Urn[0]))).build();
            return attachDomainProposal;
        }
        catch (URISyntaxException e) {
            LOG.warn("Failed to create domain URN from string: {}", (Object)this.config.getDomainIdentifier());
            return null;
        }
    }

    private Stream<MetadataChangeProposalWrapper> createContainerEntity() {
        MetadataChangeProposalWrapper containerEntityProposal = MetadataChangeProposalWrapper.builder().entityType("container").entityUrn(this.databaseUrn).upsert().aspect((DataTemplate)new ContainerProperties().setName(this.databaseName)).build();
        Stream<MetadataChangeProposalWrapper> resultStream = Stream.of(containerEntityProposal, this.createSubTypeAspect(this.databaseUrn, "Database"), this.createBrowsePathsAspect(this.databaseUrn, Collections.emptyList()), this.createStatusAspect(this.databaseUrn), this.config.attachDomain() ? this.createDomainAspect(this.databaseUrn) : null).filter(Objects::nonNull);
        return resultStream;
    }

    public Map<String, String> getMetastoreSchema(String tableName) {
        throw new UnsupportedOperationException("Not supported: `getMetastoreSchema`");
    }

    public void close() {
    }

    private MetadataChangeProposalWrapper<Status> createStatusAspect(Urn urn) {
        MetadataChangeProposalWrapper softDeleteUndoProposal = MetadataChangeProposalWrapper.builder().entityType(urn.getEntityType()).entityUrn(urn).upsert().aspect((DataTemplate)SOFT_DELETE_FALSE).build();
        return softDeleteUndoProposal;
    }

    private MetadataChangeProposalWrapper<SubTypes> createSubTypeAspect(Urn urn, String subType) {
        MetadataChangeProposalWrapper subTypeProposal = MetadataChangeProposalWrapper.builder().entityType(urn.getEntityType()).entityUrn(urn).upsert().aspect((DataTemplate)new SubTypes().setTypeNames(new StringArray(subType, new String[0]))).build();
        return subTypeProposal;
    }

    private MetadataChangeProposalWrapper createSchemaMetadataAspect(String tableName) {
        Schema avroSchema = this.getAvroSchemaWithoutMetadataFields(this.metaClient);
        AvroSchemaConverter avroSchemaConverter = AvroSchemaConverter.builder().build();
        SchemaMetadata schemaMetadata = avroSchemaConverter.toDataHubSchema(avroSchema, false, false, this.datasetUrn.getPlatformEntity(), null);
        schemaMetadata.setFields(SchemaFieldsUtil.reorderPrefixedFields(schemaMetadata.getFields(), "_hoodie_"));
        return MetadataChangeProposalWrapper.builder().entityType("dataset").entityUrn((Urn)this.datasetUrn).upsert().aspect((DataTemplate)schemaMetadata).build();
    }

    private Stream<MetadataChangeProposalWrapper> createDatasetEntity() {
        Stream<MetadataChangeProposalWrapper> result = Stream.of(this.createStatusAspect((Urn)this.datasetUrn), this.createSubTypeAspect((Urn)this.datasetUrn, "Table"), this.createBrowsePathsAspect((Urn)this.datasetUrn, Collections.singletonList(new BrowsePathEntry().setUrn(this.databaseUrn).setId(this.databaseName))), this.createContainerAspect((Urn)this.datasetUrn, this.databaseUrn), this.createSchemaMetadataAspect(this.tableName), this.config.attachDomain() ? this.createDomainAspect((Urn)this.datasetUrn) : null).filter(Objects::nonNull);
        return result;
    }

    Schema getAvroSchemaWithoutMetadataFields(HoodieTableMetaClient metaClient) {
        try {
            return new TableSchemaResolver(metaClient).getTableAvroSchema(true);
        }
        catch (Exception e) {
            throw new HoodieSyncException("Failed to read avro schema", (Throwable)e);
        }
    }
}

