/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub;

import com.beust.jcommander.JCommander;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.HadoopConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.HoodieSyncTool;
import org.apache.hudi.sync.datahub.DataHubSyncClient;
import org.apache.hudi.sync.datahub.DataHubTableProperties;
import org.apache.hudi.sync.datahub.config.DataHubSyncConfig;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataHubSyncTool
extends HoodieSyncTool {
    private static final Logger LOG = LoggerFactory.getLogger(DataHubSyncTool.class);
    protected final DataHubSyncConfig config;
    protected final HoodieTableMetaClient metaClient;
    protected DataHubSyncClient syncClient;
    private final String tableName;

    public DataHubSyncTool(Properties props) {
        this(props, HadoopConfigUtils.createHadoopConf((Properties)props), (Option<HoodieTableMetaClient>)Option.empty());
    }

    public DataHubSyncTool(Properties props, Configuration hadoopConf, Option<HoodieTableMetaClient> metaClientOption) {
        super(props, hadoopConf);
        this.config = new DataHubSyncConfig(props);
        this.tableName = this.config.getString(HoodieSyncConfig.META_SYNC_TABLE_NAME);
        this.metaClient = (HoodieTableMetaClient)metaClientOption.orElseGet(() -> DataHubSyncTool.buildMetaClient((HoodieSyncConfig)this.config));
        this.syncClient = new DataHubSyncClient(this.config, this.metaClient);
    }

    public void syncHoodieTable() {
        try {
            LOG.info("Syncing target Hoodie table with DataHub dataset({}). DataHub URL: {}, basePath: {}", new Object[]{this.tableName, this.config.getDataHubServerEndpoint(), this.config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH)});
            this.syncSchema();
            this.syncTableProperties();
            this.updateLastCommitTimeIfNeeded();
            LOG.info("Sync completed for table {}", (Object)this.tableName);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to sync table " + this.tableName + " to DataHub", e);
        }
        finally {
            this.close();
        }
    }

    private void syncSchema() throws Exception {
        this.syncClient.updateTableSchema(this.tableName, null, null);
        LOG.info("Schema synced for table {}", (Object)this.tableName);
    }

    private void syncTableProperties() throws Exception {
        MessageType storageSchema = this.syncClient.getStorageSchema();
        DataHubTableProperties.HoodieTableMetadata tableMetadata = new DataHubTableProperties.HoodieTableMetadata(this.metaClient, storageSchema);
        Map<String, String> tableProperties = DataHubTableProperties.getTableProperties(this.config, tableMetadata);
        this.syncClient.updateTableProperties(this.tableName, tableProperties);
        LOG.info("Properties synced for table {}", (Object)this.tableName);
    }

    private void updateLastCommitTimeIfNeeded() throws Exception {
        boolean shouldUpdateLastCommitTime;
        boolean bl = shouldUpdateLastCommitTime = this.config.getBoolean(HoodieSyncConfig.META_SYNC_CONDITIONAL_SYNC) == false;
        if (shouldUpdateLastCommitTime) {
            this.syncClient.updateLastCommitTimeSynced(this.tableName);
            LOG.info("Updated last sync time for table {}", (Object)this.tableName);
        }
    }

    public void close() {
        if (this.syncClient != null) {
            try {
                this.syncClient.close();
                this.syncClient = null;
            }
            catch (Exception e) {
                LOG.error("Error closing DataHub sync client", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        DataHubSyncConfig.DataHubSyncConfigParams params = new DataHubSyncConfig.DataHubSyncConfigParams();
        JCommander cmd = JCommander.newBuilder().addObject((Object)params).build();
        cmd.parse(args);
        if (params.isHelp()) {
            cmd.usage();
            System.exit(0);
        }
        new DataHubSyncTool(params.toProps()).syncHoodieTable();
    }
}

