/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.sync.common.util.SparkDataSourceTableUtils;
import org.apache.hudi.sync.datahub.config.DataHubSyncConfig;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataHubTableProperties {
    private static final Logger LOG = LoggerFactory.getLogger(DataHubTableProperties.class);
    public static final String HOODIE_META_SYNC_DATAHUB_TABLE_PROPERTIES = "hoodie.meta.sync.datahub.table.properties";
    public static final String HUDI_TABLE_TYPE = "hudi.table.type";
    public static final String HUDI_TABLE_VERSION = "hudi.table.version";
    public static final String HUDI_BASE_PATH = "hudi.base.path";
    public static final String HUDI_PARTITION_FIELDS = "hudi.partition.fields";
    public static final ConfigProperty<String> DATAHUB_TABLE_PROPERTIES = ConfigProperty.key((String)"hoodie.meta.sync.datahub.table.properties").defaultValue((Object)"").withDocumentation("Additional properties to be attached to the DataHub dataset, specified as key1=val1,key2=val2");

    public static Map<String, String> getTableProperties(DataHubSyncConfig config, HoodieTableMetadata tableMetadata) {
        HashMap<String, String> properties = new HashMap<String, String>();
        DataHubTableProperties.addBasicHudiTableProperties(properties, config, tableMetadata);
        DataHubTableProperties.addPartitioningInformation(properties, config);
        DataHubTableProperties.addUserDefinedProperties(properties, config);
        DataHubTableProperties.addSparkRelatedProperties(properties, config, tableMetadata);
        return properties;
    }

    private static void addBasicHudiTableProperties(Map<String, String> properties, DataHubSyncConfig config, HoodieTableMetadata tableMetadata) {
        properties.put(HUDI_TABLE_TYPE, tableMetadata.getTableType());
        properties.put(HUDI_TABLE_VERSION, tableMetadata.getTableVersion());
        properties.put(HUDI_BASE_PATH, config.getString(DataHubSyncConfig.META_SYNC_BASE_PATH));
    }

    private static void addPartitioningInformation(Map<String, String> properties, DataHubSyncConfig config) {
        if (!config.getSplitStrings(DataHubSyncConfig.META_SYNC_PARTITION_FIELDS).isEmpty()) {
            properties.put(HUDI_PARTITION_FIELDS, String.join((CharSequence)",", config.getSplitStrings(DataHubSyncConfig.META_SYNC_PARTITION_FIELDS)));
        }
    }

    private static void addUserDefinedProperties(Map<String, String> properties, DataHubSyncConfig config) {
        Map userDefinedProps = ConfigUtils.toMap((String)config.getString(DATAHUB_TABLE_PROPERTIES));
        properties.putAll(userDefinedProps);
    }

    private static void addSparkRelatedProperties(Map<String, String> properties, DataHubSyncConfig config, HoodieTableMetadata tableMetadata) {
        Map sparkProperties = SparkDataSourceTableUtils.getSparkTableProperties((List)config.getSplitStrings(DataHubSyncConfig.META_SYNC_PARTITION_FIELDS), (String)config.getString(DataHubSyncConfig.META_SYNC_SPARK_VERSION), (int)config.getInt(DataHubSyncConfig.HIVE_SYNC_SCHEMA_STRING_LENGTH_THRESHOLD), (MessageType)tableMetadata.getSchema());
        properties.putAll(sparkProperties);
        properties.putAll(DataHubTableProperties.getSerdeProperties(config, false));
    }

    private static Map<String, String> getSerdeProperties(DataHubSyncConfig config, boolean readAsOptimized) {
        HoodieFileFormat baseFileFormat = HoodieFileFormat.valueOf((String)config.getStringOrDefault(DataHubSyncConfig.META_SYNC_BASE_FILE_FORMAT).toUpperCase());
        String inputFormatClassName = HoodieInputFormatUtils.getInputFormatClassName((HoodieFileFormat)baseFileFormat, (boolean)false, (boolean)false);
        String outputFormatClassName = HoodieInputFormatUtils.getOutputFormatClassName((HoodieFileFormat)baseFileFormat);
        String serDeFormatClassName = HoodieInputFormatUtils.getSerDeClassName((HoodieFileFormat)baseFileFormat);
        Map serdeProperties = ConfigUtils.toMap((String)config.getString(DataHubSyncConfig.HIVE_TABLE_SERDE_PROPERTIES));
        serdeProperties.put("inputFormat", inputFormatClassName);
        serdeProperties.put("outputFormat", outputFormatClassName);
        serdeProperties.put("serdeClass", serDeFormatClassName);
        Map sparkSerdeProperties = SparkDataSourceTableUtils.getSparkSerdeProperties((boolean)readAsOptimized, (String)config.getString(DataHubSyncConfig.META_SYNC_BASE_PATH));
        sparkSerdeProperties.forEach((k, v) -> serdeProperties.putIfAbsent(k.startsWith("spark.") ? k : "spark." + k, v));
        LOG.info("Serde Properties : {}", (Object)serdeProperties);
        return serdeProperties;
    }

    public static class HoodieTableMetadata {
        private final HoodieTableMetaClient metaClient;
        private final MessageType schema;

        public HoodieTableMetadata(HoodieTableMetaClient metaClient, MessageType schema) {
            this.metaClient = metaClient;
            this.schema = schema;
        }

        public String getTableType() {
            return this.metaClient.getTableType().name();
        }

        public String getTableVersion() {
            return this.metaClient.getTableConfig().getTableVersion().toString();
        }

        public MessageType getSchema() {
            return this.schema;
        }
    }
}

