/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub.config;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import datahub.client.rest.RestEmitter;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.datahub.config.DataHubEmitterSupplier;
import org.apache.hudi.sync.datahub.config.HoodieDataHubDatasetIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigClassProperty(name="DataHub Sync Configs", groupName=ConfigGroups.Names.META_SYNC, description="Configurations used by the Hudi to sync metadata to DataHub.")
@Immutable
public class DataHubSyncConfig
extends HoodieSyncConfig {
    private static final Logger LOG = LoggerFactory.getLogger(DataHubSyncConfig.class);
    public static final ConfigProperty<String> META_SYNC_DATAHUB_DATASET_IDENTIFIER_CLASS = ConfigProperty.key((String)"hoodie.meta.sync.datahub.dataset.identifier.class").defaultValue((Object)HoodieDataHubDatasetIdentifier.class.getName()).markAdvanced().withDocumentation("Pluggable class to help provide info to identify a DataHub Dataset.");
    public static final ConfigProperty<String> META_SYNC_DATAHUB_EMITTER_SERVER = ConfigProperty.key((String)"hoodie.meta.sync.datahub.emitter.server").noDefaultValue().markAdvanced().withDocumentation("Server URL of the DataHub instance.");
    public static final ConfigProperty<String> META_SYNC_DATAHUB_EMITTER_TOKEN = ConfigProperty.key((String)"hoodie.meta.sync.datahub.emitter.token").noDefaultValue().markAdvanced().withDocumentation("Auth token to connect to the DataHub instance.");
    public static final ConfigProperty<String> META_SYNC_DATAHUB_EMITTER_SUPPLIER_CLASS = ConfigProperty.key((String)"hoodie.meta.sync.datahub.emitter.supplier.class").noDefaultValue().markAdvanced().withDocumentation("Pluggable class to supply a DataHub REST emitter to connect to the DataHub instance. This overwrites other emitter configs.");
    public static final ConfigProperty<String> META_SYNC_DATAHUB_DATAPLATFORM_NAME = ConfigProperty.key((String)"hoodie.meta.sync.datahub.dataplatform.name").defaultValue((Object)"hudi").markAdvanced().withDocumentation("String used to represent Hudi when creating its corresponding DataPlatform entity within Datahub");
    public static final ConfigProperty<String> META_SYNC_DATAHUB_DATASET_ENV = ConfigProperty.key((String)"hoodie.meta.sync.datahub.dataset.env").defaultValue((Object)HoodieDataHubDatasetIdentifier.DEFAULT_DATAHUB_ENV.name()).markAdvanced().withDocumentation("Environment to use when pushing entities to Datahub");
    public static final ConfigProperty<String> META_SYNC_DATAHUB_DOMAIN_IDENTIFIER = ConfigProperty.key((String)"hoodie.meta.sync.datahub.domain.identifier").noDefaultValue().markAdvanced().withDocumentation("Domain identifier for the dataset. When provided all datasets will be attached to the provided domain. Must be in urn form (e.g., urn:li:domain:_domain_id).");
    public static final ConfigProperty<String> HIVE_TABLE_SERDE_PROPERTIES = ConfigProperty.key((String)"hoodie.datasource.hive_sync.serde_properties").noDefaultValue().markAdvanced().withDocumentation("Serde properties to hive table.");
    public static final ConfigProperty<Integer> HIVE_SYNC_SCHEMA_STRING_LENGTH_THRESHOLD = ConfigProperty.key((String)"hoodie.datasource.hive_sync.schema_string_length_thresh").defaultValue((Object)4000).markAdvanced().withDocumentation("");
    public static final ConfigProperty<Boolean> META_SYNC_DATAHUB_SYNC_SUPPRESS_EXCEPTIONS = ConfigProperty.key((String)"hoodie.meta.sync.datahub.sync.suppress.exceptions").defaultValue((Object)true).markAdvanced().withDocumentation("Suppress exceptions during DataHub sync. This is true by default to ensure that when running inline with other jobs, the sync does not fail the job.");

    public DataHubSyncConfig(Properties props) {
        super(props);
        if (this.contains(META_SYNC_DATAHUB_DOMAIN_IDENTIFIER) && !this.getString(META_SYNC_DATAHUB_DOMAIN_IDENTIFIER).startsWith("urn:li:domain:")) {
            LOG.warn("Domain identifier must be in urn form (e.g., urn:li:domain:_domain_id). Provided {}. Will remove this from configuration.", (Object)this.getString(META_SYNC_DATAHUB_DOMAIN_IDENTIFIER));
            this.props.remove((Object)META_SYNC_DATAHUB_DOMAIN_IDENTIFIER.key());
        }
    }

    public HoodieDataHubDatasetIdentifier getDatasetIdentifier() {
        String identifierClass = this.getStringOrDefault(META_SYNC_DATAHUB_DATASET_IDENTIFIER_CLASS);
        HoodieDataHubDatasetIdentifier datasetIdentifier = (HoodieDataHubDatasetIdentifier)ReflectionUtils.loadClass((String)identifierClass, (Class[])new Class[]{Properties.class}, (Object[])new Object[]{this.props});
        return datasetIdentifier;
    }

    public RestEmitter getRestEmitter() {
        if (this.contains(META_SYNC_DATAHUB_EMITTER_SUPPLIER_CLASS)) {
            return (RestEmitter)((DataHubEmitterSupplier)ReflectionUtils.loadClass((String)this.getString(META_SYNC_DATAHUB_EMITTER_SUPPLIER_CLASS))).get();
        }
        if (this.contains(META_SYNC_DATAHUB_EMITTER_SERVER)) {
            return RestEmitter.create(b -> b.server(this.getString(META_SYNC_DATAHUB_EMITTER_SERVER)).token(this.getStringOrDefault(META_SYNC_DATAHUB_EMITTER_TOKEN, null)));
        }
        return RestEmitter.createWithDefaults();
    }

    public Boolean suppressExceptions() {
        return this.getBoolean(META_SYNC_DATAHUB_SYNC_SUPPRESS_EXCEPTIONS);
    }

    public String getDataHubServerEndpoint() {
        return this.getString(META_SYNC_DATAHUB_EMITTER_SERVER);
    }

    public boolean attachDomain() {
        return this.contains(META_SYNC_DATAHUB_DOMAIN_IDENTIFIER);
    }

    public String getDomainIdentifier() {
        return this.getString(META_SYNC_DATAHUB_DOMAIN_IDENTIFIER);
    }

    public static class DataHubSyncConfigParams {
        @ParametersDelegate
        public final HoodieSyncConfig.HoodieSyncConfigParams hoodieSyncConfigParams = new HoodieSyncConfig.HoodieSyncConfigParams();
        @Parameter(names={"--identifier-class"}, description="Pluggable class to help provide info to identify a DataHub Dataset.")
        public String identifierClass;
        @Parameter(names={"--emitter-server"}, description="Server URL of the DataHub instance.")
        public String emitterServer;
        @Parameter(names={"--emitter-token"}, description="Auth token to connect to the DataHub instance.")
        public String emitterToken;
        @Parameter(names={"--emitter-supplier-class"}, description="Pluggable class to supply a DataHub REST emitter to connect to the DataHub instance. This overwrites other emitter configs.")
        public String emitterSupplierClass;
        @Parameter(names={"--data-platform-name"}, description="String used to represent Hudi when creating its corresponding DataPlatform entity within Datahub")
        public String dataPlatformName;
        @Parameter(names={"--dataset-env"}, description="Which Datahub Environment to use when pushing entities")
        public String datasetEnv;
        @Parameter(names={"--domain"}, description="Domain identifier for the dataset. When provided all datasets will be attached to the provided domain. Must be in urn form (e.g., urn:li:domain:_domain_id).")
        public String domainIdentifier;
        @Parameter(names={"--suppress-exceptions"}, description="Suppress exceptions during DataHub sync.")
        public String suppressExceptions;

        public boolean isHelp() {
            return this.hoodieSyncConfigParams.isHelp();
        }

        public Properties toProps() {
            TypedProperties props = this.hoodieSyncConfigParams.toProps();
            props.setPropertyIfNonNull(META_SYNC_DATAHUB_DATASET_IDENTIFIER_CLASS.key(), (Object)this.identifierClass);
            props.setPropertyIfNonNull(META_SYNC_DATAHUB_EMITTER_SERVER.key(), (Object)this.emitterServer);
            props.setPropertyIfNonNull(META_SYNC_DATAHUB_EMITTER_TOKEN.key(), (Object)this.emitterToken);
            props.setPropertyIfNonNull(META_SYNC_DATAHUB_EMITTER_SUPPLIER_CLASS.key(), (Object)this.emitterSupplierClass);
            props.setPropertyIfNonNull(META_SYNC_DATAHUB_DATAPLATFORM_NAME.key(), (Object)this.dataPlatformName);
            props.setPropertyIfNonNull(META_SYNC_DATAHUB_DATASET_ENV.key(), (Object)this.datasetEnv);
            props.setPropertyIfNonNull(META_SYNC_DATAHUB_DOMAIN_IDENTIFIER.key(), (Object)this.domainIdentifier);
            if (this.suppressExceptions == null) {
                props.setProperty(META_SYNC_DATAHUB_SYNC_SUPPRESS_EXCEPTIONS.key(), "false");
            } else {
                props.setProperty(META_SYNC_DATAHUB_SYNC_SUPPRESS_EXCEPTIONS.key(), String.valueOf(this.suppressExceptions));
            }
            return props;
        }
    }
}

