/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub.config;

import com.linkedin.common.FabricType;
import com.linkedin.common.urn.DataPlatformUrn;
import com.linkedin.common.urn.DatasetUrn;
import com.linkedin.common.urn.Urn;
import io.datahubproject.models.util.DatabaseKey;
import java.util.Properties;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.datahub.config.DataHubSyncConfig;

public class HoodieDataHubDatasetIdentifier {
    public static final String DEFAULT_HOODIE_DATAHUB_PLATFORM_NAME = "hudi";
    public static final FabricType DEFAULT_DATAHUB_ENV = FabricType.DEV;
    protected final Properties props;
    private final DatasetUrn datasetUrn;
    private final Urn databaseUrn;
    private final String tableName;
    private final String databaseName;

    public HoodieDataHubDatasetIdentifier(Properties props) {
        this.props = props;
        if (props == null || props.isEmpty()) {
            throw new IllegalArgumentException("Properties cannot be null or empty");
        }
        DataHubSyncConfig config = new DataHubSyncConfig(props);
        this.datasetUrn = new DatasetUrn(HoodieDataHubDatasetIdentifier.createDataPlatformUrn(config.getStringOrDefault(DataHubSyncConfig.META_SYNC_DATAHUB_DATAPLATFORM_NAME)), HoodieDataHubDatasetIdentifier.createDatasetName(config.getString(HoodieSyncConfig.META_SYNC_DATABASE_NAME), config.getString(HoodieSyncConfig.META_SYNC_TABLE_NAME)), FabricType.valueOf((String)config.getStringOrDefault(DataHubSyncConfig.META_SYNC_DATAHUB_DATASET_ENV)));
        this.tableName = config.getString(HoodieSyncConfig.META_SYNC_TABLE_NAME);
        this.databaseName = config.getString(HoodieSyncConfig.META_SYNC_DATABASE_NAME);
        DatabaseKey databaseKey = ((DatabaseKey.DatabaseKeyBuilder)((DatabaseKey.DatabaseKeyBuilder)DatabaseKey.builder().platform(config.getStringOrDefault(DataHubSyncConfig.META_SYNC_DATAHUB_DATAPLATFORM_NAME))).instance(config.getStringOrDefault(DataHubSyncConfig.META_SYNC_DATAHUB_DATASET_ENV))).database(this.databaseName).build();
        this.databaseUrn = databaseKey.asUrn();
    }

    public DatasetUrn getDatasetUrn() {
        return this.datasetUrn;
    }

    public Urn getDatabaseUrn() {
        return this.databaseUrn;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    private static DataPlatformUrn createDataPlatformUrn(String platformUrn) {
        return new DataPlatformUrn(platformUrn);
    }

    private static String createDatasetName(String databaseName, String tableName) {
        return String.format("%s.%s", databaseName, tableName);
    }
}

