/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub.util;

import com.linkedin.schema.SchemaField;
import com.linkedin.schema.SchemaFieldArray;
import io.datahubproject.models.util.FieldPath;
import java.util.ArrayList;

public class SchemaFieldsUtil {
    public static SchemaFieldArray reorderPrefixedFields(SchemaFieldArray fields, String prefix) {
        if (fields == null || fields.isEmpty()) {
            return fields;
        }
        ArrayList<SchemaField> prefixedFields = new ArrayList<SchemaField>();
        ArrayList<SchemaField> normalFields = new ArrayList<SchemaField>();
        for (SchemaField field : fields) {
            FieldPath fieldPath = new FieldPath(field.getFieldPath());
            if (fieldPath.isTopLevel() && fieldPath.leafFieldName().startsWith(prefix)) {
                prefixedFields.add(field);
                continue;
            }
            normalFields.add(field);
        }
        ArrayList<SchemaField> result = new ArrayList<SchemaField>(normalFields.size() + prefixedFields.size());
        result.addAll(normalFields);
        result.addAll(prefixedFields);
        return new SchemaFieldArray(result);
    }
}

