/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.bloom.BaseHoodieBloomIndexHelper;
import org.apache.hudi.index.bloom.HoodieBloomIndex;
import org.apache.hudi.index.bloom.ListBasedHoodieBloomIndexHelper;
import org.apache.hudi.index.simple.HoodieSimpleIndex;
import org.apache.hudi.index.state.FlinkInMemoryStateIndex;

public final class FlinkHoodieIndexFactory {
    public static HoodieIndex createIndex(HoodieFlinkEngineContext context, HoodieWriteConfig config) {
        if (!StringUtils.isNullOrEmpty((String)config.getIndexClass())) {
            Object instance = ReflectionUtils.loadClass((String)config.getIndexClass(), (Object[])new Object[]{config});
            if (!(instance instanceof HoodieIndex)) {
                throw new HoodieIndexException(config.getIndexClass() + " is not a subclass of HoodieIndex");
            }
            return (HoodieIndex)instance;
        }
        switch (config.getIndexType()) {
            case INMEMORY: {
                return new FlinkInMemoryStateIndex(context, config);
            }
            case BLOOM: {
                return new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)ListBasedHoodieBloomIndexHelper.getInstance());
            }
            case SIMPLE: {
                return new HoodieSimpleIndex(config, Option.empty());
            }
        }
        throw new HoodieIndexException("Unsupported index type " + config.getIndexType());
    }
}

