/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row;

import java.util.HashMap;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.io.storage.row.RowDataParquetWriteSupport;
import org.apache.parquet.hadoop.api.WriteSupport;

public class HoodieRowDataParquetWriteSupport
extends RowDataParquetWriteSupport {
    private final Configuration hadoopConf;
    private final BloomFilter bloomFilter;
    private String minRecordKey;
    private String maxRecordKey;

    public HoodieRowDataParquetWriteSupport(Configuration conf, RowType rowType, BloomFilter bloomFilter) {
        super(rowType);
        this.hadoopConf = new Configuration(conf);
        this.bloomFilter = bloomFilter;
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    public WriteSupport.FinalizedWriteContext finalizeWrite() {
        HashMap<String, String> extraMetaData = new HashMap<String, String>();
        if (this.bloomFilter != null) {
            extraMetaData.put("org.apache.hudi.bloomfilter", this.bloomFilter.serializeToString());
            if (this.minRecordKey != null && this.maxRecordKey != null) {
                extraMetaData.put("hoodie_min_record_key", this.minRecordKey);
                extraMetaData.put("hoodie_max_record_key", this.maxRecordKey);
            }
            if (this.bloomFilter.getBloomFilterTypeCode().name().contains("DYNAMIC")) {
                extraMetaData.put("hoodie_bloom_filter_type_code", this.bloomFilter.getBloomFilterTypeCode().name());
            }
        }
        return new WriteSupport.FinalizedWriteContext(extraMetaData);
    }

    public void add(String recordKey) {
        this.bloomFilter.add(recordKey);
        this.minRecordKey = this.minRecordKey != null ? (this.minRecordKey.compareTo(recordKey) <= 0 ? this.minRecordKey : recordKey) : recordKey;
        this.maxRecordKey = this.maxRecordKey != null ? (this.maxRecordKey.compareTo(recordKey) >= 0 ? this.maxRecordKey : recordKey) : recordKey;
    }
}

