/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.MiniBatchHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FlinkMergeHandle<T extends HoodieRecordPayload, I, K, O>
extends HoodieMergeHandle<T, I, K, O>
implements MiniBatchHandle {
    private static final Logger LOG = LogManager.getLogger(FlinkMergeHandle.class);
    private boolean isClosed = false;
    private List<Path> rolloverPaths;

    public FlinkMergeHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier) {
        super(config, instantTime, hoodieTable, recordItr, partitionPath, fileId, taskContextSupplier, Option.empty());
        if (this.rolloverPaths == null) {
            this.rolloverPaths = new ArrayList<Path>();
        }
        if (this.getAttemptId() > 0L) {
            this.deleteInvalidDataFile(this.getAttemptId() - 1L);
        }
    }

    private void deleteInvalidDataFile(long lastAttemptId) {
        String lastWriteToken = FSUtils.makeWriteToken((int)this.getPartitionId(), (int)this.getStageId(), (long)lastAttemptId);
        String lastDataFileName = FSUtils.makeBaseFileName((String)this.instantTime, (String)lastWriteToken, (String)this.fileId, (String)this.hoodieTable.getBaseFileExtension());
        Path path = this.makeNewFilePath(this.partitionPath, lastDataFileName);
        if (path.equals((Object)this.oldFilePath)) {
            return;
        }
        try {
            if (this.fs.exists(path)) {
                LOG.info((Object)("Deleting invalid MERGE base file due to task retry: " + lastDataFileName));
                this.fs.delete(path, false);
            }
        }
        catch (IOException e) {
            throw new HoodieException("Error while deleting the MERGE base file due to task retry: " + lastDataFileName, (Throwable)e);
        }
    }

    protected void createMarkerFile(String partitionPath, String dataFileName) {
        WriteMarkers writeMarkers = WriteMarkersFactory.get((MarkerType)this.config.getMarkersType(), (HoodieTable)this.hoodieTable, (String)this.instantTime);
        writeMarkers.createIfNotExists(partitionPath, dataFileName, this.getIOType());
    }

    protected void makeOldAndNewFilePaths(String partitionPath, String oldFileName, String newFileName) {
        super.makeOldAndNewFilePaths(partitionPath, oldFileName, newFileName);
        this.rolloverPaths = new ArrayList<Path>();
        try {
            int rollNumber = 0;
            while (this.fs.exists(this.newFilePath)) {
                if (this.fs.getFileStatus(this.newFilePath).getLen() <= 0L) {
                    this.fs.delete(this.newFilePath, false);
                    LOG.warn((Object)("Delete empty write file for MERGE bucket: " + this.newFilePath));
                    break;
                }
                this.oldFilePath = this.newFilePath;
                this.rolloverPaths.add(this.oldFilePath);
                newFileName = this.newFileNameWithRollover(rollNumber++);
                this.newFilePath = this.makeNewFilePath(partitionPath, newFileName);
                LOG.warn((Object)("Duplicate write for MERGE bucket with path: " + this.oldFilePath + ", rolls over to new path: " + this.newFilePath));
            }
        }
        catch (IOException e) {
            throw new HoodieException("Checking existing path for merge handle error: " + this.newFilePath, (Throwable)e);
        }
    }

    protected String newFileNameWithRollover(int rollNumber) {
        return FSUtils.makeBaseFileName((String)this.instantTime, (String)(this.writeToken + "-" + rollNumber), (String)this.fileId, (String)this.hoodieTable.getBaseFileExtension());
    }

    protected void setWriteStatusPath() {
        this.writeStatus.getStat().setPath(new Path(this.config.getBasePath()), this.getWritePath());
    }

    public List<WriteStatus> close() {
        try {
            List writeStatus = super.close();
            this.finalizeWrite();
            List list = writeStatus;
            return list;
        }
        finally {
            this.isClosed = true;
        }
    }

    boolean needsUpdateLocation() {
        return false;
    }

    @Override
    public void finalizeWrite() {
        if (this.rolloverPaths.size() == 0) {
            return;
        }
        for (Path path : this.rolloverPaths) {
            try {
                this.fs.delete(path, false);
                LOG.info((Object)("Delete the rollover data file: " + path + " success!"));
            }
            catch (IOException e) {
                throw new HoodieIOException("Error when clean the temporary rollover data file: " + path, e);
            }
        }
        Path desiredPath = this.rolloverPaths.get(0);
        try {
            this.fs.rename(this.newFilePath, desiredPath);
        }
        catch (IOException e) {
            throw new HoodieIOException("Error when rename the temporary roll file: " + this.newFilePath + " to: " + desiredPath, e);
        }
    }

    @Override
    public void closeGracefully() {
        if (this.isClosed) {
            return;
        }
        try {
            this.close();
        }
        catch (Throwable throwable) {
            LOG.warn((Object)"Error while trying to dispose the MERGE handle", throwable);
            try {
                this.fs.delete(this.newFilePath, false);
                LOG.info((Object)("Deleting the intermediate MERGE data file: " + this.newFilePath + " success!"));
            }
            catch (IOException e) {
                LOG.warn((Object)("Deleting the intermediate MERGE data file: " + this.newFilePath + " failed"), (Throwable)e);
            }
        }
    }

    @Override
    public Path getWritePath() {
        return this.rolloverPaths.size() > 0 ? this.rolloverPaths.get(0) : this.newFilePath;
    }
}

