/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.util.List;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.FlinkHoodieIndexFactory;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.metadata.FlinkHoodieBackedTableMetadataWriter;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.table.ExplicitWriteHandleTable;
import org.apache.hudi.table.HoodieFlinkCopyOnWriteTable;
import org.apache.hudi.table.HoodieFlinkMergeOnReadTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;

public abstract class HoodieFlinkTable<T extends HoodieRecordPayload>
extends HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>>
implements ExplicitWriteHandleTable<T> {
    protected HoodieFlinkTable(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        super(config, context, metaClient);
    }

    public static <T extends HoodieRecordPayload> HoodieFlinkTable<T> create(HoodieWriteConfig config, HoodieFlinkEngineContext context) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(context.getHadoopConf().get()).setBasePath(config.getBasePath()).setLoadActiveTimelineOnLoad(true).setConsistencyGuardConfig(config.getConsistencyGuardConfig()).setLayoutVersion(Option.of((Object)new TimelineLayoutVersion(config.getTimelineLayoutVersion()))).setFileSystemRetryConfig(config.getFileSystemRetryConfig()).build();
        return HoodieFlinkTable.create(config, context, metaClient);
    }

    public static <T extends HoodieRecordPayload> HoodieFlinkTable<T> create(HoodieWriteConfig config, HoodieFlinkEngineContext context, HoodieTableMetaClient metaClient) {
        HoodieFlinkCopyOnWriteTable hoodieFlinkTable;
        switch (metaClient.getTableType()) {
            case COPY_ON_WRITE: {
                hoodieFlinkTable = new HoodieFlinkCopyOnWriteTable(config, context, metaClient);
                break;
            }
            case MERGE_ON_READ: {
                hoodieFlinkTable = new HoodieFlinkMergeOnReadTable(config, context, metaClient);
                break;
            }
            default: {
                throw new HoodieException("Unsupported table type :" + metaClient.getTableType());
            }
        }
        return hoodieFlinkTable;
    }

    public static HoodieWriteMetadata<List<WriteStatus>> convertMetadata(HoodieWriteMetadata<HoodieData<WriteStatus>> metadata) {
        return metadata.clone((Object)((HoodieData)metadata.getWriteStatuses()).collectAsList());
    }

    protected HoodieIndex getIndex(HoodieWriteConfig config, HoodieEngineContext context) {
        return FlinkHoodieIndexFactory.createIndex((HoodieFlinkEngineContext)context, config);
    }

    public <T extends SpecificRecordBase> Option<HoodieTableMetadataWriter> getMetadataWriter(String triggeringInstantTimestamp, Option<T> actionMetadata) {
        if (this.config.isMetadataTableEnabled()) {
            return Option.of((Object)FlinkHoodieBackedTableMetadataWriter.create(this.context.getHadoopConf().get(), this.config, this.context, actionMetadata, (Option<String>)Option.of((Object)triggeringInstantTimestamp)));
        }
        return Option.empty();
    }
}

