/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit.delta;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.execution.FlinkLazyInsertIterable;
import org.apache.hudi.io.ExplicitWriteHandleFactory;
import org.apache.hudi.io.FlinkAppendHandle;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.BaseFlinkCommitActionExecutor;

public abstract class BaseFlinkDeltaCommitActionExecutor<T extends HoodieRecordPayload<T>>
extends BaseFlinkCommitActionExecutor<T> {
    public BaseFlinkDeltaCommitActionExecutor(HoodieEngineContext context, FlinkAppendHandle<?, ?, ?, ?> writeHandle, HoodieWriteConfig config, HoodieTable table, String instantTime, WriteOperationType operationType) {
        super(context, (HoodieWriteHandle<?, ?, ?, ?>)writeHandle, config, table, instantTime, operationType);
    }

    @Override
    public Iterator<List<WriteStatus>> handleUpdate(String partitionPath, String fileId, Iterator<HoodieRecord<T>> recordItr) {
        FlinkAppendHandle appendHandle = (FlinkAppendHandle)this.writeHandle;
        appendHandle.doAppend();
        List<WriteStatus> writeStatuses = appendHandle.close();
        return Collections.singletonList(writeStatuses).iterator();
    }

    @Override
    public Iterator<List<WriteStatus>> handleInsert(String idPfx, Iterator<HoodieRecord<T>> recordItr) {
        return new FlinkLazyInsertIterable<T>(recordItr, true, this.config, this.instantTime, this.table, idPfx, this.taskContextSupplier, new ExplicitWriteHandleFactory(this.writeHandle));
    }
}

