/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.HoodieCreateHandle;
import org.apache.hudi.io.MiniBatchHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FlinkCreateHandle<T extends HoodieRecordPayload, I, K, O>
extends HoodieCreateHandle<T, I, K, O>
implements MiniBatchHandle {
    private static final Logger LOG = LogManager.getLogger(FlinkCreateHandle.class);
    private boolean isClosed = false;

    public FlinkCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier) {
        this(config, instantTime, hoodieTable, partitionPath, fileId, (Option<Schema>)Option.empty(), taskContextSupplier);
    }

    public FlinkCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, Option<Schema> schemaOption, TaskContextSupplier taskContextSupplier) {
        super(config, instantTime, hoodieTable, partitionPath, fileId, schemaOption, taskContextSupplier);
        if (this.getAttemptId() > 0L) {
            this.deleteInvalidDataFile(this.getAttemptId() - 1L);
        }
    }

    private void deleteInvalidDataFile(long lastAttemptId) {
        String lastWriteToken = FSUtils.makeWriteToken((int)this.getPartitionId(), (int)this.getStageId(), (long)lastAttemptId);
        String lastDataFileName = FSUtils.makeBaseFileName((String)this.instantTime, (String)lastWriteToken, (String)this.fileId, (String)this.hoodieTable.getBaseFileExtension());
        Path path = this.makeNewFilePath(this.partitionPath, lastDataFileName);
        try {
            if (this.fs.exists(path)) {
                LOG.info((Object)("Deleting invalid INSERT file due to task retry: " + lastDataFileName));
                this.fs.delete(path, false);
            }
        }
        catch (IOException e) {
            throw new HoodieException("Error while deleting the INSERT file due to task retry: " + lastDataFileName, (Throwable)e);
        }
    }

    protected void createMarkerFile(String partitionPath, String dataFileName) {
        WriteMarkers writeMarkers = WriteMarkersFactory.get((MarkerType)this.config.getMarkersType(), (HoodieTable)this.hoodieTable, (String)this.instantTime);
        writeMarkers.createIfNotExists(partitionPath, dataFileName, this.getIOType());
    }

    public Path makeNewPath(String partitionPath) {
        Path path = super.makeNewPath(partitionPath);
        try {
            int rollNumber = 0;
            while (this.fs.exists(path)) {
                Path existing = path;
                path = this.newFilePathWithRollover(rollNumber++);
                LOG.warn((Object)("Duplicate write for INSERT bucket with path: " + existing + ", rolls over to new path: " + path));
            }
            return path;
        }
        catch (IOException e) {
            throw new HoodieException("Checking existing path for create handle error: " + path, (Throwable)e);
        }
    }

    public boolean canWrite(HoodieRecord record) {
        return true;
    }

    private Path newFilePathWithRollover(int rollNumber) {
        String dataFileName = FSUtils.makeBaseFileName((String)this.instantTime, (String)(this.writeToken + "-" + rollNumber), (String)this.fileId, (String)this.hoodieTable.getBaseFileExtension());
        return this.makeNewFilePath(this.partitionPath, dataFileName);
    }

    public List<WriteStatus> close() {
        try {
            List list = super.close();
            return list;
        }
        finally {
            this.isClosed = true;
        }
    }

    @Override
    public void closeGracefully() {
        if (this.isClosed) {
            return;
        }
        try {
            this.close();
        }
        catch (Throwable throwable) {
            LOG.warn((Object)"Error while trying to dispose the CREATE handle", throwable);
            try {
                this.fs.delete(this.path, false);
                LOG.info((Object)("Deleting the intermediate CREATE data file: " + this.path + " success!"));
            }
            catch (IOException e) {
                LOG.warn((Object)("Deleting the intermediate CREATE data file: " + this.path + " failed"), (Throwable)e);
            }
        }
    }

    @Override
    public Path getWritePath() {
        return this.path;
    }
}

