/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieIndexCommitMetadata;
import org.apache.hudi.avro.model.HoodieIndexPlan;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.io.HoodieCreateHandle;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.HoodieSortedMergeHandle;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieAvroKeyGeneratorFactory;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieCompactionHandler;
import org.apache.hudi.table.HoodieFlinkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.bootstrap.HoodieBootstrapWriteMetadata;
import org.apache.hudi.table.action.clean.CleanActionExecutor;
import org.apache.hudi.table.action.clean.CleanPlanActionExecutor;
import org.apache.hudi.table.action.cluster.ClusteringPlanActionExecutor;
import org.apache.hudi.table.action.commit.FlinkDeleteCommitActionExecutor;
import org.apache.hudi.table.action.commit.FlinkInsertCommitActionExecutor;
import org.apache.hudi.table.action.commit.FlinkInsertOverwriteCommitActionExecutor;
import org.apache.hudi.table.action.commit.FlinkInsertOverwriteTableCommitActionExecutor;
import org.apache.hudi.table.action.commit.FlinkInsertPreppedCommitActionExecutor;
import org.apache.hudi.table.action.commit.FlinkMergeHelper;
import org.apache.hudi.table.action.commit.FlinkUpsertCommitActionExecutor;
import org.apache.hudi.table.action.commit.FlinkUpsertPreppedCommitActionExecutor;
import org.apache.hudi.table.action.rollback.BaseRollbackPlanActionExecutor;
import org.apache.hudi.table.action.rollback.CopyOnWriteRollbackActionExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieFlinkCopyOnWriteTable<T extends HoodieRecordPayload>
extends HoodieFlinkTable<T>
implements HoodieCompactionHandler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieFlinkCopyOnWriteTable.class);

    public HoodieFlinkCopyOnWriteTable(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        super(config, context, metaClient);
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> upsert(HoodieEngineContext context, HoodieWriteHandle<?, ?, ?, ?> writeHandle, String instantTime, List<HoodieRecord<T>> records) {
        return new FlinkUpsertCommitActionExecutor<T>(context, writeHandle, this.config, (HoodieTable)this, instantTime, records).execute();
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> insert(HoodieEngineContext context, HoodieWriteHandle<?, ?, ?, ?> writeHandle, String instantTime, List<HoodieRecord<T>> records) {
        return new FlinkInsertCommitActionExecutor<T>(context, writeHandle, this.config, (HoodieTable)this, instantTime, records).execute();
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> delete(HoodieEngineContext context, HoodieWriteHandle<?, ?, ?, ?> writeHandle, String instantTime, List<HoodieKey> keys) {
        return new FlinkDeleteCommitActionExecutor(context, writeHandle, this.config, (HoodieTable)this, instantTime, keys).execute();
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> upsertPrepped(HoodieEngineContext context, HoodieWriteHandle<?, ?, ?, ?> writeHandle, String instantTime, List<HoodieRecord<T>> preppedRecords) {
        return new FlinkUpsertPreppedCommitActionExecutor<T>(context, writeHandle, this.config, (HoodieTable)this, instantTime, preppedRecords).execute();
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> insertPrepped(HoodieEngineContext context, HoodieWriteHandle<?, ?, ?, ?> writeHandle, String instantTime, List<HoodieRecord<T>> preppedRecords) {
        return new FlinkInsertPreppedCommitActionExecutor<T>(context, writeHandle, this.config, (HoodieTable)this, instantTime, preppedRecords).execute();
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> insertOverwrite(HoodieEngineContext context, HoodieWriteHandle<?, ?, ?, ?> writeHandle, String instantTime, List<HoodieRecord<T>> records) {
        return new FlinkInsertOverwriteCommitActionExecutor<T>(context, writeHandle, this.config, (HoodieTable)this, instantTime, records).execute();
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> insertOverwriteTable(HoodieEngineContext context, HoodieWriteHandle<?, ?, ?, ?> writeHandle, String instantTime, List<HoodieRecord<T>> records) {
        return new FlinkInsertOverwriteTableCommitActionExecutor<T>(context, writeHandle, this.config, (HoodieTable)this, instantTime, records).execute();
    }

    public HoodieWriteMetadata<List<WriteStatus>> upsert(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> records) {
        throw new HoodieNotSupportedException("This method should not be invoked");
    }

    public HoodieWriteMetadata<List<WriteStatus>> insert(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> records) {
        throw new HoodieNotSupportedException("This method should not be invoked");
    }

    public HoodieWriteMetadata<List<WriteStatus>> bulkInsert(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> records, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
        throw new HoodieNotSupportedException("BulkInsert is not supported yet");
    }

    public HoodieWriteMetadata<List<WriteStatus>> delete(HoodieEngineContext context, String instantTime, List<HoodieKey> keys) {
        throw new HoodieNotSupportedException("This method should not be invoked");
    }

    public HoodieWriteMetadata deletePartitions(HoodieEngineContext context, String instantTime, List<String> partitions) {
        throw new HoodieNotSupportedException("DeletePartitions is not supported yet");
    }

    public HoodieWriteMetadata<List<WriteStatus>> upsertPrepped(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> preppedRecords) {
        throw new HoodieNotSupportedException("This method should not be invoked");
    }

    public HoodieWriteMetadata<List<WriteStatus>> insertPrepped(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> preppedRecords) {
        throw new HoodieNotSupportedException("This method should not be invoked");
    }

    public HoodieWriteMetadata<List<WriteStatus>> bulkInsertPrepped(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> preppedRecords, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
        throw new HoodieNotSupportedException("BulkInsertPrepped is not supported yet");
    }

    public HoodieWriteMetadata<List<WriteStatus>> insertOverwrite(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> records) {
        throw new HoodieNotSupportedException("This method should not be invoked");
    }

    public HoodieWriteMetadata<List<WriteStatus>> insertOverwriteTable(HoodieEngineContext context, String instantTime, List<HoodieRecord<T>> records) {
        throw new HoodieNotSupportedException("This method should not be invoked");
    }

    public Option<HoodieCompactionPlan> scheduleCompaction(HoodieEngineContext context, String instantTime, Option<Map<String, String>> extraMetadata) {
        throw new HoodieNotSupportedException("Compaction is not supported on a CopyOnWrite table");
    }

    public HoodieWriteMetadata<List<WriteStatus>> compact(HoodieEngineContext context, String compactionInstantTime) {
        throw new HoodieNotSupportedException("Compaction is not supported on a CopyOnWrite table");
    }

    public Option<HoodieClusteringPlan> scheduleClustering(HoodieEngineContext context, String instantTime, Option<Map<String, String>> extraMetadata) {
        return new ClusteringPlanActionExecutor(context, this.config, (HoodieTable)this, instantTime, extraMetadata).execute();
    }

    public HoodieWriteMetadata<List<WriteStatus>> cluster(HoodieEngineContext context, String clusteringInstantTime) {
        throw new HoodieNotSupportedException("Clustering is not supported on a Flink CopyOnWrite table");
    }

    public HoodieBootstrapWriteMetadata<List<WriteStatus>> bootstrap(HoodieEngineContext context, Option<Map<String, String>> extraMetadata) {
        throw new HoodieNotSupportedException("Bootstrap is not supported yet");
    }

    public void rollbackBootstrap(HoodieEngineContext context, String instantTime) {
        throw new HoodieNotSupportedException("Bootstrap is not supported yet");
    }

    public Option<HoodieCleanerPlan> scheduleCleaning(HoodieEngineContext context, String instantTime, Option<Map<String, String>> extraMetadata) {
        return new CleanPlanActionExecutor(context, this.config, (HoodieTable)this, instantTime, extraMetadata).execute();
    }

    public Option<HoodieRollbackPlan> scheduleRollback(HoodieEngineContext context, String instantTime, HoodieInstant instantToRollback, boolean skipTimelinePublish, boolean shouldRollbackUsingMarkers) {
        return new BaseRollbackPlanActionExecutor(context, this.config, (HoodieTable)this, instantTime, instantToRollback, skipTimelinePublish, shouldRollbackUsingMarkers).execute();
    }

    public HoodieCleanMetadata clean(HoodieEngineContext context, String cleanInstantTime, boolean skipLocking) {
        return new CleanActionExecutor(context, this.config, (HoodieTable)this, cleanInstantTime).execute();
    }

    public HoodieRollbackMetadata rollback(HoodieEngineContext context, String rollbackInstantTime, HoodieInstant commitInstant, boolean deleteInstants, boolean skipLocking) {
        return new CopyOnWriteRollbackActionExecutor(context, this.config, (HoodieTable)this, rollbackInstantTime, commitInstant, deleteInstants, skipLocking).execute();
    }

    public Option<HoodieIndexPlan> scheduleIndexing(HoodieEngineContext context, String indexInstantTime, List<MetadataPartitionType> partitionsToIndex) {
        throw new HoodieNotSupportedException("Metadata indexing is not supported for a Flink table yet.");
    }

    public Option<HoodieIndexCommitMetadata> index(HoodieEngineContext context, String indexInstantTime) {
        throw new HoodieNotSupportedException("Metadata indexing is not supported for a Flink table yet.");
    }

    public HoodieSavepointMetadata savepoint(HoodieEngineContext context, String instantToSavepoint, String user, String comment) {
        throw new HoodieNotSupportedException("Savepoint is not supported yet");
    }

    public Option<HoodieRestorePlan> scheduleRestore(HoodieEngineContext context, String restoreInstantTime, String instantToRestore) {
        throw new HoodieNotSupportedException("Restore is not supported yet");
    }

    public HoodieRestoreMetadata restore(HoodieEngineContext context, String restoreInstantTime, String instantToRestore) {
        throw new HoodieNotSupportedException("Savepoint and restore is not supported yet");
    }

    public Iterator<List<WriteStatus>> handleUpdate(String instantTime, String partitionPath, String fileId, Map<String, HoodieRecord<T>> keyToNewRecords, HoodieBaseFile oldDataFile) throws IOException {
        HoodieMergeHandle upsertHandle = this.getUpdateHandle(instantTime, partitionPath, fileId, keyToNewRecords, oldDataFile);
        return this.handleUpdateInternal(upsertHandle, instantTime, fileId);
    }

    protected Iterator<List<WriteStatus>> handleUpdateInternal(HoodieMergeHandle<?, ?, ?, ?> upsertHandle, String instantTime, String fileId) throws IOException {
        if (upsertHandle.getOldFilePath() == null) {
            throw new HoodieUpsertException("Error in finding the old file path at commit " + instantTime + " for fileId: " + fileId);
        }
        FlinkMergeHelper.newInstance().runMerge(this, upsertHandle);
        if (upsertHandle.getPartitionPath() == null) {
            LOG.info("Upsert Handle has partition path as null " + upsertHandle.getOldFilePath() + ", " + upsertHandle.writeStatuses());
        }
        return Collections.singletonList(upsertHandle.writeStatuses()).iterator();
    }

    protected HoodieMergeHandle getUpdateHandle(String instantTime, String partitionPath, String fileId, Map<String, HoodieRecord<T>> keyToNewRecords, HoodieBaseFile dataFileToBeMerged) {
        Option keyGeneratorOpt = Option.empty();
        if (!this.config.populateMetaFields()) {
            try {
                keyGeneratorOpt = Option.of((Object)((BaseKeyGenerator)HoodieAvroKeyGeneratorFactory.createKeyGenerator((TypedProperties)new TypedProperties((Properties)this.config.getProps()))));
            }
            catch (IOException e) {
                throw new HoodieIOException("Only BaseKeyGenerator (or any key generator that extends from BaseKeyGenerator) are supported when meta columns are disabled. Please choose the right key generator if you wish to disable meta fields.", e);
            }
        }
        if (this.requireSortedRecords()) {
            return new HoodieSortedMergeHandle(this.config, instantTime, (HoodieTable)this, keyToNewRecords, partitionPath, fileId, dataFileToBeMerged, this.taskContextSupplier, keyGeneratorOpt);
        }
        return new HoodieMergeHandle(this.config, instantTime, (HoodieTable)this, keyToNewRecords, partitionPath, fileId, dataFileToBeMerged, this.taskContextSupplier, keyGeneratorOpt);
    }

    public Iterator<List<WriteStatus>> handleInsert(String instantTime, String partitionPath, String fileId, Map<String, HoodieRecord<? extends HoodieRecordPayload>> recordMap) {
        HoodieCreateHandle createHandle = new HoodieCreateHandle(this.config, instantTime, (HoodieTable)this, partitionPath, fileId, recordMap, this.taskContextSupplier);
        createHandle.write();
        return Collections.singletonList(createHandle.close()).iterator();
    }
}

