/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.queue.HoodieConsumer;
import org.apache.hudi.common.util.queue.HoodieExecutor;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.ExplicitWriteHandler;
import org.apache.hudi.execution.HoodieLazyInsertIterable;
import org.apache.hudi.io.ExplicitWriteHandleFactory;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.util.ExecutorFactory;

public class FlinkLazyInsertIterable<T>
extends HoodieLazyInsertIterable<T> {
    public FlinkLazyInsertIterable(Iterator<HoodieRecord<T>> recordItr, boolean areRecordsSorted, HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier, ExplicitWriteHandleFactory writeHandleFactory) {
        super(recordItr, areRecordsSorted, config, instantTime, hoodieTable, idPrefix, taskContextSupplier, (WriteHandleFactory)writeHandleFactory);
    }

    protected List<WriteStatus> computeNext() {
        HoodieExecutor executor = null;
        try {
            Schema schema = new Schema.Parser().parse(this.hoodieConfig.getSchema());
            executor = ExecutorFactory.create((HoodieWriteConfig)this.hoodieConfig, (Iterator)this.inputItr, (HoodieConsumer)this.getExplicitInsertHandler(), (Function)this.getTransformer(schema, this.hoodieConfig));
            List result = (List)executor.execute();
            ValidationUtils.checkState((result != null && !result.isEmpty() ? 1 : 0) != 0);
            List list = result;
            return list;
        }
        catch (Exception e) {
            throw new HoodieException((Throwable)e);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
                executor.awaitTermination();
            }
        }
    }

    private ExplicitWriteHandler getExplicitInsertHandler() {
        HoodieWriteHandle handle = ((ExplicitWriteHandleFactory)this.writeHandleFactory).getWriteHandle();
        return new ExplicitWriteHandler(handle);
    }
}

