/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row;

import java.io.IOException;
import org.apache.flink.table.data.RowData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.hudi.io.storage.row.HoodieRowDataFileWriter;
import org.apache.hudi.io.storage.row.HoodieRowDataParquetWriteSupport;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;

public class HoodieRowDataParquetWriter
extends ParquetWriter<RowData>
implements HoodieRowDataFileWriter {
    private final Path file;
    private final HoodieWrapperFileSystem fs;
    private final long maxFileSize;
    private final HoodieRowDataParquetWriteSupport writeSupport;

    public HoodieRowDataParquetWriter(Path file, HoodieParquetConfig<HoodieRowDataParquetWriteSupport> parquetConfig) throws IOException {
        super(HoodieWrapperFileSystem.convertToHoodiePath((Path)file, (Configuration)parquetConfig.getHadoopConf()), ParquetFileWriter.Mode.CREATE, (WriteSupport)parquetConfig.getWriteSupport(), parquetConfig.getCompressionCodecName(), parquetConfig.getBlockSize(), parquetConfig.getPageSize(), parquetConfig.getPageSize(), true, false, DEFAULT_WRITER_VERSION, FSUtils.registerFileSystem((Path)file, (Configuration)parquetConfig.getHadoopConf()));
        this.file = HoodieWrapperFileSystem.convertToHoodiePath((Path)file, (Configuration)parquetConfig.getHadoopConf());
        this.fs = (HoodieWrapperFileSystem)this.file.getFileSystem(FSUtils.registerFileSystem((Path)file, (Configuration)parquetConfig.getHadoopConf()));
        this.maxFileSize = parquetConfig.getMaxFileSize() + Math.round((double)parquetConfig.getMaxFileSize() * parquetConfig.getCompressionRatio());
        this.writeSupport = (HoodieRowDataParquetWriteSupport)((Object)parquetConfig.getWriteSupport());
    }

    @Override
    public boolean canWrite() {
        return this.fs.getBytesWritten(this.file) < this.maxFileSize;
    }

    @Override
    public void writeRow(String key, RowData row) throws IOException {
        super.write((Object)row);
        this.writeSupport.add(key);
    }

    @Override
    public void writeRow(RowData row) throws IOException {
        super.write((Object)row);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

