/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.HoodieFlinkWriteClient;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.metadata.HoodieBackedTableMetadataWriter;
import org.apache.hudi.metadata.HoodieMetadataMetrics;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkHoodieBackedTableMetadataWriter
extends HoodieBackedTableMetadataWriter<List<HoodieRecord>> {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkHoodieBackedTableMetadataWriter.class);

    public static HoodieTableMetadataWriter create(Configuration conf, HoodieWriteConfig writeConfig, HoodieEngineContext context) {
        return new FlinkHoodieBackedTableMetadataWriter(conf, writeConfig, HoodieFailedWritesCleaningPolicy.EAGER, context, (Option<String>)Option.empty());
    }

    public static HoodieTableMetadataWriter create(Configuration conf, HoodieWriteConfig writeConfig, HoodieEngineContext context, Option<String> inFlightInstantTimestamp) {
        return new FlinkHoodieBackedTableMetadataWriter(conf, writeConfig, HoodieFailedWritesCleaningPolicy.EAGER, context, inFlightInstantTimestamp);
    }

    public static HoodieTableMetadataWriter create(Configuration conf, HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, HoodieEngineContext context, Option<String> inFlightInstantTimestamp) {
        return new FlinkHoodieBackedTableMetadataWriter(conf, writeConfig, failedWritesCleaningPolicy, context, inFlightInstantTimestamp);
    }

    FlinkHoodieBackedTableMetadataWriter(Configuration hadoopConf, HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, HoodieEngineContext engineContext, Option<String> inFlightInstantTimestamp) {
        super(hadoopConf, writeConfig, failedWritesCleaningPolicy, engineContext, inFlightInstantTimestamp);
    }

    protected void initRegistry() {
        if (this.metadataWriteConfig.isMetricsOn()) {
            Registry registry = Registry.getRegistry((String)"HoodieMetadata");
            this.metrics = Option.of((Object)new HoodieMetadataMetrics(registry));
        } else {
            this.metrics = Option.empty();
        }
    }

    protected void commit(String instantTime, Map<MetadataPartitionType, HoodieData<HoodieRecord>> partitionRecordsMap) {
        this.commitInternal(instantTime, partitionRecordsMap, false, (Option<BulkInsertPartitioner>)Option.empty());
    }

    protected List<HoodieRecord> convertHoodieDataToEngineSpecificData(HoodieData<HoodieRecord> records) {
        return records.collectAsList();
    }

    protected void bulkCommit(String instantTime, MetadataPartitionType partitionType, HoodieData<HoodieRecord> records, int fileGroupCount) {
        this.commitInternal(instantTime, Collections.singletonMap(partitionType, records), true, (Option<BulkInsertPartitioner>)Option.empty());
    }

    protected void commitInternal(String instantTime, Map<MetadataPartitionType, HoodieData<HoodieRecord>> partitionRecordsMap, boolean isInitializing, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
        ValidationUtils.checkState((this.metadataMetaClient != null ? 1 : 0) != 0, (String)"Metadata table is not fully initialized yet.");
        HoodieData preppedRecords = this.prepRecords(partitionRecordsMap);
        List preppedRecordList = preppedRecords.collectAsList();
        BaseHoodieWriteClient writeClient = this.getWriteClient();
        if (writeClient.rollbackFailedWrites()) {
            this.metadataMetaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metadataMetaClient);
        }
        this.metadataMetaClient.getActiveTimeline().getDeltaCommitTimeline().filterCompletedInstants().lastInstant().ifPresent(instant -> this.compactIfNecessary(writeClient, instant.getTimestamp()));
        if (!this.metadataMetaClient.getActiveTimeline().containsInstant(instantTime)) {
            LOG.info("New commit at " + instantTime + " being applied to MDT.");
        } else {
            Option alreadyCompletedInstant = this.metadataMetaClient.getActiveTimeline().filterCompletedInstants().filter(entry -> entry.getTimestamp().equals(instantTime)).lastInstant();
            LOG.info(String.format("%s completed commit at %s being applied to MDT.", alreadyCompletedInstant.isPresent() ? "Already" : "Partially", instantTime));
            if (!writeClient.rollback(instantTime)) {
                throw new HoodieMetadataException("Failed to rollback deltacommit at " + instantTime + " from MDT");
            }
            this.metadataMetaClient.reloadActiveTimeline();
        }
        writeClient.startCommitWithTime(instantTime);
        this.preWrite(instantTime);
        List statuses = isInitializing ? (List)writeClient.bulkInsertPreppedRecords((Object)preppedRecordList, instantTime, Option.empty()) : (List)writeClient.upsertPreppedRecords((Object)preppedRecordList, instantTime);
        writeClient.commit(instantTime, (Object)statuses, Option.empty(), "deltacommit", Collections.emptyMap());
        this.metadataMetaClient.reloadActiveTimeline();
        this.metadataMetaClient.getActiveTimeline().getDeltaCommitTimeline().filterCompletedInstants().lastInstant().ifPresent(instant -> this.cleanIfNecessary(writeClient, instant.getTimestamp()));
        writeClient.archive();
        this.metrics.ifPresent(m -> m.updateSizeMetrics(this.metadataMetaClient, this.metadata, this.dataMetaClient.getTableConfig().getMetadataPartitions()));
    }

    protected boolean validateTimelineBeforeSchedulingCompaction(Option<String> inFlightInstantTimestamp, String latestDeltaCommitTimeInMetadataTable) {
        return true;
    }

    protected void validateRollback(String commitToRollbackInstantTime, HoodieInstant compactionInstant, HoodieTimeline deltacommitsSinceCompaction) {
    }

    public void deletePartitions(String instantTime, List<MetadataPartitionType> partitions) {
        throw new HoodieNotSupportedException("Dropping metadata index not supported for Flink metadata table yet.");
    }

    public BaseHoodieWriteClient<?, List<HoodieRecord>, ?, ?> initializeWriteClient() {
        return new HoodieFlinkWriteClient(this.engineContext, this.metadataWriteConfig);
    }

    protected void preWrite(String instantTime) {
        this.metadataMetaClient.getActiveTimeline().transitionRequestedToInflight("deltacommit", instantTime);
    }
}

