/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.MiniBatchHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkMergeAndReplaceHandle<T, I, K, O>
extends HoodieMergeHandle<T, I, K, O>
implements MiniBatchHandle {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkMergeAndReplaceHandle.class);
    private boolean isClosed = false;
    private boolean shouldReplace = true;

    public FlinkMergeAndReplaceHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier, Path basePath) {
        super(config, instantTime, hoodieTable, recordItr, partitionPath, fileId, taskContextSupplier, new HoodieBaseFile(basePath.toString()), Option.empty());
        if (this.getAttemptId() > 0L) {
            this.deleteInvalidDataFile(this.getAttemptId() - 1L);
        }
    }

    private void deleteInvalidDataFile(long lastAttemptId) {
        String lastWriteToken = FSUtils.makeWriteToken((int)this.getPartitionId(), (int)this.getStageId(), (long)lastAttemptId);
        String lastDataFileName = FSUtils.makeBaseFileName((String)this.instantTime, (String)lastWriteToken, (String)this.fileId, (String)this.hoodieTable.getBaseFileExtension());
        Path path = this.makeNewFilePath(this.partitionPath, lastDataFileName);
        try {
            if (this.fs.exists(path)) {
                LOG.info("Deleting invalid MERGE and REPLACE base file due to task retry: " + lastDataFileName);
                this.fs.delete(path, false);
            }
        }
        catch (IOException e) {
            throw new HoodieException("Error while deleting the MERGE and REPLACE base file due to task retry: " + lastDataFileName, (Throwable)e);
        }
    }

    protected void createMarkerFile(String partitionPath, String dataFileName) {
        WriteMarkers writeMarkers = WriteMarkersFactory.get((MarkerType)this.config.getMarkersType(), (HoodieTable)this.hoodieTable, (String)this.instantTime);
        writeMarkers.createIfNotExists(partitionPath, dataFileName, this.getIOType());
    }

    protected void makeOldAndNewFilePaths(String partitionPath, String oldFileName, String newFileName) {
        if (!FSUtils.getCommitTime((String)oldFileName).equals(this.instantTime)) {
            LOG.warn("MERGE and REPLACE handle expect the same name for old and new files,\nwhile got new file: " + newFileName + " with old file: " + oldFileName + ",\nthis rarely happens when the checkpoint success event was not received yet\nbut the write task flush with new instant time, which does not break the UPSERT semantics");
            this.shouldReplace = false;
        }
        super.makeOldAndNewFilePaths(partitionPath, oldFileName, newFileName);
        try {
            int rollNumber = 0;
            while (this.fs.exists(this.newFilePath)) {
                Path oldPath = this.newFilePath;
                newFileName = this.newFileNameWithRollover(rollNumber++);
                this.newFilePath = this.makeNewFilePath(partitionPath, newFileName);
                LOG.warn("Duplicate write for MERGE and REPLACE handle with path: " + oldPath + ", rolls over to new path: " + this.newFilePath);
            }
        }
        catch (IOException e) {
            throw new HoodieException("Checking existing path for merge and replace handle error: " + this.newFilePath, (Throwable)e);
        }
    }

    protected String newFileNameWithRollover(int rollNumber) {
        return FSUtils.makeBaseFileName((String)this.instantTime, (String)(this.writeToken + "-" + rollNumber), (String)this.fileId, (String)this.hoodieTable.getBaseFileExtension());
    }

    protected void setWriteStatusPath() {
        this.writeStatus.getStat().setPath(new Path(this.config.getBasePath()), this.oldFilePath);
    }

    boolean needsUpdateLocation() {
        return false;
    }

    @Override
    public void finalizeWrite() {
        if (!this.shouldReplace) {
            return;
        }
        try {
            this.fs.delete(this.oldFilePath, false);
        }
        catch (IOException e) {
            throw new HoodieIOException("Error while cleaning the old base file: " + this.oldFilePath, e);
        }
        try {
            this.fs.rename(this.newFilePath, this.oldFilePath);
        }
        catch (IOException e) {
            throw new HoodieIOException("Error while renaming the temporary rollover file: " + this.newFilePath + " to old base file name: " + this.oldFilePath, e);
        }
    }

    public List<WriteStatus> close() {
        try {
            List writeStatuses = super.close();
            this.finalizeWrite();
            List list = writeStatuses;
            return list;
        }
        finally {
            this.isClosed = true;
        }
    }

    @Override
    public void closeGracefully() {
        if (this.isClosed) {
            return;
        }
        try {
            this.close();
        }
        catch (Throwable throwable) {
            LOG.warn("Error while trying to dispose the MERGE handle", throwable);
            try {
                this.fs.delete(this.newFilePath, false);
                LOG.info("Deleting the intermediate MERGE and REPLACE data file: " + this.newFilePath + " success!");
            }
            catch (IOException e) {
                LOG.warn("Deleting the intermediate MERGE and REPLACE data file: " + this.newFilePath + " failed", (Throwable)e);
            }
        }
    }

    @Override
    public Path getWritePath() {
        return this.oldFilePath;
    }
}

