/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.model.HoodieDeltaWriteStat;
import org.apache.hudi.common.model.HoodieWriteStat;

public class WriteStatMerger {
    public static HoodieWriteStat merge(HoodieWriteStat stat1, HoodieWriteStat stat2) {
        if (stat1 instanceof HoodieDeltaWriteStat) {
            return WriteStatMerger.mergeDeltaWriteStat((HoodieDeltaWriteStat)stat1, (HoodieDeltaWriteStat)stat2);
        }
        return WriteStatMerger.mergeWriteStat(new HoodieWriteStat(), stat1, stat2);
    }

    private static HoodieDeltaWriteStat mergeDeltaWriteStat(HoodieDeltaWriteStat stat1, HoodieDeltaWriteStat stat2) {
        HoodieDeltaWriteStat merged = new HoodieDeltaWriteStat();
        WriteStatMerger.mergeWriteStat((HoodieWriteStat)merged, (HoodieWriteStat)stat1, (HoodieWriteStat)stat2);
        merged.setLogVersion(stat2.getLogVersion());
        merged.setLogOffset(stat2.getLogOffset());
        merged.setBaseFile(stat2.getBaseFile());
        ArrayList<String> mergedLogFiles = new ArrayList<String>(stat1.getLogFiles());
        for (String logFile : stat2.getLogFiles()) {
            if (mergedLogFiles.contains(logFile)) continue;
            mergedLogFiles.add(logFile);
        }
        merged.setLogFiles(mergedLogFiles);
        if (stat1.getColumnStats().isPresent()) {
            merged.putRecordsStats((Map)stat1.getColumnStats().get());
        }
        if (stat2.getColumnStats().isPresent()) {
            merged.putRecordsStats((Map)stat2.getColumnStats().get());
        }
        return merged;
    }

    private static HoodieWriteStat mergeWriteStat(HoodieWriteStat merged, HoodieWriteStat stat1, HoodieWriteStat stat2) {
        merged.setFileId(stat2.getFileId());
        merged.setPath(stat2.getPath());
        merged.setCdcStats(WriteStatMerger.getMergedCdcStats(stat1.getCdcStats(), stat2.getCdcStats()));
        merged.setPrevCommit(stat2.getPrevCommit());
        merged.setNumWrites(stat2.getNumWrites() + stat1.getNumWrites());
        merged.setNumDeletes(stat2.getNumDeletes() + stat1.getNumDeletes());
        merged.setNumUpdateWrites(stat2.getNumUpdateWrites() + stat1.getNumUpdateWrites());
        merged.setNumInserts(stat2.getNumInserts() + stat1.getNumInserts());
        merged.setTotalWriteBytes(stat2.getTotalWriteBytes() + stat1.getTotalWriteBytes());
        merged.setTotalWriteErrors(stat2.getTotalWriteErrors() + stat1.getTotalWriteErrors());
        merged.setTempPath(stat2.getTempPath());
        merged.setPartitionPath(stat2.getPartitionPath());
        merged.setRuntimeStats(WriteStatMerger.getMergedRuntimeStats(stat1.getRuntimeStats(), stat2.getRuntimeStats()));
        merged.setTotalLogRecords(stat2.getTotalLogRecords() + stat1.getTotalLogRecords());
        merged.setTotalLogFilesCompacted(stat2.getTotalLogFilesCompacted() + stat1.getTotalLogFilesCompacted());
        merged.setTotalLogSizeCompacted(stat2.getTotalLogSizeCompacted() + stat1.getTotalLogSizeCompacted());
        merged.setTotalUpdatedRecordsCompacted(stat2.getTotalUpdatedRecordsCompacted() + stat1.getTotalUpdatedRecordsCompacted());
        merged.setTotalLogBlocks(stat2.getTotalLogBlocks() + stat1.getTotalLogBlocks());
        merged.setTotalCorruptLogBlock(stat2.getTotalCorruptLogBlock() + stat1.getTotalCorruptLogBlock());
        merged.setTotalRollbackBlocks(stat2.getTotalRollbackBlocks() + stat1.getTotalRollbackBlocks());
        merged.setFileSizeInBytes(stat2.getFileSizeInBytes() + stat1.getFileSizeInBytes());
        merged.setMinEventTime(WriteStatMerger.minLong(stat1.getMinEventTime(), stat2.getMinEventTime()));
        merged.setMaxEventTime(WriteStatMerger.maxLong(stat1.getMaxEventTime(), stat2.getMaxEventTime()));
        return stat2;
    }

    private static HoodieWriteStat.RuntimeStats getMergedRuntimeStats(HoodieWriteStat.RuntimeStats runtimeStats1, HoodieWriteStat.RuntimeStats runtimeStats2) {
        HoodieWriteStat.RuntimeStats runtimeStats;
        if (runtimeStats1 != null && runtimeStats2 != null) {
            runtimeStats = new HoodieWriteStat.RuntimeStats();
            runtimeStats.setTotalScanTime(runtimeStats1.getTotalScanTime() + runtimeStats2.getTotalScanTime());
            runtimeStats.setTotalUpsertTime(runtimeStats1.getTotalUpsertTime() + runtimeStats2.getTotalUpsertTime());
            runtimeStats.setTotalCreateTime(runtimeStats1.getTotalCreateTime() + runtimeStats2.getTotalCreateTime());
        } else {
            runtimeStats = runtimeStats1 == null ? runtimeStats2 : runtimeStats1;
        }
        return runtimeStats;
    }

    private static Map<String, Long> getMergedCdcStats(Map<String, Long> cdcStats1, Map<String, Long> cdcStats2) {
        Map<String, Long> cdcStats;
        if (cdcStats1 != null && cdcStats2 != null) {
            cdcStats = new HashMap<String, Long>();
            cdcStats.putAll(cdcStats1);
            cdcStats.putAll(cdcStats2);
        } else {
            cdcStats = cdcStats1 == null ? cdcStats2 : cdcStats1;
        }
        return cdcStats;
    }

    private static Long minLong(Long v1, Long v2) {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        return v1.compareTo(v2) < 0 ? v1 : v2;
    }

    private static Long maxLong(Long v1, Long v2) {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        return v1.compareTo(v2) > 0 ? v1 : v2;
    }
}

