/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.plan.strategy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.cluster.strategy.PartitionAwareClusteringPlanStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkSizeBasedClusteringPlanStrategy<T>
extends PartitionAwareClusteringPlanStrategy<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkSizeBasedClusteringPlanStrategy.class);

    public FlinkSizeBasedClusteringPlanStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    protected Stream<HoodieClusteringGroup> buildClusteringGroupsForPartition(String partitionPath, List<FileSlice> fileSlices) {
        return super.buildClusteringGroupsForPartition(partitionPath, fileSlices);
    }

    protected Map<String, String> getStrategyParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!StringUtils.isNullOrEmpty((String)this.getWriteConfig().getClusteringSortColumns())) {
            params.put(HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key(), this.getWriteConfig().getClusteringSortColumns());
        }
        return params;
    }

    protected Stream<FileSlice> getFileSlicesEligibleForClustering(String partition) {
        return super.getFileSlicesEligibleForClustering(partition).filter(slice -> (Long)slice.getBaseFile().map(BaseFile::getFileSize).orElse((Object)0L) < this.getWriteConfig().getClusteringSmallFileLimit());
    }
}

