/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.data.HoodieListPairData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bloom.BaseHoodieBloomIndexHelper;
import org.apache.hudi.index.bloom.BloomIndexFileInfo;
import org.apache.hudi.index.bloom.HoodieBloomIndex;
import org.apache.hudi.index.bloom.ListBasedHoodieBloomIndexHelper;
import org.apache.hudi.table.HoodieFlinkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.HoodieFlinkClientTestHarness;
import org.apache.hudi.testutils.HoodieFlinkWriteableTestTable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestFlinkHoodieBloomIndex
extends HoodieFlinkClientTestHarness {
    private static final Schema SCHEMA = SchemaTestUtil.getSchemaFromResource(TestFlinkHoodieBloomIndex.class, (String)"/exampleSchema.avsc", (boolean)true);
    private static final String TEST_NAME_WITH_PARAMS = "[{index}] Test with rangePruning={0}, treeFiltering={1}, bucketizedChecking={2}";

    public static Stream<Arguments> configParams() {
        Object[][] data = new Object[][]{{true, true, true}, {false, true, true}, {true, true, false}, {true, false, true}};
        return Stream.of(data).map(Arguments::of);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.initPath();
        this.initFileSystem();
        this.initMetaClient();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanupResources();
    }

    private HoodieWriteConfig makeConfig(boolean rangePruning, boolean treeFiltering, boolean bucketizedChecking) {
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withEngineType(EngineType.FLINK).withIndexConfig(HoodieIndexConfig.newBuilder().bloomIndexPruneByRanges(rangePruning).bloomIndexTreebasedFilter(treeFiltering).bloomIndexBucketizedChecking(bucketizedChecking).bloomIndexKeysPerBucket(2).build()).build();
    }

    @ParameterizedTest(name="[{index}] Test with rangePruning={0}, treeFiltering={1}, bucketizedChecking={2}")
    @MethodSource(value={"configParams"})
    public void testLoadInvolvedFiles(boolean rangePruning, boolean treeFiltering, boolean bucketizedChecking) throws Exception {
        HoodieWriteConfig config = this.makeConfig(rangePruning, treeFiltering, bucketizedChecking);
        HoodieBloomIndex index = new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)ListBasedHoodieBloomIndexHelper.getInstance());
        HoodieFlinkTable hoodieTable = HoodieFlinkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieFlinkWriteableTestTable testTable = HoodieFlinkWriteableTestTable.of((HoodieTable)hoodieTable, SCHEMA);
        testTable.withPartitionMetaFiles(new String[]{"2016/01/21", "2016/04/01", "2015/03/12"});
        RawTripTestPayload rowChange1 = new RawTripTestPayload("{\"_row_key\":\"000\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record1 = new HoodieAvroRecord(new HoodieKey(rowChange1.getRowKey(), rowChange1.getPartitionPath()), (HoodieRecordPayload)rowChange1);
        RawTripTestPayload rowChange2 = new RawTripTestPayload("{\"_row_key\":\"001\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record2 = new HoodieAvroRecord(new HoodieKey(rowChange2.getRowKey(), rowChange2.getPartitionPath()), (HoodieRecordPayload)rowChange2);
        RawTripTestPayload rowChange3 = new RawTripTestPayload("{\"_row_key\":\"002\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record3 = new HoodieAvroRecord(new HoodieKey(rowChange3.getRowKey(), rowChange3.getPartitionPath()), (HoodieRecordPayload)rowChange3);
        RawTripTestPayload rowChange4 = new RawTripTestPayload("{\"_row_key\":\"003\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record4 = new HoodieAvroRecord(new HoodieKey(rowChange4.getRowKey(), rowChange4.getPartitionPath()), (HoodieRecordPayload)rowChange4);
        List<String> partitions = Arrays.asList("2016/01/21", "2016/04/01", "2015/03/12");
        List filesList = index.loadColumnRangesFromFiles(partitions, (HoodieEngineContext)this.context, (HoodieTable)hoodieTable);
        Assertions.assertEquals((int)0, (int)filesList.size());
        testTable.addCommit("20160401010101").withInserts("2016/04/01", "2");
        testTable.addCommit("20150312101010").withInserts("2015/03/12", "1").withInserts("2015/03/12", "3", new HoodieRecord[]{record1}).withInserts("2015/03/12", "4", new HoodieRecord[]{record2, record3, record4});
        this.metaClient.reloadActiveTimeline();
        filesList = index.loadColumnRangesFromFiles(partitions, (HoodieEngineContext)this.context, (HoodieTable)hoodieTable);
        Assertions.assertEquals((int)4, (int)filesList.size());
        if (rangePruning) {
            Assertions.assertNull((Object)((BloomIndexFileInfo)((Pair)filesList.get(0)).getRight()).getMaxRecordKey());
            Assertions.assertNull((Object)((BloomIndexFileInfo)((Pair)filesList.get(0)).getRight()).getMinRecordKey());
            Assertions.assertFalse((boolean)((BloomIndexFileInfo)((Pair)filesList.get(1)).getRight()).hasKeyRanges());
            Assertions.assertNotNull((Object)((BloomIndexFileInfo)((Pair)filesList.get(2)).getRight()).getMaxRecordKey());
            Assertions.assertNotNull((Object)((BloomIndexFileInfo)((Pair)filesList.get(2)).getRight()).getMinRecordKey());
            Assertions.assertTrue((boolean)((BloomIndexFileInfo)((Pair)filesList.get(3)).getRight()).hasKeyRanges());
            List<Pair> expected = Arrays.asList(Pair.of((Object)"2016/04/01", (Object)new BloomIndexFileInfo("2")), Pair.of((Object)"2015/03/12", (Object)new BloomIndexFileInfo("1")), Pair.of((Object)"2015/03/12", (Object)new BloomIndexFileInfo("3", "000", "000")), Pair.of((Object)"2015/03/12", (Object)new BloomIndexFileInfo("4", "001", "003")));
            Assertions.assertEquals(expected, (Object)filesList);
        }
    }

    @ParameterizedTest(name="[{index}] Test with rangePruning={0}, treeFiltering={1}, bucketizedChecking={2}")
    @MethodSource(value={"configParams"})
    public void testRangePruning(boolean rangePruning, boolean treeFiltering, boolean bucketizedChecking) {
        HoodieWriteConfig config = this.makeConfig(rangePruning, treeFiltering, bucketizedChecking);
        HoodieBloomIndex index = new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)ListBasedHoodieBloomIndexHelper.getInstance());
        HashMap<String, List<BloomIndexFileInfo>> partitionToFileIndexInfo = new HashMap<String, List<BloomIndexFileInfo>>();
        partitionToFileIndexInfo.put("2017/10/22", Arrays.asList(new BloomIndexFileInfo("f1"), new BloomIndexFileInfo("f2", "000", "000"), new BloomIndexFileInfo("f3", "001", "003"), new BloomIndexFileInfo("f4", "002", "007"), new BloomIndexFileInfo("f5", "009", "010")));
        HashMap partitionRecordKeyMap = new HashMap();
        Arrays.asList(Pair.of((Object)"2017/10/22", (Object)"003"), Pair.of((Object)"2017/10/22", (Object)"002"), Pair.of((Object)"2017/10/22", (Object)"005"), Pair.of((Object)"2017/10/22", (Object)"004")).forEach(t -> {
            List recordKeyList = partitionRecordKeyMap.getOrDefault(t.getLeft(), new ArrayList());
            recordKeyList.add(t.getRight());
            partitionRecordKeyMap.put(t.getLeft(), recordKeyList);
        });
        List comparisonKeyList = index.explodeRecordsWithFileComparisons(partitionToFileIndexInfo, (HoodiePairData)HoodieListPairData.lazy(partitionRecordKeyMap)).collectAsList();
        Assertions.assertEquals((int)10, (int)comparisonKeyList.size());
        Map recordKeyToFileComps = comparisonKeyList.stream().collect(Collectors.groupingBy(t -> (String)t.getRight(), Collectors.mapping(t -> ((HoodieFileGroupId)t.getLeft()).getFileId(), Collectors.toList())));
        Assertions.assertEquals((int)4, (int)recordKeyToFileComps.size());
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("f1", "f3", "f4")), new HashSet(recordKeyToFileComps.get("002")));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("f1", "f3", "f4")), new HashSet(recordKeyToFileComps.get("003")));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("f1", "f4")), new HashSet(recordKeyToFileComps.get("004")));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("f1", "f4")), new HashSet(recordKeyToFileComps.get("005")));
    }

    @Test
    public void testCheckUUIDsAgainstOneFile() throws Exception {
        String partition = "2016/01/31";
        String recordStr1 = "{\"_row_key\":\"1eb5b87a-1feh-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}";
        String recordStr2 = "{\"_row_key\":\"2eb5b87b-1feu-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:20:41.415Z\",\"number\":100}";
        String recordStr3 = "{\"_row_key\":\"3eb5b87c-1fej-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":15}";
        String recordStr4 = "{\"_row_key\":\"4eb5b87c-1fej-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":32}";
        RawTripTestPayload rowChange1 = new RawTripTestPayload(recordStr1);
        HoodieAvroRecord record1 = new HoodieAvroRecord(new HoodieKey(rowChange1.getRowKey(), rowChange1.getPartitionPath()), (HoodieRecordPayload)rowChange1);
        RawTripTestPayload rowChange2 = new RawTripTestPayload(recordStr2);
        HoodieAvroRecord record2 = new HoodieAvroRecord(new HoodieKey(rowChange2.getRowKey(), rowChange2.getPartitionPath()), (HoodieRecordPayload)rowChange2);
        RawTripTestPayload rowChange3 = new RawTripTestPayload(recordStr3);
        HoodieAvroRecord record3 = new HoodieAvroRecord(new HoodieKey(rowChange3.getRowKey(), rowChange3.getPartitionPath()), (HoodieRecordPayload)rowChange3);
        RawTripTestPayload rowChange4 = new RawTripTestPayload(recordStr4);
        HoodieAvroRecord record4 = new HoodieAvroRecord(new HoodieKey(rowChange4.getRowKey(), rowChange4.getPartitionPath()), (HoodieRecordPayload)rowChange4);
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)10000, (double)1.0E-7, (int)-1, (String)BloomFilterTypeCode.SIMPLE.name());
        filter.add(record3.getRecordKey());
        HoodieFlinkWriteableTestTable testTable = HoodieFlinkWriteableTestTable.of(this.metaClient, SCHEMA, filter);
        String fileId = testTable.addCommit("000").getFileIdWithInserts("2016/01/31", new HoodieRecord[]{record1, record2});
        String filename = testTable.getBaseFileNameById(fileId);
        Assertions.assertTrue((boolean)filter.mightContain(record1.getRecordKey()));
        Assertions.assertTrue((boolean)filter.mightContain(record2.getRecordKey()));
        Assertions.assertTrue((boolean)filter.mightContain(record3.getRecordKey()));
        Assertions.assertFalse((boolean)filter.mightContain(record4.getRecordKey()));
        List<String> uuids = Arrays.asList(record1.getRecordKey(), record2.getRecordKey(), record3.getRecordKey(), record4.getRecordKey());
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).build();
        List results = HoodieIndexUtils.filterKeysFromFile((Path)new Path(Paths.get(this.basePath, "2016/01/31", filename).toString()), uuids, (Configuration)this.hadoopConf);
        Assertions.assertEquals((int)results.size(), (int)2);
        Assertions.assertTrue((((String)((Pair)results.get(0)).getLeft()).equals("1eb5b87a-1feh-4edd-87b4-6ec96dc405a0") || ((String)((Pair)results.get(1)).getLeft()).equals("1eb5b87a-1feh-4edd-87b4-6ec96dc405a0") ? 1 : 0) != 0);
        Assertions.assertTrue((((String)((Pair)results.get(0)).getLeft()).equals("2eb5b87b-1feu-4edd-87b4-6ec96dc405a0") || ((String)((Pair)results.get(1)).getLeft()).equals("2eb5b87b-1feu-4edd-87b4-6ec96dc405a0") ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="[{index}] Test with rangePruning={0}, treeFiltering={1}, bucketizedChecking={2}")
    @MethodSource(value={"configParams"})
    public void testTagLocationWithEmptyList(boolean rangePruning, boolean treeFiltering, boolean bucketizedChecking) {
        ArrayList records = new ArrayList();
        HoodieWriteConfig config = this.makeConfig(rangePruning, treeFiltering, bucketizedChecking);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieFlinkTable table = HoodieFlinkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieBloomIndex bloomIndex = new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)ListBasedHoodieBloomIndexHelper.getInstance());
        Assertions.assertDoesNotThrow(() -> this.tagLocation((HoodieIndex)bloomIndex, records, (HoodieTable)table), (String)"EmptyList should not result in IllegalArgumentException: Positive number of slices required");
    }

    @ParameterizedTest(name="[{index}] Test with rangePruning={0}, treeFiltering={1}, bucketizedChecking={2}")
    @MethodSource(value={"configParams"})
    public void testTagLocation(boolean rangePruning, boolean treeFiltering, boolean bucketizedChecking) throws Exception {
        String rowKey1 = UUID.randomUUID().toString();
        String rowKey2 = UUID.randomUUID().toString();
        String rowKey3 = UUID.randomUUID().toString();
        String recordStr1 = "{\"_row_key\":\"" + rowKey1 + "\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}";
        String recordStr2 = "{\"_row_key\":\"" + rowKey2 + "\",\"time\":\"2016-01-31T03:20:41.415Z\",\"number\":100}";
        String recordStr3 = "{\"_row_key\":\"" + rowKey3 + "\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":15}";
        String recordStr4 = "{\"_row_key\":\"" + rowKey1 + "\",\"time\":\"2015-01-31T03:16:41.415Z\",\"number\":32}";
        RawTripTestPayload rowChange1 = new RawTripTestPayload(recordStr1);
        HoodieAvroRecord record1 = new HoodieAvroRecord(new HoodieKey(rowChange1.getRowKey(), rowChange1.getPartitionPath()), (HoodieRecordPayload)rowChange1);
        RawTripTestPayload rowChange2 = new RawTripTestPayload(recordStr2);
        HoodieAvroRecord record2 = new HoodieAvroRecord(new HoodieKey(rowChange2.getRowKey(), rowChange2.getPartitionPath()), (HoodieRecordPayload)rowChange2);
        RawTripTestPayload rowChange3 = new RawTripTestPayload(recordStr3);
        HoodieAvroRecord record3 = new HoodieAvroRecord(new HoodieKey(rowChange3.getRowKey(), rowChange3.getPartitionPath()), (HoodieRecordPayload)rowChange3);
        RawTripTestPayload rowChange4 = new RawTripTestPayload(recordStr4);
        HoodieAvroRecord record4 = new HoodieAvroRecord(new HoodieKey(rowChange4.getRowKey(), rowChange4.getPartitionPath()), (HoodieRecordPayload)rowChange4);
        List<HoodieRecord> records = Arrays.asList(record1, record2, record3, record4);
        HoodieWriteConfig config = this.makeConfig(rangePruning, treeFiltering, bucketizedChecking);
        HoodieFlinkTable hoodieTable = HoodieFlinkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieFlinkWriteableTestTable testTable = HoodieFlinkWriteableTestTable.of((HoodieTable)hoodieTable, SCHEMA);
        HoodieBloomIndex bloomIndex = new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)ListBasedHoodieBloomIndexHelper.getInstance());
        List<HoodieRecord> taggedRecords = this.tagLocation((HoodieIndex)bloomIndex, records, (HoodieTable)hoodieTable);
        for (HoodieRecord record : taggedRecords) {
            Assertions.assertFalse((boolean)record.isCurrentLocationKnown());
        }
        String fileId1 = testTable.addCommit("001").getFileIdWithInserts("2016/01/31", new HoodieRecord[]{record1});
        String fileId2 = testTable.addCommit("002").getFileIdWithInserts("2016/01/31", new HoodieRecord[]{record2});
        String fileId3 = testTable.addCommit("003").getFileIdWithInserts("2015/01/31", new HoodieRecord[]{record4});
        this.metaClient.reloadActiveTimeline();
        taggedRecords = this.tagLocation((HoodieIndex)bloomIndex, records, (HoodieTable)HoodieFlinkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient));
        for (HoodieRecord record : taggedRecords) {
            if (record.getRecordKey().equals(rowKey1)) {
                if (record.getPartitionPath().equals("2015/01/31")) {
                    Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)fileId3);
                    continue;
                }
                Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)fileId1);
                continue;
            }
            if (record.getRecordKey().equals(rowKey2)) {
                Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)fileId2);
                continue;
            }
            if (!record.getRecordKey().equals(rowKey3)) continue;
            Assertions.assertFalse((boolean)record.isCurrentLocationKnown());
        }
    }

    @ParameterizedTest(name="[{index}] Test with rangePruning={0}, treeFiltering={1}, bucketizedChecking={2}")
    @MethodSource(value={"configParams"})
    public void testCheckExists(boolean rangePruning, boolean treeFiltering, boolean bucketizedChecking) throws Exception {
        String recordStr1 = "{\"_row_key\":\"1eb5b87a-1feh-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}";
        String recordStr2 = "{\"_row_key\":\"2eb5b87b-1feu-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:20:41.415Z\",\"number\":100}";
        String recordStr3 = "{\"_row_key\":\"3eb5b87c-1fej-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":15}";
        String recordStr4 = "{\"_row_key\":\"2eb5b87b-1feu-4edd-87b4-6ec96dc405a0\",\"time\":\"2015-01-31T03:16:41.415Z\",\"number\":32}";
        RawTripTestPayload rowChange1 = new RawTripTestPayload(recordStr1);
        HoodieKey key1 = new HoodieKey(rowChange1.getRowKey(), rowChange1.getPartitionPath());
        HoodieAvroRecord record1 = new HoodieAvroRecord(key1, (HoodieRecordPayload)rowChange1);
        RawTripTestPayload rowChange2 = new RawTripTestPayload(recordStr2);
        HoodieKey key2 = new HoodieKey(rowChange2.getRowKey(), rowChange2.getPartitionPath());
        HoodieAvroRecord record2 = new HoodieAvroRecord(key2, (HoodieRecordPayload)rowChange2);
        RawTripTestPayload rowChange3 = new RawTripTestPayload(recordStr3);
        HoodieKey key3 = new HoodieKey(rowChange3.getRowKey(), rowChange3.getPartitionPath());
        RawTripTestPayload rowChange4 = new RawTripTestPayload(recordStr4);
        HoodieKey key4 = new HoodieKey(rowChange4.getRowKey(), rowChange4.getPartitionPath());
        HoodieAvroRecord record4 = new HoodieAvroRecord(key4, (HoodieRecordPayload)rowChange4);
        List<HoodieKey> keys = Arrays.asList(key1, key2, key3, key4);
        HoodieWriteConfig config = this.makeConfig(rangePruning, treeFiltering, bucketizedChecking);
        HoodieFlinkTable hoodieTable = HoodieFlinkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieFlinkWriteableTestTable testTable = HoodieFlinkWriteableTestTable.of((HoodieTable)hoodieTable, SCHEMA);
        HoodieBloomIndex bloomIndex = new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)ListBasedHoodieBloomIndexHelper.getInstance());
        ArrayList<HoodieRecord> toTagRecords = new ArrayList<HoodieRecord>();
        toTagRecords.add((HoodieRecord)new HoodieAvroRecord(record4.getKey(), null));
        List<HoodieRecord> taggedRecords = this.tagLocation((HoodieIndex)bloomIndex, toTagRecords, (HoodieTable)hoodieTable);
        HashMap<HoodieKey, Option> recordLocations = new HashMap<HoodieKey, Option>();
        for (HoodieRecord taggedRecord : taggedRecords) {
            recordLocations.put(taggedRecord.getKey(), taggedRecord.isCurrentLocationKnown() ? Option.of((Object)Pair.of((Object)taggedRecord.getPartitionPath(), (Object)taggedRecord.getCurrentLocation().getFileId())) : Option.empty());
        }
        for (Option record : recordLocations.values()) {
            Assertions.assertTrue((!record.isPresent() ? 1 : 0) != 0);
        }
        String fileId1 = testTable.addCommit("001").getFileIdWithInserts("2016/01/31", new HoodieRecord[]{record1});
        String fileId2 = testTable.addCommit("002").getFileIdWithInserts("2016/01/31", new HoodieRecord[]{record2});
        String fileId3 = testTable.addCommit("003").getFileIdWithInserts("2015/01/31", new HoodieRecord[]{record4});
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        hoodieTable = HoodieFlinkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        ArrayList<HoodieRecord> toTagRecords1 = new ArrayList<HoodieRecord>();
        for (HoodieKey hoodieKey : keys) {
            taggedRecords.add((HoodieRecord)new HoodieAvroRecord(hoodieKey, null));
        }
        taggedRecords = this.tagLocation((HoodieIndex)bloomIndex, toTagRecords1, (HoodieTable)hoodieTable);
        recordLocations.clear();
        for (HoodieRecord hoodieRecord : taggedRecords) {
            recordLocations.put(hoodieRecord.getKey(), hoodieRecord.isCurrentLocationKnown() ? Option.of((Object)Pair.of((Object)hoodieRecord.getPartitionPath(), (Object)hoodieRecord.getCurrentLocation().getFileId())) : Option.empty());
        }
        for (Map.Entry entry : recordLocations.entrySet()) {
            if (((HoodieKey)entry.getKey()).getRecordKey().equals("1eb5b87a-1feh-4edd-87b4-6ec96dc405a0")) {
                Assertions.assertTrue((boolean)((Option)entry.getValue()).isPresent());
                Assertions.assertEquals((Object)fileId1, (Object)((Pair)((Option)entry.getValue()).get()).getRight());
                continue;
            }
            if (((HoodieKey)entry.getKey()).getRecordKey().equals("2eb5b87b-1feu-4edd-87b4-6ec96dc405a0")) {
                Assertions.assertTrue((boolean)((Option)entry.getValue()).isPresent());
                if (((HoodieKey)entry.getKey()).getPartitionPath().equals("2015/01/31")) {
                    Assertions.assertEquals((Object)fileId3, (Object)((Pair)((Option)entry.getValue()).get()).getRight());
                    continue;
                }
                Assertions.assertEquals((Object)fileId2, (Object)((Pair)((Option)entry.getValue()).get()).getRight());
                continue;
            }
            if (!((HoodieKey)entry.getKey()).getRecordKey().equals("3eb5b87c-1fej-4edd-87b4-6ec96dc405a0")) continue;
            Assertions.assertFalse((boolean)((Option)entry.getValue()).isPresent());
        }
    }

    @ParameterizedTest(name="[{index}] Test with rangePruning={0}, treeFiltering={1}, bucketizedChecking={2}")
    @MethodSource(value={"configParams"})
    public void testBloomFilterFalseError(boolean rangePruning, boolean treeFiltering, boolean bucketizedChecking) throws Exception {
        String recordStr1 = "{\"_row_key\":\"1eb5b87a-1feh-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}";
        String recordStr2 = "{\"_row_key\":\"2eb5b87b-1feu-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:20:41.415Z\",\"number\":100}";
        RawTripTestPayload rowChange1 = new RawTripTestPayload(recordStr1);
        HoodieAvroRecord record1 = new HoodieAvroRecord(new HoodieKey(rowChange1.getRowKey(), rowChange1.getPartitionPath()), (HoodieRecordPayload)rowChange1);
        RawTripTestPayload rowChange2 = new RawTripTestPayload(recordStr2);
        HoodieAvroRecord record2 = new HoodieAvroRecord(new HoodieKey(rowChange2.getRowKey(), rowChange2.getPartitionPath()), (HoodieRecordPayload)rowChange2);
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)10000, (double)1.0E-7, (int)-1, (String)BloomFilterTypeCode.SIMPLE.name());
        filter.add(record2.getRecordKey());
        HoodieFlinkWriteableTestTable testTable = HoodieFlinkWriteableTestTable.of(this.metaClient, SCHEMA, filter);
        String fileId = testTable.addCommit("000").getFileIdWithInserts("2016/01/31", new HoodieRecord[]{record1});
        Assertions.assertTrue((boolean)filter.mightContain(record1.getRecordKey()));
        Assertions.assertTrue((boolean)filter.mightContain(record2.getRecordKey()));
        List<HoodieRecord> records = Arrays.asList(record1, record2);
        HoodieWriteConfig config = this.makeConfig(rangePruning, treeFiltering, bucketizedChecking);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieFlinkTable table = HoodieFlinkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieBloomIndex bloomIndex = new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)ListBasedHoodieBloomIndexHelper.getInstance());
        List<HoodieRecord> taggedRecords = this.tagLocation((HoodieIndex)bloomIndex, records, (HoodieTable)table);
        for (HoodieRecord record : taggedRecords) {
            if (record.getKey().equals((Object)"1eb5b87a-1feh-4edd-87b4-6ec96dc405a0")) {
                Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)fileId);
                continue;
            }
            if (!record.getRecordKey().equals("2eb5b87b-1feu-4edd-87b4-6ec96dc405a0")) continue;
            Assertions.assertFalse((boolean)record.isCurrentLocationKnown());
        }
    }
}

