/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster.strategy;

import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.hudi.client.clustering.plan.strategy.FlinkSizeBasedClusteringPlanStrategy;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieFlinkCopyOnWriteTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.cluster.ClusteringPlanPartitionFilterMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;

public class TestFlinkSizeBasedClusteringPlanStrategy {
    @Mock
    HoodieFlinkCopyOnWriteTable table;
    @Mock
    HoodieFlinkEngineContext context;
    HoodieWriteConfig.Builder hoodieWriteConfigBuilder;

    @BeforeEach
    public void setUp() {
        this.hoodieWriteConfigBuilder = HoodieWriteConfig.newBuilder().withPath("path1");
    }

    @Test
    public void testBuildClusteringGroupsForPartitionOnlyOneFile() {
        String partition = "20221117";
        String fileId = "fg-1";
        ArrayList<FileSlice> fileSliceGroups = new ArrayList<FileSlice>();
        fileSliceGroups.add(this.generateFileSlice(partition, fileId, "0"));
        HoodieWriteConfig configWithSortEnabled = this.hoodieWriteConfigBuilder.withClusteringConfig(HoodieClusteringConfig.newBuilder().withClusteringPlanPartitionFilterMode(ClusteringPlanPartitionFilterMode.NONE).withSingleGroupClusteringEnabled(Boolean.valueOf(false)).withClusteringSortColumns("f0").build()).build();
        FlinkSizeBasedClusteringPlanStrategy strategyWithSortEnabled = new FlinkSizeBasedClusteringPlanStrategy((HoodieTable)this.table, (HoodieEngineContext)this.context, configWithSortEnabled);
        Stream groupStreamSort = strategyWithSortEnabled.buildClusteringGroupsForPartition(partition, fileSliceGroups);
        Assertions.assertEquals((long)1L, (long)groupStreamSort.count());
        HoodieWriteConfig configWithSortDisabled = this.hoodieWriteConfigBuilder.withClusteringConfig(HoodieClusteringConfig.newBuilder().withClusteringPlanPartitionFilterMode(ClusteringPlanPartitionFilterMode.NONE).withSingleGroupClusteringEnabled(Boolean.valueOf(false)).withClusteringSortColumns("").build()).build();
        FlinkSizeBasedClusteringPlanStrategy strategyWithSortDisabled = new FlinkSizeBasedClusteringPlanStrategy((HoodieTable)this.table, (HoodieEngineContext)this.context, configWithSortDisabled);
        Stream groupStreamWithOutSort = strategyWithSortDisabled.buildClusteringGroupsForPartition(partition, fileSliceGroups);
        Assertions.assertEquals((long)0L, (long)groupStreamWithOutSort.count());
    }

    private FileSlice generateFileSlice(String partitionPath, String fileId, String baseInstant) {
        FileSlice fs = new FileSlice(new HoodieFileGroupId(partitionPath, fileId), baseInstant);
        fs.setBaseFile(new HoodieBaseFile(FSUtils.makeBaseFileName((String)baseInstant, (String)"1-0-1", (String)fileId)));
        return fs;
    }
}

