/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.util.Iterator;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieAppendHandle;
import org.apache.hudi.io.MiniBatchHandle;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkAppendHandle<T, I, K, O>
extends HoodieAppendHandle<T, I, K, O>
implements MiniBatchHandle {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkAppendHandle.class);
    private boolean isClosed = false;
    private final WriteMarkers writeMarkers;

    public FlinkAppendHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, Iterator<HoodieRecord<T>> recordItr, TaskContextSupplier taskContextSupplier) {
        super(config, instantTime, hoodieTable, partitionPath, fileId, recordItr, taskContextSupplier);
        this.writeMarkers = WriteMarkersFactory.get((MarkerType)config.getMarkersType(), hoodieTable, (String)instantTime);
    }

    protected void createMarkerFile(String partitionPath, String dataFileName) {
        this.writeMarkers.createIfNotExists(partitionPath, dataFileName, this.getIOType());
    }

    public boolean canWrite(HoodieRecord record) {
        return true;
    }

    protected boolean needsUpdateLocation() {
        return false;
    }

    protected boolean isUpdateRecord(HoodieRecord<T> hoodieRecord) {
        return hoodieRecord.getCurrentLocation() != null && hoodieRecord.getCurrentLocation().getInstantTime().equals("U");
    }

    public List<WriteStatus> close() {
        try {
            List list = super.close();
            return list;
        }
        finally {
            this.isClosed = true;
        }
    }

    @Override
    public void closeGracefully() {
        if (this.isClosed) {
            return;
        }
        try {
            this.close();
        }
        catch (Throwable throwable) {
            LOG.warn("Error while trying to dispose the APPEND handle", throwable);
        }
    }

    @Override
    public StoragePath getWritePath() {
        return this.writer.getLogFile().getPath();
    }
}

