/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.io.FlinkMergeHandle;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkConcatHandle<T, I, K, O>
extends FlinkMergeHandle<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkConcatHandle.class);
    private final Iterator<HoodieRecord<T>> recordItr;

    public FlinkConcatHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier) {
        super(config, instantTime, hoodieTable, Collections.emptyIterator(), partitionPath, fileId, taskContextSupplier);
        this.recordItr = recordItr;
    }

    public void write(HoodieRecord oldRecord) {
        Schema oldSchema = this.config.populateMetaFields() ? this.writeSchemaWithMetaFields : this.writeSchema;
        String key = oldRecord.getRecordKey(oldSchema, this.keyGeneratorOpt);
        try {
            this.fileWriter.write(key, oldRecord, oldSchema);
        }
        catch (IOException | RuntimeException e) {
            String errMsg = String.format("Failed to write old record into new file for key %s from old file %s to new file %s with writerSchema %s", key, this.getOldFilePath(), this.newFilePath, oldSchema.toString(true));
            LOG.debug("Old record is " + oldRecord);
            throw new HoodieUpsertException(errMsg, (Throwable)e);
        }
        ++this.recordsWritten;
    }

    protected void writeIncomingRecords() throws IOException {
        while (this.recordItr.hasNext()) {
            HoodieRecord<T> record = this.recordItr.next();
            this.writeInsertRecord(record);
        }
    }
}

