/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.IOException;
import org.apache.hudi.client.HoodieFlinkWriteClient;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.HoodieFlinkClientTestHarness;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestFlinkWriteClient
extends HoodieFlinkClientTestHarness {
    @BeforeEach
    private void setup() throws IOException {
        this.initPath();
        this.initFileSystem();
        this.initMetaClient();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testWriteClientAndTableServiceClientWithTimelineServer(boolean enableEmbeddedTimelineServer) throws IOException {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.metaClient.getBasePath()).withEmbeddedTimelineServerEnabled(enableEmbeddedTimelineServer).build();
        HoodieFlinkWriteClient writeClient = new HoodieFlinkWriteClient((HoodieEngineContext)this.context, writeConfig);
        Assertions.assertEquals((Object)writeClient.getTimelineServer(), (Object)writeClient.getTableServiceClient().getTimelineServer());
        if (!enableEmbeddedTimelineServer) {
            Assertions.assertFalse((boolean)writeClient.getTimelineServer().isPresent());
        }
        writeClient.close();
    }
}

