/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hudi.client.FlinkTaskContextSupplier;
import org.apache.hudi.client.HoodieFlinkWriteClient;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieFlinkClientTestHarness
extends HoodieCommonTestHarness {
    protected static final Logger LOG = LoggerFactory.getLogger(HoodieFlinkClientTestHarness.class);
    protected StorageConfiguration<Configuration> storageConf;
    protected FileSystem fs;
    protected HoodieFlinkEngineContext context;
    protected ExecutorService executorService;
    protected HoodieFlinkWriteClient writeClient;
    protected HoodieTableFileSystemView tableView;
    protected final FlinkTaskContextSupplier supplier = new FlinkTaskContextSupplier(null);

    protected void initFileSystem() {
        this.storageConf = HoodieTestUtils.getDefaultStorageConf();
        this.initFileSystemWithConfiguration(this.storageConf);
        this.context = new HoodieFlinkEngineContext((TaskContextSupplier)this.supplier);
    }

    private void initFileSystemWithConfiguration(StorageConfiguration<Configuration> configuration) {
        ValidationUtils.checkState((this.basePath != null ? 1 : 0) != 0);
        this.fs = HadoopFSUtils.getFs((String)this.basePath, configuration);
        if (this.fs instanceof LocalFileSystem) {
            LocalFileSystem lfs = (LocalFileSystem)this.fs;
            lfs.setVerifyChecksum(true);
        }
    }

    protected void initMetaClient() throws IOException {
        this.initMetaClient(this.getTableType());
    }

    protected void initMetaClient(HoodieTableType tableType) throws IOException {
        ValidationUtils.checkState((this.basePath != null ? 1 : 0) != 0);
        this.metaClient = HoodieTestUtils.init(this.storageConf, (String)this.basePath, (HoodieTableType)tableType);
    }

    protected List<HoodieRecord> tagLocation(HoodieIndex index, List<HoodieRecord> records, HoodieTable table) {
        return index.tagLocation((HoodieData)HoodieListData.eager(records), (HoodieEngineContext)this.context, table).collectAsList();
    }

    protected void cleanupFileSystem() throws IOException {
        if (this.fs != null) {
            LOG.warn("Closing file-system instance used in previous test-run");
            this.fs.close();
            this.fs = null;
        }
    }

    public void cleanupResources() throws IOException {
        this.cleanupClients();
        this.cleanupFlinkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
        this.cleanupExecutorService();
        System.gc();
    }

    protected void cleanupClients() {
        if (this.metaClient != null) {
            this.metaClient = null;
        }
        if (this.writeClient != null) {
            this.writeClient.close();
            this.writeClient = null;
        }
        if (this.tableView != null) {
            this.tableView.close();
            this.tableView = null;
        }
    }

    protected void cleanupExecutorService() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    protected void cleanupFlinkContexts() {
        if (this.context != null) {
            LOG.info("Closing flink engine context used in previous test-case");
            this.context = null;
        }
    }

    public static class SimpleTestSinkFunction
    implements SinkFunction<HoodieRecord> {
        public static List<HoodieRecord> valuesList = new ArrayList<HoodieRecord>();

        public synchronized void invoke(HoodieRecord value, SinkFunction.Context context) throws Exception {
            valuesList.add(value);
        }
    }
}

