/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.configuration;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.client.clustering.plan.strategy.FlinkConsistentBucketClusteringPlanStrategy;
import org.apache.hudi.client.transaction.BucketIndexConcurrentFileWritesConflictResolutionStrategy;
import org.apache.hudi.client.transaction.ConflictResolutionStrategy;
import org.apache.hudi.client.transaction.SimpleConcurrentFileWritesConflictResolutionStrategy;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.cdc.HoodieCDCSupplementalLoggingMode;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.sink.overwrite.PartitionOverwriteMode;
import org.apache.hudi.table.format.FilePathUtils;

public class OptionsResolver {
    public static boolean insertClustering(Configuration conf) {
        return OptionsResolver.isCowTable(conf) && OptionsResolver.isInsertOperation(conf) && conf.getBoolean(FlinkOptions.INSERT_CLUSTER);
    }

    public static boolean isAppendMode(Configuration conf) {
        return OptionsResolver.isInsertOperation(conf) && (OptionsResolver.isCowTable(conf) && !conf.getBoolean(FlinkOptions.INSERT_CLUSTER) || OptionsResolver.isMorTable(conf));
    }

    public static boolean isInsertOperation(Configuration conf) {
        WriteOperationType operationType = WriteOperationType.fromValue((String)conf.getString(FlinkOptions.OPERATION));
        return operationType == WriteOperationType.INSERT;
    }

    public static boolean isUpsertOperation(Configuration conf) {
        WriteOperationType operationType = WriteOperationType.fromValue((String)conf.getString(FlinkOptions.OPERATION));
        return operationType == WriteOperationType.UPSERT;
    }

    public static boolean isBulkInsertOperation(Configuration conf) {
        WriteOperationType operationType = WriteOperationType.fromValue((String)conf.getString(FlinkOptions.OPERATION));
        return operationType == WriteOperationType.BULK_INSERT;
    }

    public static boolean isMorTable(Configuration conf) {
        return conf.getString(FlinkOptions.TABLE_TYPE).toUpperCase(Locale.ROOT).equals(FlinkOptions.TABLE_TYPE_MERGE_ON_READ);
    }

    public static boolean isMorTable(Map<String, String> options) {
        return options.getOrDefault(FlinkOptions.TABLE_TYPE.key(), (String)FlinkOptions.TABLE_TYPE.defaultValue()).equalsIgnoreCase(FlinkOptions.TABLE_TYPE_MERGE_ON_READ);
    }

    public static boolean isCowTable(Configuration conf) {
        return conf.getString(FlinkOptions.TABLE_TYPE).toUpperCase(Locale.ROOT).equals(FlinkOptions.TABLE_TYPE_COPY_ON_WRITE);
    }

    public static boolean isDefaultHoodieRecordPayloadClazz(Configuration conf) {
        return conf.getString(FlinkOptions.PAYLOAD_CLASS_NAME).contains(DefaultHoodieRecordPayload.class.getSimpleName());
    }

    public static String getPreCombineField(Configuration conf) {
        String preCombineField = conf.getString(FlinkOptions.PRECOMBINE_FIELD);
        return preCombineField.equals("no_precombine") ? null : preCombineField;
    }

    public static boolean isDeltaTimeCompaction(Configuration conf) {
        String strategy = conf.getString(FlinkOptions.COMPACTION_TRIGGER_STRATEGY).toLowerCase(Locale.ROOT);
        return "time_elapsed".equals(strategy) || "num_or_time".equals(strategy);
    }

    public static boolean isPartitionedTable(Configuration conf) {
        return FilePathUtils.extractPartitionKeys(conf).length > 0;
    }

    public static boolean isBucketIndexType(Configuration conf) {
        return conf.getString(FlinkOptions.INDEX_TYPE).equalsIgnoreCase(HoodieIndex.IndexType.BUCKET.name());
    }

    public static boolean isMorWithBucketIndexUpsert(Configuration conf) {
        return OptionsResolver.isMorTable(conf) && OptionsResolver.isUpsertOperation(conf) && OptionsResolver.isBucketIndexType(conf);
    }

    public static HoodieIndex.BucketIndexEngineType getBucketEngineType(Configuration conf) {
        String bucketEngineType = (String)conf.get(FlinkOptions.BUCKET_INDEX_ENGINE_TYPE);
        return HoodieIndex.BucketIndexEngineType.valueOf((String)bucketEngineType);
    }

    public static boolean isConsistentHashingBucketIndexType(Configuration conf) {
        return OptionsResolver.isBucketIndexType(conf) && OptionsResolver.getBucketEngineType(conf).equals((Object)HoodieIndex.BucketIndexEngineType.CONSISTENT_HASHING);
    }

    public static String getDefaultPlanStrategyClassName(Configuration conf) {
        return OptionsResolver.isConsistentHashingBucketIndexType(conf) ? FlinkConsistentBucketClusteringPlanStrategy.class.getName() : (String)FlinkOptions.CLUSTERING_PLAN_STRATEGY_CLASS.defaultValue();
    }

    public static boolean emitChangelog(Configuration conf) {
        return conf.getBoolean(FlinkOptions.READ_AS_STREAMING) && conf.getBoolean(FlinkOptions.CHANGELOG_ENABLED) || conf.getBoolean(FlinkOptions.READ_AS_STREAMING) && conf.getBoolean(FlinkOptions.CDC_ENABLED) || OptionsResolver.isIncrementalQuery(conf) && conf.getBoolean(FlinkOptions.CDC_ENABLED);
    }

    public static boolean needsAsyncCompaction(Configuration conf) {
        return OptionsResolver.isMorTable(conf) && conf.getBoolean(FlinkOptions.COMPACTION_ASYNC_ENABLED);
    }

    public static boolean needsScheduleCompaction(Configuration conf) {
        return OptionsResolver.isMorTable(conf) && conf.getBoolean(FlinkOptions.COMPACTION_SCHEDULE_ENABLED);
    }

    public static boolean needsAsyncClustering(Configuration conf) {
        return OptionsResolver.isInsertOperation(conf) && conf.getBoolean(FlinkOptions.CLUSTERING_ASYNC_ENABLED);
    }

    public static boolean needsScheduleClustering(Configuration conf) {
        if (!conf.getBoolean(FlinkOptions.CLUSTERING_SCHEDULE_ENABLED)) {
            return false;
        }
        WriteOperationType operationType = WriteOperationType.fromValue((String)conf.getString(FlinkOptions.OPERATION));
        if (OptionsResolver.isConsistentHashingBucketIndexType(conf)) {
            return operationType == WriteOperationType.UPSERT;
        }
        return operationType == WriteOperationType.INSERT;
    }

    public static boolean sortClusteringEnabled(Configuration conf) {
        return !StringUtils.isNullOrEmpty((String)conf.getString(FlinkOptions.CLUSTERING_SORT_COLUMNS));
    }

    public static boolean isInsertOverwrite(Configuration conf) {
        return conf.getString(FlinkOptions.OPERATION).equalsIgnoreCase(WriteOperationType.INSERT_OVERWRITE_TABLE.value()) || conf.getString(FlinkOptions.OPERATION).equalsIgnoreCase(WriteOperationType.INSERT_OVERWRITE.value());
    }

    public static boolean overwriteDynamicPartition(Configuration conf) {
        return conf.getString(FlinkOptions.OPERATION).equalsIgnoreCase(WriteOperationType.INSERT_OVERWRITE.value()) || conf.getString(FlinkOptions.WRITE_PARTITION_OVERWRITE_MODE).equalsIgnoreCase(PartitionOverwriteMode.DYNAMIC.name());
    }

    public static boolean isSpecificStartCommit(Configuration conf) {
        return conf.getOptional(FlinkOptions.READ_START_COMMIT).isPresent() && !((String)conf.get(FlinkOptions.READ_START_COMMIT)).equalsIgnoreCase("earliest");
    }

    public static boolean hasNoSpecificReadCommits(Configuration conf) {
        return !conf.contains(FlinkOptions.READ_START_COMMIT) && !conf.contains(FlinkOptions.READ_END_COMMIT);
    }

    public static HoodieCDCSupplementalLoggingMode getCDCSupplementalLoggingMode(Configuration conf) {
        String mode = conf.getString(FlinkOptions.SUPPLEMENTAL_LOGGING_MODE).toUpperCase();
        return HoodieCDCSupplementalLoggingMode.valueOf((String)mode);
    }

    public static boolean isSchemaEvolutionEnabled(Configuration conf) {
        return conf.getBoolean(HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE.key(), ((Boolean)HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE.defaultValue()).booleanValue());
    }

    public static boolean isIncrementalQuery(Configuration conf) {
        return conf.getOptional(FlinkOptions.READ_START_COMMIT).isPresent() || conf.getOptional(FlinkOptions.READ_END_COMMIT).isPresent();
    }

    public static boolean isConsistentLogicalTimestampEnabled(Configuration conf) {
        return conf.getBoolean(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), Boolean.parseBoolean((String)KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.defaultValue()));
    }

    public static boolean isLockRequired(Configuration conf) {
        return conf.getBoolean(FlinkOptions.METADATA_ENABLED) || OptionsResolver.isOptimisticConcurrencyControl(conf);
    }

    public static boolean isOptimisticConcurrencyControl(Configuration conf) {
        return conf.getString(HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key(), (String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue()).equalsIgnoreCase(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.name());
    }

    public static boolean isReadByTxnCompletionTime(Configuration conf) {
        TimelineUtils.HollowCommitHandling handlingMode = TimelineUtils.HollowCommitHandling.valueOf((String)conf.getString(HoodieCommonConfig.INCREMENTAL_READ_HANDLE_HOLLOW_COMMIT.key(), (String)HoodieCommonConfig.INCREMENTAL_READ_HANDLE_HOLLOW_COMMIT.defaultValue()));
        return handlingMode == TimelineUtils.HollowCommitHandling.USE_TRANSITION_TIME;
    }

    public static HoodieIndex.IndexType getIndexType(Configuration conf) {
        return HoodieIndex.IndexType.valueOf((String)conf.getString(FlinkOptions.INDEX_TYPE).toUpperCase());
    }

    public static String getIndexKeyField(Configuration conf) {
        return conf.getString(FlinkOptions.INDEX_KEY_FIELD, conf.getString(FlinkOptions.RECORD_KEY_FIELD));
    }

    public static String[] getIndexKeys(Configuration conf) {
        return OptionsResolver.getIndexKeyField(conf).split(",");
    }

    public static ConflictResolutionStrategy getConflictResolutionStrategy(Configuration conf) {
        return OptionsResolver.isBucketIndexType(conf) ? new BucketIndexConcurrentFileWritesConflictResolutionStrategy() : new SimpleConcurrentFileWritesConflictResolutionStrategy();
    }

    public static boolean allowCommitOnEmptyBatch(Configuration conf) {
        return conf.getBoolean(HoodieWriteConfig.ALLOW_EMPTY_COMMIT.key(), false);
    }

    public static boolean isLazyFailedWritesCleanPolicy(Configuration conf) {
        return conf.getString(HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.key(), (String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue()).equalsIgnoreCase(HoodieFailedWritesCleaningPolicy.LAZY.name());
    }

    public static List<ConfigOption<?>> allOptions(Class<?> clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        ArrayList options = new ArrayList();
        for (Field field : declaredFields) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(ConfigOption.class)) continue;
            try {
                options.add((ConfigOption)field.get(ConfigOption.class));
            }
            catch (IllegalAccessException e) {
                throw new HoodieException("Error while fetching static config option", (Throwable)e);
            }
        }
        return options;
    }
}

