/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.source.stats.ColumnStats;
import org.apache.hudi.util.ExpressionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionEvaluators {
    public static List<Evaluator> fromExpression(List<ResolvedExpression> exprs) {
        return exprs.stream().map(e -> ExpressionEvaluators.fromExpression((CallExpression)e)).collect(Collectors.toList());
    }

    public static Evaluator fromExpression(CallExpression expr) {
        NullFalseEvaluator evaluator;
        FunctionDefinition funDef = expr.getFunctionDefinition();
        List childExprs = expr.getChildren();
        boolean normalized = childExprs.get(0) instanceof FieldReferenceExpression;
        if (BuiltInFunctionDefinitions.NOT.equals(funDef)) {
            Not evaluator2 = Not.getInstance();
            Evaluator childEvaluator = ExpressionEvaluators.fromExpression((CallExpression)childExprs.get(0));
            return evaluator2.bindEvaluator(childEvaluator);
        }
        if (BuiltInFunctionDefinitions.AND.equals(funDef)) {
            And evaluator3 = And.getInstance();
            Evaluator evaluator1 = ExpressionEvaluators.fromExpression((CallExpression)childExprs.get(0));
            Evaluator evaluator2 = ExpressionEvaluators.fromExpression((CallExpression)childExprs.get(1));
            return evaluator3.bindEvaluator(evaluator1, evaluator2);
        }
        if (BuiltInFunctionDefinitions.OR.equals(funDef)) {
            Or evaluator4 = Or.getInstance();
            Evaluator evaluator1 = ExpressionEvaluators.fromExpression((CallExpression)childExprs.get(0));
            Evaluator evaluator2 = ExpressionEvaluators.fromExpression((CallExpression)childExprs.get(1));
            return evaluator4.bindEvaluator(evaluator1, evaluator2);
        }
        if (BuiltInFunctionDefinitions.IS_NULL.equals(funDef)) {
            FieldReferenceExpression rExpr = (FieldReferenceExpression)childExprs.get(0);
            return IsNull.getInstance().bindFieldReference(rExpr);
        }
        if (BuiltInFunctionDefinitions.IS_NOT_NULL.equals(funDef)) {
            FieldReferenceExpression rExpr = (FieldReferenceExpression)childExprs.get(0);
            return IsNotNull.getInstance().bindFieldReference(rExpr);
        }
        boolean hasNullLiteral = childExprs.stream().anyMatch(e -> e instanceof ValueLiteralExpression && ExpressionUtils.getValueFromLiteral((ValueLiteralExpression)e) == null);
        if (hasNullLiteral) {
            return AlwaysFalse.getInstance();
        }
        if (BuiltInFunctionDefinitions.IN.equals(funDef)) {
            ValidationUtils.checkState((boolean)normalized, (String)"The IN expression expects to be normalized");
            In in = In.getInstance();
            FieldReferenceExpression rExpr = (FieldReferenceExpression)childExprs.get(0);
            in.bindFieldReference(rExpr);
            in.bindVals(ExpressionEvaluators.getInLiteralVals(childExprs));
            return in;
        }
        if (BuiltInFunctionDefinitions.EQUALS.equals(funDef)) {
            evaluator = EqualTo.getInstance();
        } else if (BuiltInFunctionDefinitions.NOT_EQUALS.equals(funDef)) {
            evaluator = NotEqualTo.getInstance();
        } else if (BuiltInFunctionDefinitions.LESS_THAN.equals(funDef)) {
            evaluator = normalized ? LessThan.getInstance() : GreaterThan.getInstance();
        } else if (BuiltInFunctionDefinitions.GREATER_THAN.equals(funDef)) {
            evaluator = normalized ? GreaterThan.getInstance() : LessThan.getInstance();
        } else if (BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL.equals(funDef)) {
            evaluator = normalized ? LessThanOrEqual.getInstance() : GreaterThanOrEqual.getInstance();
        } else if (BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL.equals(funDef)) {
            evaluator = normalized ? GreaterThanOrEqual.getInstance() : LessThanOrEqual.getInstance();
        } else {
            throw new AssertionError((Object)("Unexpected function definition " + funDef));
        }
        FieldReferenceExpression rExpr = normalized ? (FieldReferenceExpression)childExprs.get(0) : (FieldReferenceExpression)childExprs.get(1);
        ValueLiteralExpression vExpr = normalized ? (ValueLiteralExpression)childExprs.get(1) : (ValueLiteralExpression)childExprs.get(0);
        evaluator.bindVal(vExpr).bindFieldReference(rExpr);
        return evaluator;
    }

    private static Object[] getInLiteralVals(List<Expression> childExprs) {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (int i = 1; i < childExprs.size(); ++i) {
            vals.add(ExpressionUtils.getValueFromLiteral((ValueLiteralExpression)childExprs.get(i)));
        }
        return vals.toArray();
    }

    private static int compare(@NotNull Object val1, @NotNull Object val2, LogicalType logicalType) {
        switch (logicalType.getTypeRoot()) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: {
                return ((Long)val1).compareTo((Long)val2);
            }
            case BOOLEAN: {
                return ((Boolean)val1).compareTo((Boolean)val2);
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                return ExpressionEvaluators.getBigDecimal(val1).compareTo(ExpressionEvaluators.getBigDecimal(val2));
            }
            case BINARY: 
            case VARBINARY: {
                return ExpressionEvaluators.compareBytes((byte[])val1, (byte[])val2);
            }
            case CHAR: 
            case VARCHAR: {
                return ((String)val1).compareTo((String)val2);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + logicalType);
    }

    private static BigDecimal getBigDecimal(@NotNull Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Double) {
            return new BigDecimal((Double)value);
        }
        if (value instanceof Float) {
            return new BigDecimal(((Float)value).doubleValue());
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof Short) {
            return new BigDecimal(((Short)value).shortValue());
        }
        if (value instanceof Byte) {
            return new BigDecimal(((Byte)value).byteValue());
        }
        throw new UnsupportedOperationException("Unable convert to BigDecimal: " + value);
    }

    private static int compareBytes(byte[] v1, byte[] v2) {
        int len1 = v1.length;
        int len2 = v2.length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            byte c1 = v1[k];
            byte c2 = v2[k];
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static class Or
    implements Evaluator {
        private static final long serialVersionUID = 1L;
        private Evaluator[] evaluators;

        public static Or getInstance() {
            return new Or();
        }

        @Override
        public boolean eval(Map<String, ColumnStats> columnStatsMap) {
            for (Evaluator evaluator : this.evaluators) {
                if (!evaluator.eval(columnStatsMap)) continue;
                return true;
            }
            return false;
        }

        public Evaluator bindEvaluator(Evaluator ... evaluators) {
            this.evaluators = evaluators;
            return this;
        }
    }

    public static class And
    implements Evaluator {
        private static final long serialVersionUID = 1L;
        private Evaluator[] evaluators;

        public static And getInstance() {
            return new And();
        }

        @Override
        public boolean eval(Map<String, ColumnStats> columnStatsMap) {
            for (Evaluator evaluator : this.evaluators) {
                if (evaluator.eval(columnStatsMap)) continue;
                return false;
            }
            return true;
        }

        public Evaluator bindEvaluator(Evaluator ... evaluators) {
            this.evaluators = evaluators;
            return this;
        }
    }

    public static class Not
    implements Evaluator {
        private static final long serialVersionUID = 1L;
        private Evaluator evaluator;

        public static Not getInstance() {
            return new Not();
        }

        @Override
        public boolean eval(Map<String, ColumnStats> columnStatsMap) {
            return !this.evaluator.eval(columnStatsMap);
        }

        public Evaluator bindEvaluator(Evaluator evaluator) {
            this.evaluator = evaluator;
            return this;
        }
    }

    public static class AlwaysFalse
    implements Evaluator {
        private static final long serialVersionUID = 1L;

        public static AlwaysFalse getInstance() {
            return new AlwaysFalse();
        }

        @Override
        public boolean eval(Map<String, ColumnStats> columnStatsMap) {
            return false;
        }
    }

    public static class In
    extends LeafEvaluator {
        private static final long serialVersionUID = 1L;
        private static final Logger LOGGER = LoggerFactory.getLogger(In.class);
        private static final int IN_PREDICATE_LIMIT = 200;
        private Object[] vals;

        public static In getInstance() {
            return new In();
        }

        @Override
        public boolean eval(Map<String, ColumnStats> columnStatsMap) {
            if (Arrays.stream(this.vals).anyMatch(Objects::isNull)) {
                return false;
            }
            ColumnStats columnStats = this.getColumnStats(columnStatsMap);
            Object minVal = columnStats.getMinVal();
            Object maxVal = columnStats.getMaxVal();
            if (minVal == null) {
                return false;
            }
            if (this.vals.length > 200) {
                LOGGER.warn("Skip evaluating in predicate because the number of values is too big!");
                return true;
            }
            return Arrays.stream(this.vals).anyMatch(v -> ExpressionEvaluators.compare(minVal, v, this.type) <= 0 && ExpressionEvaluators.compare(maxVal, v, this.type) >= 0);
        }

        public void bindVals(Object ... vals) {
            this.vals = vals;
        }
    }

    public static class GreaterThanOrEqual
    extends NullFalseEvaluator {
        private static final long serialVersionUID = 1L;

        public static GreaterThanOrEqual getInstance() {
            return new GreaterThanOrEqual();
        }

        @Override
        protected boolean eval(@NotNull Object val, ColumnStats columnStats, LogicalType type) {
            Object maxVal = columnStats.getMaxVal();
            if (maxVal == null) {
                return false;
            }
            return ExpressionEvaluators.compare(maxVal, val, type) >= 0;
        }
    }

    public static class LessThanOrEqual
    extends NullFalseEvaluator {
        private static final long serialVersionUID = 1L;

        public static LessThanOrEqual getInstance() {
            return new LessThanOrEqual();
        }

        @Override
        protected boolean eval(@NotNull Object val, ColumnStats columnStats, LogicalType type) {
            Object minVal = columnStats.getMinVal();
            if (minVal == null) {
                return false;
            }
            return ExpressionEvaluators.compare(minVal, val, type) <= 0;
        }
    }

    public static class GreaterThan
    extends NullFalseEvaluator {
        private static final long serialVersionUID = 1L;

        public static GreaterThan getInstance() {
            return new GreaterThan();
        }

        @Override
        protected boolean eval(@NotNull Object val, ColumnStats columnStats, LogicalType type) {
            Object maxVal = columnStats.getMaxVal();
            if (maxVal == null) {
                return false;
            }
            return ExpressionEvaluators.compare(maxVal, val, type) > 0;
        }
    }

    public static class LessThan
    extends NullFalseEvaluator {
        private static final long serialVersionUID = 1L;

        public static LessThan getInstance() {
            return new LessThan();
        }

        @Override
        public boolean eval(@NotNull Object val, ColumnStats columnStats, LogicalType type) {
            Object minVal = columnStats.getMinVal();
            if (minVal == null) {
                return false;
            }
            return ExpressionEvaluators.compare(minVal, val, type) < 0;
        }
    }

    public static class IsNotNull
    extends LeafEvaluator {
        private static final long serialVersionUID = 1L;

        public static IsNotNull getInstance() {
            return new IsNotNull();
        }

        @Override
        public boolean eval(Map<String, ColumnStats> columnStatsMap) {
            ColumnStats columnStats = this.getColumnStats(columnStatsMap);
            return columnStats.getMinVal() != null || columnStats.getNullCnt() <= 0L;
        }
    }

    public static class IsNull
    extends LeafEvaluator {
        private static final long serialVersionUID = 1L;

        public static IsNull getInstance() {
            return new IsNull();
        }

        @Override
        public boolean eval(Map<String, ColumnStats> columnStatsMap) {
            ColumnStats columnStats = this.getColumnStats(columnStatsMap);
            return columnStats.getNullCnt() > 0L;
        }
    }

    public static class NotEqualTo
    extends NullFalseEvaluator {
        private static final long serialVersionUID = 1L;

        public static NotEqualTo getInstance() {
            return new NotEqualTo();
        }

        @Override
        protected boolean eval(@NotNull Object val, ColumnStats columnStats, LogicalType type) {
            Object minVal = columnStats.getMinVal();
            Object maxVal = columnStats.getMaxVal();
            if (minVal == null || maxVal == null) {
                return false;
            }
            return ExpressionEvaluators.compare(minVal, val, type) != 0 || ExpressionEvaluators.compare(maxVal, val, type) != 0;
        }
    }

    public static class EqualTo
    extends NullFalseEvaluator {
        private static final long serialVersionUID = 1L;

        public static EqualTo getInstance() {
            return new EqualTo();
        }

        @Override
        protected boolean eval(@NotNull Object val, ColumnStats columnStats, LogicalType type) {
            Object minVal = columnStats.getMinVal();
            Object maxVal = columnStats.getMaxVal();
            if (minVal == null || maxVal == null) {
                return false;
            }
            if (ExpressionEvaluators.compare(minVal, val, type) > 0) {
                return false;
            }
            return ExpressionEvaluators.compare(maxVal, val, type) >= 0;
        }
    }

    public static abstract class NullFalseEvaluator
    extends LeafEvaluator {
        protected Object val;

        public NullFalseEvaluator bindVal(ValueLiteralExpression vExpr) {
            this.val = ExpressionUtils.getValueFromLiteral(vExpr);
            return this;
        }

        @Override
        public final boolean eval(Map<String, ColumnStats> columnStatsMap) {
            if (this.val == null) {
                return false;
            }
            return this.eval(this.val, this.getColumnStats(columnStatsMap), this.type);
        }

        protected abstract boolean eval(@NotNull Object var1, ColumnStats var2, LogicalType var3);
    }

    public static abstract class LeafEvaluator
    implements Evaluator {
        protected LogicalType type;
        protected String name;
        protected int index;

        public LeafEvaluator bindFieldReference(FieldReferenceExpression expr) {
            this.type = expr.getOutputDataType().getLogicalType();
            this.name = expr.getName();
            this.index = expr.getFieldIndex();
            return this;
        }

        protected ColumnStats getColumnStats(Map<String, ColumnStats> columnStatsMap) {
            ColumnStats columnStats = columnStatsMap.get(this.name);
            ValidationUtils.checkState((columnStats != null ? 1 : 0) != 0, (String)("Can not find column " + this.name));
            return columnStats;
        }
    }

    public static interface Evaluator
    extends Serializable {
        public boolean eval(Map<String, ColumnStats> var1);
    }
}

