/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.source.ExpressionEvaluators;
import org.apache.hudi.util.ExpressionUtils;
import org.apache.hudi.util.ImplicitTypeConverter;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.io.api.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionPredicates {
    private static final Logger LOG = LoggerFactory.getLogger(ExpressionPredicates.class);

    public static List<Predicate> fromExpression(List<ResolvedExpression> resolvedExpressions) {
        return resolvedExpressions.stream().map(e -> ExpressionPredicates.fromExpression((CallExpression)e)).collect(Collectors.toList());
    }

    public static Predicate fromExpression(CallExpression callExpression) {
        ColumnPredicate predicate;
        FunctionDefinition functionDefinition = callExpression.getFunctionDefinition();
        List childExpressions = callExpression.getChildren();
        boolean normalized = childExpressions.get(0) instanceof FieldReferenceExpression;
        if (BuiltInFunctionDefinitions.NOT.equals(functionDefinition)) {
            Not predicate2 = Not.getInstance();
            Predicate childPredicate = ExpressionPredicates.fromExpression((CallExpression)childExpressions.get(0));
            return predicate2.bindPredicate(childPredicate);
        }
        if (BuiltInFunctionDefinitions.AND.equals(functionDefinition)) {
            And predicate3 = And.getInstance();
            Predicate predicate1 = ExpressionPredicates.fromExpression((CallExpression)childExpressions.get(0));
            Predicate predicate2 = ExpressionPredicates.fromExpression((CallExpression)childExpressions.get(1));
            return predicate3.bindPredicates(predicate1, predicate2);
        }
        if (BuiltInFunctionDefinitions.OR.equals(functionDefinition)) {
            Or predicate4 = Or.getInstance();
            Predicate predicate1 = ExpressionPredicates.fromExpression((CallExpression)childExpressions.get(0));
            Predicate predicate2 = ExpressionPredicates.fromExpression((CallExpression)childExpressions.get(1));
            return predicate4.bindPredicates(predicate1, predicate2);
        }
        if (BuiltInFunctionDefinitions.IS_NULL.equals(functionDefinition) || BuiltInFunctionDefinitions.IS_NOT_NULL.equals(functionDefinition) || childExpressions.stream().anyMatch(e -> e instanceof ValueLiteralExpression && ExpressionUtils.getValueFromLiteral((ValueLiteralExpression)e) == null)) {
            return AlwaysNull.getInstance();
        }
        if (BuiltInFunctionDefinitions.IN.equals(functionDefinition)) {
            ValidationUtils.checkState((boolean)normalized, (String)"The IN expression expects to be normalized");
            In in = In.getInstance();
            FieldReferenceExpression fieldReference = (FieldReferenceExpression)childExpressions.get(0);
            List<ValueLiteralExpression> valueLiterals = IntStream.range(1, childExpressions.size()).mapToObj(index -> (ValueLiteralExpression)childExpressions.get(index)).collect(Collectors.toList());
            return in.bindValueLiterals(valueLiterals).bindFieldReference(fieldReference);
        }
        if (BuiltInFunctionDefinitions.EQUALS.equals(functionDefinition)) {
            predicate = Equals.getInstance();
        } else if (BuiltInFunctionDefinitions.NOT_EQUALS.equals(functionDefinition)) {
            predicate = NotEquals.getInstance();
        } else if (BuiltInFunctionDefinitions.LESS_THAN.equals(functionDefinition)) {
            predicate = normalized ? LessThan.getInstance() : GreaterThan.getInstance();
        } else if (BuiltInFunctionDefinitions.GREATER_THAN.equals(functionDefinition)) {
            predicate = normalized ? GreaterThan.getInstance() : LessThan.getInstance();
        } else if (BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL.equals(functionDefinition)) {
            predicate = normalized ? LessThanOrEqual.getInstance() : GreaterThanOrEqual.getInstance();
        } else if (BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL.equals(functionDefinition)) {
            predicate = normalized ? GreaterThanOrEqual.getInstance() : LessThanOrEqual.getInstance();
        } else {
            throw new AssertionError((Object)("Unexpected function definition " + functionDefinition));
        }
        FieldReferenceExpression fieldReference = normalized ? (FieldReferenceExpression)childExpressions.get(0) : (FieldReferenceExpression)childExpressions.get(1);
        ValueLiteralExpression valueLiteral = normalized ? (ValueLiteralExpression)childExpressions.get(1) : (ValueLiteralExpression)childExpressions.get(0);
        return predicate.bindValueLiteral(valueLiteral).bindFieldReference(fieldReference);
    }

    private static FilterPredicate toParquetPredicate(FunctionDefinition functionDefinition, LogicalType literalType, String columnName, Serializable literal) {
        switch (literalType.getTypeRoot()) {
            case BOOLEAN: {
                return ExpressionPredicates.predicateSupportsEqNotEq(functionDefinition, FilterApi.booleanColumn((String)columnName), (Boolean)literal);
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                return ExpressionPredicates.predicateSupportsLtGt(functionDefinition, FilterApi.intColumn((String)columnName), (Integer)literal);
            }
            case BIGINT: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return ExpressionPredicates.predicateSupportsLtGt(functionDefinition, FilterApi.longColumn((String)columnName), (Long)literal);
            }
            case FLOAT: {
                return ExpressionPredicates.predicateSupportsLtGt(functionDefinition, FilterApi.floatColumn((String)columnName), (Float)literal);
            }
            case DOUBLE: {
                return ExpressionPredicates.predicateSupportsLtGt(functionDefinition, FilterApi.doubleColumn((String)columnName), (Double)literal);
            }
            case BINARY: 
            case VARBINARY: {
                return ExpressionPredicates.predicateSupportsLtGt(functionDefinition, FilterApi.binaryColumn((String)columnName), Binary.fromConstantByteArray((byte[])((byte[])literal)));
            }
            case CHAR: 
            case VARCHAR: {
                return ExpressionPredicates.predicateSupportsLtGt(functionDefinition, FilterApi.binaryColumn((String)columnName), Binary.fromString((String)((String)((Object)literal))));
            }
        }
        return null;
    }

    private static <T extends Comparable<T>, C extends Operators.Column<T>> FilterPredicate predicateSupportsEqNotEq(FunctionDefinition functionDefinition, C column, T value) {
        if (BuiltInFunctionDefinitions.EQUALS.equals(functionDefinition)) {
            return FilterApi.eq(column, value);
        }
        if (BuiltInFunctionDefinitions.NOT_EQUALS.equals(functionDefinition)) {
            return FilterApi.notEq(column, value);
        }
        throw new AssertionError((Object)("Unexpected function definition " + functionDefinition));
    }

    private static <T extends Comparable<T>, C extends Operators.Column<T>> FilterPredicate predicateSupportsLtGt(FunctionDefinition functionDefinition, C column, T value) {
        if (BuiltInFunctionDefinitions.EQUALS.equals(functionDefinition)) {
            return FilterApi.eq(column, value);
        }
        if (BuiltInFunctionDefinitions.NOT_EQUALS.equals(functionDefinition)) {
            return FilterApi.notEq(column, value);
        }
        if (BuiltInFunctionDefinitions.LESS_THAN.equals(functionDefinition)) {
            return FilterApi.lt(column, value);
        }
        if (BuiltInFunctionDefinitions.GREATER_THAN.equals(functionDefinition)) {
            return FilterApi.gt(column, value);
        }
        if (BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL.equals(functionDefinition)) {
            return FilterApi.ltEq(column, value);
        }
        if (BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL.equals(functionDefinition)) {
            return FilterApi.gtEq(column, value);
        }
        throw new AssertionError((Object)("Unexpected function definition " + functionDefinition));
    }

    public static class Or
    implements Predicate {
        private static final long serialVersionUID = 1L;
        private Predicate[] predicates;

        public static Or getInstance() {
            return new Or();
        }

        public Predicate bindPredicates(Predicate ... predicates) {
            this.predicates = predicates;
            return this;
        }

        @Override
        public FilterPredicate filter() {
            FilterPredicate filterPredicate0 = this.predicates[0].filter();
            FilterPredicate filterPredicate1 = this.predicates[1].filter();
            if (null == filterPredicate0 || null == filterPredicate1) {
                return null;
            }
            return FilterApi.or((FilterPredicate)filterPredicate0, (FilterPredicate)filterPredicate1);
        }

        public String toString() {
            return "OR(" + Arrays.toString(this.predicates) + ")";
        }
    }

    public static class And
    implements Predicate {
        private static final long serialVersionUID = 1L;
        private Predicate[] predicates;

        public static And getInstance() {
            return new And();
        }

        public Predicate bindPredicates(Predicate ... predicates) {
            this.predicates = predicates;
            return this;
        }

        @Override
        public FilterPredicate filter() {
            FilterPredicate filterPredicate0 = this.predicates[0].filter();
            FilterPredicate filterPredicate1 = this.predicates[1].filter();
            if (null == filterPredicate0 || null == filterPredicate1) {
                return null;
            }
            return FilterApi.and((FilterPredicate)filterPredicate0, (FilterPredicate)filterPredicate1);
        }

        public String toString() {
            return "AND(" + Arrays.toString(this.predicates) + ")";
        }
    }

    public static class Not
    implements Predicate {
        private static final long serialVersionUID = 1L;
        private Predicate predicate;

        public static Not getInstance() {
            return new Not();
        }

        public Predicate bindPredicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        @Override
        public FilterPredicate filter() {
            FilterPredicate filterPredicate = this.predicate.filter();
            if (null == filterPredicate) {
                return null;
            }
            return FilterApi.not((FilterPredicate)filterPredicate);
        }

        public String toString() {
            return "NOT(" + this.predicate.toString() + ")";
        }
    }

    public static class AlwaysNull
    implements Predicate {
        private static final long serialVersionUID = 1L;

        public static AlwaysNull getInstance() {
            return new AlwaysNull();
        }

        @Override
        public FilterPredicate filter() {
            return null;
        }
    }

    public static class In
    extends ColumnPredicate {
        private static final long serialVersionUID = 1L;
        private static final Logger LOG = LoggerFactory.getLogger(ExpressionEvaluators.In.class);
        private static final int IN_PREDICATE_LIMIT = 200;
        protected List<Serializable> literals;

        public static In getInstance() {
            return new In();
        }

        public ColumnPredicate bindValueLiterals(List<ValueLiteralExpression> valueLiterals) {
            this.literals = valueLiterals.stream().map(valueLiteral -> {
                Object literalObject = ExpressionUtils.getValueFromLiteral(valueLiteral);
                if (literalObject instanceof Serializable) {
                    return (Serializable)literalObject;
                }
                LOG.warn("Encountered a non-serializable literal. Cannot push predicate with value literal [{}] into FileInputFormat. This is a bug and should be reported.", valueLiteral);
                return null;
            }).collect(Collectors.toList());
            return this;
        }

        @Override
        public FilterPredicate filter() {
            if (this.literals.stream().anyMatch(Objects::isNull) || this.literals.size() > 200) {
                return null;
            }
            FilterPredicate filterPredicate = null;
            for (Serializable literal : this.literals) {
                FilterPredicate predicate = ExpressionPredicates.toParquetPredicate((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, this.literalType, this.columnName, literal);
                if (predicate == null) continue;
                filterPredicate = filterPredicate == null ? predicate : FilterApi.or((FilterPredicate)filterPredicate, (FilterPredicate)predicate);
            }
            return filterPredicate;
        }

        public String toString() {
            return this.columnName + " IN(" + Arrays.toString(this.literals.toArray()) + ")";
        }
    }

    public static class GreaterThanOrEqual
    extends ColumnPredicate {
        private static final long serialVersionUID = 1L;

        public static GreaterThanOrEqual getInstance() {
            return new GreaterThanOrEqual();
        }

        @Override
        public FunctionDefinition getFunctionDefinition() {
            return BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL;
        }

        public String toString() {
            return this.columnName + " >= " + this.literal;
        }
    }

    public static class LessThanOrEqual
    extends ColumnPredicate {
        private static final long serialVersionUID = 1L;

        public static LessThanOrEqual getInstance() {
            return new LessThanOrEqual();
        }

        @Override
        public FunctionDefinition getFunctionDefinition() {
            return BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL;
        }

        public String toString() {
            return this.columnName + " <= " + this.literal;
        }
    }

    public static class GreaterThan
    extends ColumnPredicate {
        private static final long serialVersionUID = 1L;

        public static GreaterThan getInstance() {
            return new GreaterThan();
        }

        @Override
        public FunctionDefinition getFunctionDefinition() {
            return BuiltInFunctionDefinitions.GREATER_THAN;
        }

        public String toString() {
            return this.columnName + " > " + this.literal;
        }
    }

    public static class LessThan
    extends ColumnPredicate {
        private static final long serialVersionUID = 1L;

        public static LessThan getInstance() {
            return new LessThan();
        }

        @Override
        public FunctionDefinition getFunctionDefinition() {
            return BuiltInFunctionDefinitions.LESS_THAN;
        }

        public String toString() {
            return this.columnName + " < " + this.literal;
        }
    }

    public static class NotEquals
    extends ColumnPredicate {
        private static final long serialVersionUID = 1L;

        public static NotEquals getInstance() {
            return new NotEquals();
        }

        @Override
        public FunctionDefinition getFunctionDefinition() {
            return BuiltInFunctionDefinitions.NOT_EQUALS;
        }

        public String toString() {
            return this.columnName + " != " + this.literal;
        }
    }

    public static class Equals
    extends ColumnPredicate {
        private static final long serialVersionUID = 1L;

        public static Equals getInstance() {
            return new Equals();
        }

        @Override
        public FunctionDefinition getFunctionDefinition() {
            return BuiltInFunctionDefinitions.EQUALS;
        }

        public String toString() {
            return this.columnName + " = " + this.literal;
        }
    }

    public static abstract class ColumnPredicate
    implements Predicate {
        protected LogicalType literalType;
        protected String columnName;
        protected Serializable literal;

        public ColumnPredicate bindFieldReference(FieldReferenceExpression fieldReference) {
            this.literalType = fieldReference.getOutputDataType().getLogicalType();
            this.columnName = fieldReference.getName();
            return this;
        }

        public ColumnPredicate bindValueLiteral(ValueLiteralExpression valueLiteral) {
            Object literalObject = ExpressionUtils.getValueFromLiteral(valueLiteral);
            if (literalObject instanceof Serializable) {
                this.literal = (Serializable)literalObject;
            } else {
                LOG.warn("Encountered a non-serializable literal. Cannot push predicate with value literal [{}] into FileInputFormat. This is a bug and should be reported.", (Object)valueLiteral);
                this.literal = null;
            }
            return this;
        }

        @Override
        public FilterPredicate filter() {
            Serializable convertedLiteral = ImplicitTypeConverter.convertImplicitly(this.literalType, this.literal);
            return ExpressionPredicates.toParquetPredicate(this.getFunctionDefinition(), this.literalType, this.columnName, convertedLiteral);
        }

        public FunctionDefinition getFunctionDefinition() {
            return null;
        }
    }

    public static interface Predicate
    extends Serializable {
        public FilterPredicate filter();
    }
}

