/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format;

import java.io.IOException;
import org.apache.flink.table.data.RowData;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.format.cow.vector.reader.ParquetColumnarRowSplitReader;

public final class ParquetSplitRecordIterator
implements ClosableIterator<RowData> {
    private final ParquetColumnarRowSplitReader reader;

    public ParquetSplitRecordIterator(ParquetColumnarRowSplitReader reader) {
        this.reader = reader;
    }

    public boolean hasNext() {
        try {
            return !this.reader.reachedEnd();
        }
        catch (IOException e) {
            throw new HoodieIOException("Decides whether the parquet columnar row split reader reached end exception", e);
        }
    }

    public RowData next() {
        return this.reader.nextRecord();
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new HoodieIOException("Close the parquet columnar row split reader exception", e);
        }
    }
}

