/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.hudi.common.util.ValidationUtils;

@Internal
public class TypeConverters {
    public static TypeConverter getInstance(LogicalType fromType, final LogicalType toType) {
        LogicalTypeRoot from = fromType.getTypeRoot();
        LogicalTypeRoot to = toType.getTypeRoot();
        switch (to) {
            case BIGINT: {
                if (from != LogicalTypeRoot.INTEGER) break;
                return new TypeConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Object val) {
                        return ((Number)val).longValue();
                    }
                };
            }
            case FLOAT: {
                if (from != LogicalTypeRoot.INTEGER && from != LogicalTypeRoot.BIGINT) break;
                return new TypeConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Object val) {
                        return Float.valueOf(((Number)val).floatValue());
                    }
                };
            }
            case DOUBLE: {
                if (from == LogicalTypeRoot.INTEGER || from == LogicalTypeRoot.BIGINT) {
                    return new TypeConverter(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public Object convert(Object val) {
                            return ((Number)val).doubleValue();
                        }
                    };
                }
                if (from != LogicalTypeRoot.FLOAT) break;
                return new TypeConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Object val) {
                        return Double.parseDouble(val.toString());
                    }
                };
            }
            case DECIMAL: {
                if (from == LogicalTypeRoot.INTEGER || from == LogicalTypeRoot.BIGINT || from == LogicalTypeRoot.DOUBLE) {
                    return new TypeConverter(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public Object convert(Object val) {
                            return TypeConverters.toDecimalData((Number)val, toType);
                        }
                    };
                }
                if (from == LogicalTypeRoot.FLOAT) {
                    return new TypeConverter(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public Object convert(Object val) {
                            return TypeConverters.toDecimalData(Double.parseDouble(val.toString()), toType);
                        }
                    };
                }
                if (from == LogicalTypeRoot.VARCHAR) {
                    return new TypeConverter(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public Object convert(Object val) {
                            return TypeConverters.toDecimalData(Double.parseDouble(val.toString()), toType);
                        }
                    };
                }
                if (from != LogicalTypeRoot.DECIMAL) break;
                return new TypeConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Object val) {
                        return TypeConverters.toDecimalData(((DecimalData)val).toBigDecimal(), toType);
                    }
                };
            }
            case VARCHAR: {
                if (from == LogicalTypeRoot.INTEGER || from == LogicalTypeRoot.BIGINT || from == LogicalTypeRoot.FLOAT || from == LogicalTypeRoot.DOUBLE || from == LogicalTypeRoot.DECIMAL) {
                    return new TypeConverter(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public Object convert(Object val) {
                            return new BinaryStringData(String.valueOf(val));
                        }
                    };
                }
                if (from != LogicalTypeRoot.DATE) break;
                return new TypeConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Object val) {
                        return new BinaryStringData(LocalDate.ofEpochDay(((Integer)val).longValue()).toString());
                    }
                };
            }
            case DATE: {
                if (from != LogicalTypeRoot.VARCHAR) break;
                return new TypeConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Object val) {
                        return (int)LocalDate.parse(val.toString()).toEpochDay();
                    }
                };
            }
            case ARRAY: {
                if (from != LogicalTypeRoot.ARRAY) break;
                try {
                    LogicalType fromElementType = (LogicalType)fromType.getChildren().get(0);
                    LogicalType toElementType = (LogicalType)toType.getChildren().get(0);
                    return TypeConverters.createArrayConverter(fromElementType, toElementType);
                }
                catch (IllegalStateException ise) {
                    return null;
                }
            }
            case MAP: {
                if (from != LogicalTypeRoot.MAP) break;
                try {
                    return TypeConverters.createMapConverter(fromType, toType);
                }
                catch (IllegalStateException ise) {
                    return null;
                }
            }
            case ROW: {
                if (from != LogicalTypeRoot.ROW) break;
                try {
                    ValidationUtils.checkArgument((fromType.getChildren().size() == toType.getChildren().size() ? 1 : 0) != 0);
                    return TypeConverters.createRowConverter(fromType, toType);
                }
                catch (IllegalStateException ise) {
                    return null;
                }
            }
        }
        return null;
    }

    private static TypeConverter createArrayConverter(LogicalType fromType, LogicalType toType) {
        final ArrayData.ElementGetter elementGetter = ArrayData.createElementGetter((LogicalType)fromType);
        final TypeConverter converter = TypeConverters.getInstance(fromType, toType);
        ValidationUtils.checkState((converter != null ? 1 : 0) != 0);
        return new TypeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object val) {
                ArrayData array = (ArrayData)val;
                Object[] objects = new Object[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    Object toObj;
                    Object fromObj = elementGetter.getElementOrNull(array, i);
                    objects[i] = toObj = fromObj != null ? converter.convert(fromObj) : null;
                }
                return new GenericArrayData(objects);
            }
        };
    }

    private static TypeConverter createMapConverter(LogicalType fromType, LogicalType toType) {
        LogicalType keyType = (LogicalType)fromType.getChildren().get(0);
        LogicalType fromValueType = (LogicalType)fromType.getChildren().get(1);
        LogicalType toValueType = (LogicalType)toType.getChildren().get(1);
        final ArrayData.ElementGetter keyElementGetter = ArrayData.createElementGetter((LogicalType)keyType);
        final ArrayData.ElementGetter valueElementGetter = ArrayData.createElementGetter((LogicalType)fromValueType);
        final TypeConverter converter = TypeConverters.getInstance(fromValueType, toValueType);
        ValidationUtils.checkState((converter != null ? 1 : 0) != 0);
        return new TypeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object val) {
                HashMap<Object, Object> result = new HashMap<Object, Object>();
                MapData map = (MapData)val;
                for (int i = 0; i < map.size(); ++i) {
                    Object keyObj = keyElementGetter.getElementOrNull(map.keyArray(), i);
                    Object fromObj = valueElementGetter.getElementOrNull(map.valueArray(), i);
                    Object toObj = fromObj != null ? converter.convert(fromObj) : null;
                    result.put(keyObj, toObj);
                }
                return new GenericMapData(result);
            }
        };
    }

    private static TypeConverter createNoOpConverter() {
        return new TypeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object val) {
                return val;
            }
        };
    }

    private static TypeConverter createRowConverter(LogicalType fromType, final LogicalType toType) {
        List fromChildren = fromType.getChildren();
        final List toChildren = toType.getChildren();
        final RowData.FieldGetter[] fieldGetters = (RowData.FieldGetter[])IntStream.range(0, fromChildren.size()).mapToObj(i -> RowData.createFieldGetter((LogicalType)((LogicalType)fromChildren.get(i)), (int)i)).toArray(RowData.FieldGetter[]::new);
        final TypeConverter[] converters = (TypeConverter[])IntStream.range(0, fromChildren.size()).mapToObj(i -> {
            LogicalType fromChild = (LogicalType)fromChildren.get(i);
            LogicalType toChild = (LogicalType)toChildren.get(i);
            if (TypeConverters.isPrimitiveTypeRootEqual(fromChild.getTypeRoot(), toChild.getTypeRoot())) {
                return TypeConverters.createNoOpConverter();
            }
            return TypeConverters.getInstance(fromChild, toChild);
        }).toArray(TypeConverter[]::new);
        ValidationUtils.checkState((boolean)Arrays.stream(converters).noneMatch(Objects::isNull));
        return new TypeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object val) {
                RowData row = (RowData)val;
                GenericRowData rowData = new GenericRowData(toType.getChildren().size());
                for (int i = 0; i < toChildren.size(); ++i) {
                    Object fromObj = fieldGetters[i].getFieldOrNull(row);
                    Object toObj = fromObj != null ? converters[i].convert(fromObj) : null;
                    rowData.setField(i, toObj);
                }
                return rowData;
            }
        };
    }

    private static boolean isPrimitiveTypeRootEqual(LogicalTypeRoot fromType, LogicalTypeRoot toType) {
        boolean isComplex = fromType.equals((Object)LogicalTypeRoot.ARRAY) || fromType.equals((Object)LogicalTypeRoot.MAP) || fromType.equals((Object)LogicalTypeRoot.ROW);
        return !isComplex && fromType.equals((Object)toType);
    }

    private static DecimalData toDecimalData(Number val, LogicalType decimalType) {
        BigDecimal valAsDecimal = BigDecimal.valueOf(val.doubleValue());
        return TypeConverters.toDecimalData(valAsDecimal, decimalType);
    }

    private static DecimalData toDecimalData(BigDecimal valAsDecimal, LogicalType decimalType) {
        return DecimalData.fromBigDecimal((BigDecimal)valAsDecimal, (int)((DecimalType)decimalType).getPrecision(), (int)((DecimalType)decimalType).getScale());
    }

    @FunctionalInterface
    public static interface TypeConverter
    extends Serializable {
        public Object convert(Object var1);
    }
}

