/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.hudi.util.DataTypeUtils;

public class AvroSchemaConverter {
    public static DataType convertToDataType(Schema schema) {
        switch (schema.getType()) {
            case RECORD: {
                List schemaFields = schema.getFields();
                DataTypes.Field[] fields = new DataTypes.Field[schemaFields.size()];
                for (int i = 0; i < schemaFields.size(); ++i) {
                    Schema.Field field = (Schema.Field)schemaFields.get(i);
                    fields[i] = DataTypes.FIELD((String)field.name(), (DataType)AvroSchemaConverter.convertToDataType(field.schema()));
                }
                return (DataType)DataTypes.ROW((DataTypes.Field[])fields).notNull();
            }
            case ENUM: 
            case STRING: {
                return (DataType)DataTypes.STRING().notNull();
            }
            case ARRAY: {
                return (DataType)DataTypes.ARRAY((DataType)AvroSchemaConverter.convertToDataType(schema.getElementType())).notNull();
            }
            case MAP: {
                return (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().notNull()), (DataType)AvroSchemaConverter.convertToDataType(schema.getValueType())).notNull();
            }
            case UNION: {
                boolean nullable;
                Schema actualSchema;
                if (schema.getTypes().size() == 2 && ((Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL) {
                    actualSchema = (Schema)schema.getTypes().get(1);
                    nullable = true;
                } else if (schema.getTypes().size() == 2 && ((Schema)schema.getTypes().get(1)).getType() == Schema.Type.NULL) {
                    actualSchema = (Schema)schema.getTypes().get(0);
                    nullable = true;
                } else if (schema.getTypes().size() == 1) {
                    actualSchema = (Schema)schema.getTypes().get(0);
                    nullable = false;
                } else {
                    List<Schema> nonNullTypes = schema.getTypes().stream().filter(s -> s.getType() != Schema.Type.NULL).collect(Collectors.toList());
                    boolean nullable2 = schema.getTypes().size() > nonNullTypes.size();
                    DataType rawDataType = new AtomicDataType((org.apache.flink.table.types.logical.LogicalType)new TypeInformationRawType(false, Types.GENERIC(Object.class))).notNull();
                    if (AvroSchemaConverter.recordTypesOfSameNumFields(nonNullTypes)) {
                        DataType converted = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"wrapper", (DataType)rawDataType)}).notNull();
                        return nullable2 ? (DataType)converted.nullable() : converted;
                    }
                    return nullable2 ? (DataType)rawDataType.nullable() : rawDataType;
                }
                DataType converted = AvroSchemaConverter.convertToDataType(actualSchema);
                return nullable ? (DataType)converted.nullable() : converted;
            }
            case FIXED: {
                if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    LogicalTypes.Decimal decimalType = (LogicalTypes.Decimal)schema.getLogicalType();
                    return (DataType)DataTypes.DECIMAL((int)decimalType.getPrecision(), (int)decimalType.getScale()).notNull();
                }
                return (DataType)DataTypes.VARBINARY((int)schema.getFixedSize()).notNull();
            }
            case BYTES: {
                if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    LogicalTypes.Decimal decimalType = (LogicalTypes.Decimal)schema.getLogicalType();
                    return (DataType)DataTypes.DECIMAL((int)decimalType.getPrecision(), (int)decimalType.getScale()).notNull();
                }
                return (DataType)DataTypes.BYTES().notNull();
            }
            case INT: {
                LogicalType logicalType = schema.getLogicalType();
                if (logicalType == LogicalTypes.date()) {
                    return (DataType)DataTypes.DATE().notNull();
                }
                if (logicalType == LogicalTypes.timeMillis()) {
                    return (DataType)DataTypes.TIME((int)3).notNull();
                }
                return (DataType)DataTypes.INT().notNull();
            }
            case LONG: {
                if (schema.getLogicalType() == LogicalTypes.timestampMillis()) {
                    return (DataType)DataTypes.TIMESTAMP((int)3).notNull();
                }
                if (schema.getLogicalType() == LogicalTypes.localTimestampMillis()) {
                    return (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull();
                }
                if (schema.getLogicalType() == LogicalTypes.timestampMicros()) {
                    return (DataType)DataTypes.TIMESTAMP((int)6).notNull();
                }
                if (schema.getLogicalType() == LogicalTypes.localTimestampMicros()) {
                    return (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)6).notNull();
                }
                if (schema.getLogicalType() == LogicalTypes.timeMillis()) {
                    return (DataType)DataTypes.TIME((int)3).notNull();
                }
                if (schema.getLogicalType() == LogicalTypes.timeMicros()) {
                    return (DataType)DataTypes.TIME((int)6).notNull();
                }
                return (DataType)DataTypes.BIGINT().notNull();
            }
            case FLOAT: {
                return (DataType)DataTypes.FLOAT().notNull();
            }
            case DOUBLE: {
                return (DataType)DataTypes.DOUBLE().notNull();
            }
            case BOOLEAN: {
                return (DataType)DataTypes.BOOLEAN().notNull();
            }
            case NULL: {
                return DataTypes.NULL();
            }
        }
        throw new IllegalArgumentException("Unsupported Avro type '" + schema.getType() + "'.");
    }

    private static boolean recordTypesOfSameNumFields(List<Schema> types) {
        if (types == null || types.size() == 0) {
            return false;
        }
        if (types.stream().anyMatch(s -> s.getType() != Schema.Type.RECORD)) {
            return false;
        }
        int numFields = types.get(0).getFields().size();
        return types.stream().allMatch(s -> s.getFields().size() == numFields);
    }

    public static Schema convertToSchema(org.apache.flink.table.types.logical.LogicalType schema) {
        return AvroSchemaConverter.convertToSchema(schema, "record");
    }

    public static Schema convertToSchema(org.apache.flink.table.types.logical.LogicalType logicalType, String rowName) {
        boolean nullable = logicalType.isNullable();
        switch (logicalType.getTypeRoot()) {
            case NULL: {
                return (Schema)SchemaBuilder.builder().nullType();
            }
            case BOOLEAN: {
                Schema bool = (Schema)SchemaBuilder.builder().booleanType();
                return nullable ? AvroSchemaConverter.nullableSchema(bool) : bool;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: {
                Schema integer = (Schema)SchemaBuilder.builder().intType();
                return nullable ? AvroSchemaConverter.nullableSchema(integer) : integer;
            }
            case BIGINT: {
                Schema bigint = (Schema)SchemaBuilder.builder().longType();
                return nullable ? AvroSchemaConverter.nullableSchema(bigint) : bigint;
            }
            case FLOAT: {
                Schema f = (Schema)SchemaBuilder.builder().floatType();
                return nullable ? AvroSchemaConverter.nullableSchema(f) : f;
            }
            case DOUBLE: {
                Schema d = (Schema)SchemaBuilder.builder().doubleType();
                return nullable ? AvroSchemaConverter.nullableSchema(d) : d;
            }
            case CHAR: 
            case VARCHAR: {
                Schema str = (Schema)SchemaBuilder.builder().stringType();
                return nullable ? AvroSchemaConverter.nullableSchema(str) : str;
            }
            case BINARY: 
            case VARBINARY: {
                Schema binary = (Schema)SchemaBuilder.builder().bytesType();
                return nullable ? AvroSchemaConverter.nullableSchema(binary) : binary;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                LogicalTypes.TimestampMillis timestampLogicalType;
                TimestampType timestampType = (TimestampType)logicalType;
                int precision = timestampType.getPrecision();
                if (precision <= 3) {
                    timestampLogicalType = LogicalTypes.timestampMillis();
                } else if (precision <= 6) {
                    timestampLogicalType = LogicalTypes.timestampMicros();
                } else {
                    throw new IllegalArgumentException("Avro does not support TIMESTAMP type with precision: " + precision + ", it only support precisions <= 6.");
                }
                Schema timestamp = timestampLogicalType.addToSchema((Schema)SchemaBuilder.builder().longType());
                return nullable ? AvroSchemaConverter.nullableSchema(timestamp) : timestamp;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LogicalTypes.LocalTimestampMillis localZonedTimestampLogicalType;
                LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)logicalType;
                int precision = localZonedTimestampType.getPrecision();
                if (precision <= 3) {
                    localZonedTimestampLogicalType = LogicalTypes.localTimestampMillis();
                } else if (precision <= 6) {
                    localZonedTimestampLogicalType = LogicalTypes.localTimestampMicros();
                } else {
                    throw new IllegalArgumentException("Avro does not support LOCAL TIMESTAMP type with precision: " + precision + ", it only support precisions <= 6.");
                }
                Schema localZonedTimestamp = localZonedTimestampLogicalType.addToSchema((Schema)SchemaBuilder.builder().longType());
                return nullable ? AvroSchemaConverter.nullableSchema(localZonedTimestamp) : localZonedTimestamp;
            }
            case DATE: {
                Schema date = LogicalTypes.date().addToSchema((Schema)SchemaBuilder.builder().intType());
                return nullable ? AvroSchemaConverter.nullableSchema(date) : date;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                int precision = ((TimeType)logicalType).getPrecision();
                if (precision > 3) {
                    throw new IllegalArgumentException("Avro does not support TIME type with precision: " + precision + ", it only supports precision less than 3.");
                }
                Schema time = LogicalTypes.timeMillis().addToSchema((Schema)SchemaBuilder.builder().intType());
                return nullable ? AvroSchemaConverter.nullableSchema(time) : time;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)logicalType;
                Schema decimal = LogicalTypes.decimal((int)decimalType.getPrecision(), (int)decimalType.getScale()).addToSchema((Schema)SchemaBuilder.fixed((String)String.format("%s.fixed", rowName)).size(AvroSchemaConverter.computeMinBytesForDecimalPrecision(decimalType.getPrecision())));
                return nullable ? AvroSchemaConverter.nullableSchema(decimal) : decimal;
            }
            case ROW: {
                RowType rowType = (RowType)logicalType;
                List fieldNames = rowType.getFieldNames();
                SchemaBuilder.FieldAssembler builder = SchemaBuilder.builder().record(rowName).fields();
                for (int i = 0; i < rowType.getFieldCount(); ++i) {
                    String fieldName = (String)fieldNames.get(i);
                    org.apache.flink.table.types.logical.LogicalType fieldType = rowType.getTypeAt(i);
                    SchemaBuilder.GenericDefault fieldBuilder = builder.name(fieldName).type(AvroSchemaConverter.convertToSchema(fieldType, rowName + "." + fieldName));
                    builder = fieldType.isNullable() ? fieldBuilder.withDefault(null) : fieldBuilder.noDefault();
                }
                Schema record = (Schema)builder.endRecord();
                return nullable ? AvroSchemaConverter.nullableSchema(record) : record;
            }
            case MULTISET: 
            case MAP: {
                Schema map = (Schema)SchemaBuilder.builder().map().values(AvroSchemaConverter.convertToSchema(AvroSchemaConverter.extractValueTypeToAvroMap(logicalType), rowName));
                return nullable ? AvroSchemaConverter.nullableSchema(map) : map;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)logicalType;
                Schema array = (Schema)SchemaBuilder.builder().array().items(AvroSchemaConverter.convertToSchema(arrayType.getElementType(), rowName));
                return nullable ? AvroSchemaConverter.nullableSchema(array) : array;
            }
        }
        throw new UnsupportedOperationException("Unsupported to derive Schema for type: " + logicalType);
    }

    public static org.apache.flink.table.types.logical.LogicalType extractValueTypeToAvroMap(org.apache.flink.table.types.logical.LogicalType type) {
        org.apache.flink.table.types.logical.LogicalType valueType;
        org.apache.flink.table.types.logical.LogicalType keyType;
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            keyType = mapType.getKeyType();
            valueType = mapType.getValueType();
        } else {
            MultisetType multisetType = (MultisetType)type;
            keyType = multisetType.getElementType();
            valueType = new IntType();
        }
        if (!DataTypeUtils.isFamily(keyType, LogicalTypeFamily.CHARACTER_STRING)) {
            throw new UnsupportedOperationException("Avro format doesn't support non-string as key type of map. The key type is: " + keyType.asSummaryString());
        }
        return valueType;
    }

    private static Schema nullableSchema(Schema schema) {
        return schema.isNullable() ? schema : Schema.createUnion((Schema[])new Schema[]{(Schema)SchemaBuilder.builder().nullType(), schema});
    }

    private static int computeMinBytesForDecimalPrecision(int precision) {
        int numBytes = 1;
        while (Math.pow(2.0, 8 * numBytes - 1) < Math.pow(10.0, precision)) {
            ++numBytes;
        }
        return numBytes;
    }
}

