/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.meta;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hudi.common.util.ValidationUtils;
import org.jetbrains.annotations.NotNull;

public class CkpMessage
implements Serializable,
Comparable<CkpMessage> {
    private static final long serialVersionUID = 1L;
    public static final Comparator<CkpMessage> COMPARATOR = Comparator.comparing(CkpMessage::getInstant).thenComparing(CkpMessage::getState);
    private final String instant;
    private final State state;

    public CkpMessage(String instant, String state) {
        this.instant = instant;
        this.state = State.valueOf(state);
    }

    public CkpMessage(FileStatus fileStatus) {
        String fileName = fileStatus.getPath().getName();
        String[] nameAndExt = fileName.split("\\.");
        ValidationUtils.checkState((nameAndExt.length == 2 ? 1 : 0) != 0);
        String name = nameAndExt[0];
        String ext = nameAndExt[1];
        this.instant = name;
        this.state = State.valueOf(ext);
    }

    public String getInstant() {
        return this.instant;
    }

    public State getState() {
        return this.state;
    }

    public boolean isAborted() {
        return State.ABORTED == this.state;
    }

    public boolean isComplete() {
        return State.COMPLETED == this.state;
    }

    public boolean isInflight() {
        return State.INFLIGHT == this.state;
    }

    public static String getFileName(String instant, State state) {
        return instant + "." + state.name();
    }

    public static List<String> getAllFileNames(String instant) {
        return Arrays.stream(State.values()).map(state -> CkpMessage.getFileName(instant, state)).collect(Collectors.toList());
    }

    @Override
    public int compareTo(@NotNull CkpMessage o) {
        return COMPARATOR.compare(this, o);
    }

    public String toString() {
        return "Ckp{instant='" + this.instant + '\'' + ", state='" + (Object)((Object)this.state) + '\'' + '}';
    }

    public static enum State {
        INFLIGHT,
        ABORTED,
        COMPLETED;

    }
}

