/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.partitioner.profile;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.Path;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.sink.partitioner.profile.DeltaWriteProfile;
import org.apache.hudi.sink.partitioner.profile.EmptyWriteProfile;
import org.apache.hudi.sink.partitioner.profile.WriteProfile;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.util.StreamerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteProfiles {
    private static final Logger LOG = LoggerFactory.getLogger(WriteProfiles.class);
    private static final Map<String, WriteProfile> PROFILES = new HashMap<String, WriteProfile>();

    private WriteProfiles() {
    }

    public static synchronized WriteProfile singleton(boolean ignoreSmallFiles, boolean delta, HoodieWriteConfig config, HoodieFlinkEngineContext context) {
        return PROFILES.computeIfAbsent(config.getBasePath(), k -> WriteProfiles.getWriteProfile(ignoreSmallFiles, delta, config, context));
    }

    private static WriteProfile getWriteProfile(boolean ignoreSmallFiles, boolean delta, HoodieWriteConfig config, HoodieFlinkEngineContext context) {
        if (ignoreSmallFiles) {
            return new EmptyWriteProfile(config, context);
        }
        if (delta) {
            return new DeltaWriteProfile(config, context);
        }
        return new WriteProfile(config, context);
    }

    public static void clean(String path) {
        PROFILES.remove(path);
    }

    public static List<StoragePathInfo> getFilesFromMetadata(Path basePath, Configuration hadoopConf, List<HoodieCommitMetadata> metadataList, HoodieTableType tableType) {
        return WriteProfiles.getFilesFromMetadata(basePath, hadoopConf, metadataList, tableType, true);
    }

    @Nullable
    public static List<StoragePathInfo> getFilesFromMetadata(Path basePath, Configuration hadoopConf, List<HoodieCommitMetadata> metadataList, HoodieTableType tableType, boolean ignoreMissingFiles) {
        HoodieStorage storage = HoodieStorageUtils.getStorage((String)basePath.toString(), (StorageConfiguration)HadoopFSUtils.getStorageConf((Configuration)hadoopConf));
        HashMap<String, StoragePathInfo> uniqueIdToInfoMap = new HashMap<String, StoragePathInfo>();
        for (int i = metadataList.size() - 1; i >= 0; --i) {
            for (Map.Entry<String, StoragePathInfo> entry : WriteProfiles.getFilesToRead(hadoopConf, metadataList.get(i), basePath.toString(), tableType).entrySet()) {
                if (!StreamerUtil.isValidFile(entry.getValue()) || uniqueIdToInfoMap.containsKey(entry.getKey())) continue;
                if (StreamerUtil.fileExists(storage, entry.getValue().getPath())) {
                    uniqueIdToInfoMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (ignoreMissingFiles) continue;
                return null;
            }
        }
        return new ArrayList<StoragePathInfo>(uniqueIdToInfoMap.values());
    }

    private static Map<String, StoragePathInfo> getFilesToRead(Configuration hadoopConf, HoodieCommitMetadata metadata, String basePath, HoodieTableType tableType) {
        switch (tableType) {
            case COPY_ON_WRITE: {
                return metadata.getFileIdToInfo(basePath);
            }
            case MERGE_ON_READ: {
                return metadata.getFullPathToInfo((HoodieStorage)new HoodieHadoopStorage(basePath, hadoopConf), basePath);
            }
        }
        throw new AssertionError();
    }

    public static Option<HoodieCommitMetadata> getCommitMetadataSafely(String tableName, Path basePath, HoodieInstant instant, HoodieTimeline timeline) {
        try {
            byte[] data = (byte[])timeline.getInstantDetails(instant).get();
            TimelineLayout layout = TimelineLayout.fromVersion((TimelineLayoutVersion)timeline.getTimelineLayoutVersion());
            return Option.of((Object)layout.getCommitMetadataSerDe().deserialize(instant, data, HoodieCommitMetadata.class));
        }
        catch (FileNotFoundException fe) {
            LOG.warn("Instant {} was deleted by the cleaner, ignore", (Object)instant.requestedTime());
            return Option.empty();
        }
        catch (Throwable throwable) {
            LOG.error("Get write metadata for table {} with instant {} and path: {} error", new Object[]{tableName, instant.requestedTime(), basePath});
            return Option.empty();
        }
    }

    public static HoodieCommitMetadata getCommitMetadata(String tableName, Path basePath, HoodieInstant instant, HoodieTimeline timeline) {
        try {
            return TimelineUtils.getCommitMetadata((HoodieInstant)instant, (HoodieTimeline)timeline);
        }
        catch (IOException e) {
            LOG.error("Get write metadata for table {} with instant {} and path: {} error", new Object[]{tableName, instant.requestedTime(), basePath});
            throw new HoodieException((Throwable)e);
        }
    }
}

